/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.utils;

import com.ibm.bi.platform.datasetutils.converters.ConverterOptions;
import com.ibm.bi.platform.datasetutils.converters.DecimalPolicy;
import com.ibm.bi.platform.datasetutils.metadata.Column;
import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.types.DecimalType;
import com.ibm.bi.platform.datasetutils.metadata.types.TypeFactory;
import com.ibm.bi.platform.datasetutils.utils.DataTypeConversionException;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetadataUtils {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MetadataUtils.class);

    public static boolean isProperty(Element obj) {
        Attribute attr = obj.attribute("isProperty");
        return attr != null && !"0".equals(attr.getValue());
    }

    public static boolean isTextType(byte type) {
        switch (type) {
            case 1: 
            case 22: 
            case 45: 
            case 46: 
            case 55: 
            case 56: 
            case 100: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSupportedType(byte type) {
        switch (type) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 100: {
                return true;
            }
        }
        return false;
    }

    public static ColumnMetadata generateColumnFromRSVPMasterDataset(String name, byte type, int precision, int scale, int nullsOk) {
        boolean isNullable = nullsOk == 1;
        switch (type) {
            case 51: {
                return new Column(name, isNullable, TypeFactory.BOOLEAN_TYPE);
            }
            case 2: {
                if (0 == scale) {
                    return new Column(name, isNullable, TypeFactory.BYTE_TYPE);
                }
                return new Column(name, isNullable, TypeFactory.getDecimalType(38, scale));
            }
            case 4: {
                if (0 == scale) {
                    return new Column(name, isNullable, TypeFactory.SHORT_TYPE);
                }
                return new Column(name, isNullable, TypeFactory.getDecimalType(38, scale));
            }
            case 6: {
                if (0 == scale) {
                    return new Column(name, isNullable, TypeFactory.INTEGER_TYPE);
                }
                return new Column(name, isNullable, TypeFactory.getDecimalType(38, scale));
            }
            case 8: {
                if (0 == scale) {
                    return new Column(name, isNullable, TypeFactory.LONG_TYPE);
                }
                return new Column(name, isNullable, TypeFactory.getDecimalType(38, scale));
            }
            case 12: 
            case 54: {
                if (0 == scale) {
                    if (precision <= 9) {
                        return new Column(name, isNullable, TypeFactory.INTEGER_TYPE);
                    }
                    if (precision <= 18) {
                        return new Column(name, isNullable, TypeFactory.LONG_TYPE);
                    }
                    return new Column(name, isNullable, TypeFactory.getDecimalType(precision, scale));
                }
                return new Column(name, isNullable, TypeFactory.getDecimalType(precision, scale));
            }
            case 10: {
                return new Column(name, isNullable, TypeFactory.FLOAT_TYPE);
            }
            case 11: {
                return new Column(name, isNullable, TypeFactory.DOUBLE_TYPE);
            }
            case 57: {
                return new Column(name, isNullable, TypeFactory.DATE_TYPE);
            }
            case 58: {
                return new Column(name, isNullable, TypeFactory.TIME_TYPE);
            }
            case 52: {
                return new Column(name, isNullable, TypeFactory.TIME_TZ_TYPE);
            }
            case 59: {
                return new Column(name, isNullable, TypeFactory.TIMESTAMP_TYPE);
            }
            case 53: {
                return new Column(name, isNullable, TypeFactory.TIMESTAMP_TZ_TYPE);
            }
            case 16: 
            case 60: {
                return new Column(name, isNullable, TypeFactory.INTERVAL_DAY_TIME_TYPE);
            }
            case 17: {
                return new Column(name, isNullable, TypeFactory.INTERVAL_YEAR_MONTH_TYPE);
            }
        }
        if (MetadataUtils.isTextType(type)) {
            return new Column(name, isNullable, TypeFactory.STRING_TYPE);
        }
        LOGGER.warn("Column (name={}) has an unsupported data type (cclTypeCode={}). It will be coerced to a STRING type.", (Object)name, (Object)type);
        return new Column(name, isNullable, TypeFactory.STRING_TYPE);
    }

    public static DecimalType adjustDecimalType(String columnName, DecimalType providedType, ConverterOptions converterOptions) {
        if (38 >= providedType.getPrecision()) {
            return providedType;
        }
        if (DecimalPolicy.LEAST_SIGNIFICANT_DIGITS_REMOVAL == converterOptions.getDecimalPolicy()) {
            int truncatedDigits = providedType.getPrecision() - 38;
            if (providedType.getScale() < 0) {
                truncatedDigits *= -1;
            }
            if (Math.abs(providedType.getScale()) <= Math.abs(truncatedDigits)) {
                return TypeFactory.getDecimalType(38, 0);
            }
            return TypeFactory.getDecimalType(38, providedType.getScale() - truncatedDigits);
        }
        if (38 < providedType.getScale()) {
            throw new DataTypeConversionException(columnName, providedType, String.format("Cannot truncate decimal values. Original scale (%s) for column '%s' is bigger than supported max precision (%s).", providedType.getScale(), columnName, 38));
        }
        return TypeFactory.getDecimalType(38, providedType.getScale());
    }
}

