/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.OptionsRunnable;
import com.cognos.dls.OptionsValidator;
import com.cognos.dls.fs.ArchiveOptionsException;
import com.cognos.dls.fs.ArchiveOptionsProcessor;
import com.cognos.dls.fs.OutputPropertiesBean;
import com.cognos.dls.fs.ReportOutputBuilder;
import com.cognos.dls.fs.ReportOutputException;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import org.apache.axis.AxisFault;

public class ArchiveOptionsRunnable
extends OptionsRunnable {
    public ArchiveOptionsRunnable(OptionsValidator validator, SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options, BiBusHeader header) throws LocalizableException {
        super(validator, objectPath, parameterValues, options);
        this.setHeaders(header);
    }

    @Override
    public void run() throws AxisFault, LocalizableException {
        try {
            ArchiveOptionsProcessor processor = new ArchiveOptionsProcessor(this.getOptions(), this.getHeaders());
            OutputPropertiesBean props = processor.getProperties();
            ReportOutputBuilder reportOutputBuilder = new ReportOutputBuilder(props, this.getHeaders());
            reportOutputBuilder.writeOutputs();
        }
        catch (ReportOutputException ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Cannot process the report outputs");
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)ex);
            throw ex;
        }
        catch (ArchiveOptionsException ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Cannot process the archive options");
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)ex);
            throw ex;
        }
    }
}

