/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls;

import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HistoryTopicsProcessor {
    private Map m_topicValues = new HashMap();

    public HistoryTopicsProcessor(ParameterValue[] parameterValues) {
        for (int i = 0; parameterValues != null && i < parameterValues.length; ++i) {
            String topicName = parameterValues[i].getName();
            String value = parameterValues[i].getName();
            ParmValueItem[] valueItems = parameterValues[i].getValue();
            if (valueItems[0] instanceof SimpleParmValueItem) {
                SimpleParmValueItem valueItem = (SimpleParmValueItem)valueItems[0];
                value = valueItem.getDisplay();
            }
            this.m_topicValues.put(topicName, value);
        }
    }

    public boolean hasTopics() {
        return this.m_topicValues != null && !this.m_topicValues.isEmpty();
    }

    public String replace(String source, int name_length) {
        if (source == null || source.length() == 0 || source.indexOf("[") == -1) {
            return source;
        }
        Set keyset = this.m_topicValues.keySet();
        for (String topicName : keyset) {
            String topicValue = (String)this.m_topicValues.get(topicName);
            if (name_length >= 0 && topicValue != null && topicValue.length() > name_length) {
                topicValue = topicValue.substring(0, name_length);
            }
            source = source.replaceAll(topicName, topicValue);
        }
        return source;
    }

    public String replace(String source) {
        return this.replace(source, -1);
    }
}

