/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AddressSMTPProp;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.BooleanProp;
import com.cognos.developer.schemas.bibus._3.Nil;
import com.cognos.developer.schemas.bibus._3.Pinboard;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.api.DeliveryServiceHandlerException;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.util.ArrayList;
import java.util.List;

public class NotificationList {
    private BaseAgentDefinition _agent = null;
    private BaseReport _report = null;
    private Pinboard _pinboard = null;

    public NotificationList(BaseClass baseObject) throws DeliveryServiceHandlerException {
        if (baseObject == null) {
            throw new DeliveryServiceHandlerException(I18NCode.MSG_OBJECT_IS_NULL);
        }
        if (baseObject instanceof BaseAgentDefinition) {
            this._agent = (BaseAgentDefinition)baseObject;
        } else if (baseObject instanceof BaseReport) {
            this._report = (BaseReport)baseObject;
        } else if (baseObject instanceof Pinboard) {
            this._pinboard = (Pinboard)baseObject;
        } else {
            String path = baseObject.getSearchPath() != null ? baseObject.getSearchPath().getValue() : "";
            throw new DeliveryServiceHandlerException(DlsI18NCode.MSG_DS_INVALID_NOTIFICATION_OBJECT, new String[]{path});
        }
    }

    public BaseClass getBaseClass() {
        BaseReport result = null;
        if (null != this._report) {
            result = this._report;
        } else if (null != this._agent) {
            result = this._agent;
        } else if (null != this._pinboard) {
            result = this._pinboard;
        }
        return result;
    }

    public void add(String user) throws DeliveryServiceHandlerException {
        if (user == null) {
            throw new DeliveryServiceHandlerException(I18NCode.MSG_OBJECT_IS_NULL);
        }
        BaseClass[] accounts = this.getAccountList();
        if (accounts != null && accounts.length > 0 && this.locateUserInList(accounts, user) != -1) {
            throw new DeliveryServiceHandlerException(DlsI18NCode.MSG_DS_USER_ALREADY_SUBSCRIBED);
        }
        Nil account = new Nil();
        StringProp sp = new StringProp();
        sp.setValue(user);
        account.setSearchPath(sp);
        if (accounts == null || accounts.length == 0) {
            accounts = new BaseClass[]{account};
        } else {
            BaseClass[] newlist = new BaseClass[accounts.length + 1];
            System.arraycopy(accounts, 0, newlist, 0, accounts.length);
            newlist[accounts.length] = account;
            accounts = newlist;
        }
        this.setAccountList(accounts);
    }

    public void remove(String user) throws DeliveryServiceHandlerException {
        BaseClass[] newlist;
        if (user == null) {
            throw new DeliveryServiceHandlerException(I18NCode.MSG_OBJECT_IS_NULL);
        }
        BaseClass[] accounts = this.getAccountList();
        if (accounts == null || accounts.length == 0) {
            throw new DeliveryServiceHandlerException(DlsI18NCode.MSG_DS_USER_NOT_SUBSCRIBED);
        }
        int pos = this.locateUserInList(accounts, user);
        if (pos != -1) {
            newlist = new BaseClass[accounts.length - 1];
            int np = 0;
            for (int i = 0; i != accounts.length; ++i) {
                if (i == pos) continue;
                newlist[np++] = accounts[i];
            }
        } else {
            throw new DeliveryServiceHandlerException(DlsI18NCode.MSG_DS_USER_NOT_SUBSCRIBED);
        }
        accounts = newlist;
        this.setAccountList(accounts);
    }

    public void removeAll() {
        this.setAccountList(new BaseClass[0]);
    }

    public boolean contains(String user) throws DeliveryServiceHandlerException {
        if (user == null) {
            throw new DeliveryServiceHandlerException(I18NCode.MSG_OBJECT_IS_NULL);
        }
        BaseClass[] accounts = this.getAccountList();
        if (accounts == null || accounts.length == 0) {
            return false;
        }
        int pos = this.locateUserInList(this.getAccountList(), user);
        return pos != -1;
    }

    public List<String> getAllUsers() throws DeliveryServiceHandlerException {
        BaseClass[] accounts = this.getAccountList();
        ArrayList<String> results = new ArrayList<String>();
        if (accounts != null && accounts.length > 0) {
            for (int i = 0; i != accounts.length; ++i) {
                results.add(accounts[i].getSearchPath().getValue());
            }
        }
        return results;
    }

    public boolean isEnabled() {
        return this._agent != null ? ObjectModelUtil.getBoolean((BooleanProp)this._agent.getAllowNotification()) : (this._report != null ? ObjectModelUtil.getBoolean((BooleanProp)this._report.getAllowNotification()) : this._pinboard != null);
    }

    public List getAddresses(JobBiBusHeaders headers) throws DeliveryServiceHandlerException {
        ArrayList<String> addresses = new ArrayList<String>();
        BaseClass[] accounts = this.getAccountList();
        if (null != accounts) {
            ArrayList<QueryRequest> requests = new ArrayList<QueryRequest>(accounts.length);
            PropEnum[] props = new PropEnum[]{PropEnum.notificationEMail, PropEnum.email};
            QueryOptions options = new QueryOptions();
            for (int i = 0; i < accounts.length; ++i) {
                QueryRequest request = new QueryRequest();
                request.setOptions(options);
                request.setProperties(props);
                request.setSearch(accounts[i].getSearchPath().getValue());
                requests.add(request);
            }
            ContentManagerServiceClientPort cm = null;
            try {
                cm = Client.instance().getContentManagerServiceClient(headers);
                cm.signNextRequest("DLS");
                QueryReply[] replies = cm.queryMultiple(requests.toArray(new QueryRequest[requests.size()]));
                for (int i = 0; replies != null && i < replies.length; ++i) {
                    String email = null;
                    BaseClass[] baseClasses = replies[i].getQueryResult();
                    for (int j = 0; j < baseClasses.length; ++j) {
                        AddressSMTPProp emailProp = null;
                        StringProp defaultEmailProp = null;
                        if (!(baseClasses[j] instanceof Account)) continue;
                        Account account = (Account)baseClasses[j];
                        emailProp = account.getNotificationEMail();
                        defaultEmailProp = account.getEmail();
                        if (emailProp != null && emailProp.getValue() != null && emailProp.getValue().get_value() != null) {
                            email = emailProp.getValue().get_value();
                        } else if (defaultEmailProp != null && defaultEmailProp.getValue() != null) {
                            email = defaultEmailProp.getValue();
                        }
                        if (email == null || addresses.contains(email)) continue;
                        addresses.add(email);
                    }
                }
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)e);
                String path = this.getBaseClass().getSearchPath().getValue();
                SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).debug("[SDKClientException] Error retrieving notification email property for recipients on the notification list of object at :" + path);
                throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_QUERY_ERROR, new Object[]{path}, (LocalizableException)e);
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)e);
                String path = this.getBaseClass().getSearchPath().getValue();
                SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).debug("[EMFSecurityException] Error retrieving notification email property for recipients on the notification list of object at :" + path);
                throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_QUERY_ERROR, new Object[]{path});
            }
            finally {
                if (cm != null) {
                    cm.close();
                }
            }
        }
        return addresses;
    }

    private BaseClass[] getAccountList() {
        BaseClass[] result = null;
        if (this._report != null) {
            result = this._report.getNotificationList().getValue();
        } else if (this._pinboard != null) {
            if (null != this._pinboard.getNotificationList()) {
                result = this._pinboard.getNotificationList().getValue();
            }
        } else {
            result = this._agent.getNotificationList().getValue();
        }
        return result;
    }

    private void setAccountList(BaseClass[] accounts) {
        BaseClassArrayProp prop = new BaseClassArrayProp();
        prop.setValue(accounts);
        if (this._report != null) {
            this._report.setNotificationList(prop);
        } else if (this._agent != null) {
            this._agent.setNotificationList(prop);
        } else if (this._pinboard != null) {
            this._pinboard.setNotificationList(prop);
        }
    }

    private int locateUserInList(BaseClass[] array, String user) {
        if (array != null) {
            for (int i = 0; i != array.length; ++i) {
                if (!array[i].getSearchPath().getValue().equals(user)) continue;
                return i;
            }
        }
        return -1;
    }
}

