/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.OptionsValidator;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import org.apache.axis.AxisFault;

public abstract class OptionsRunnable {
    private BiBusHeader m_headers;
    private JobBiBusHeaders m_job_headers;
    private OptionsValidator m_validator;
    private SearchPathSingleObject m_objectPath;
    private Option[] m_options;
    private ParameterValue[] m_parameterValues;

    public OptionsRunnable(OptionsValidator validator, SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) throws LocalizableException {
        this.setValidator(validator);
        this.setObjectPath(objectPath);
        this.setOptions(options);
        this.setParameterValues(parameterValues);
        validator.runTimeValidate(options);
    }

    public OptionsRunnable(OptionsValidator validator, GuidProp objectPath, ParameterValue[] parameterValues, Option[] options) throws LocalizableException {
        this.setValidator(validator);
        this.setObjectPath(ObjectModelUtil.getSearchPath((Guid)objectPath.getValue()));
        this.setOptions(options);
        this.setParameterValues(parameterValues);
        validator.runTimeValidate(options);
    }

    public abstract void run() throws LocalizableException, AxisFault;

    public I18NMessage[] validate() throws AxisFault {
        I18NMessage[] messages = new I18NMessage[]{};
        try {
            messages = this.getValidator().validate(this.getOptions());
        }
        catch (LocalizableException e) {
            messages = new I18NMessage[]{new I18NMessage(e)};
        }
        return messages;
    }

    public SearchPathSingleObject getObjectPath() {
        return this.m_objectPath;
    }

    public void setObjectPath(SearchPathSingleObject objectPath) {
        this.m_objectPath = objectPath;
    }

    public Option[] getOptions() {
        return this.m_options;
    }

    public void setOptions(Option[] options) {
        this.m_options = options;
    }

    public OptionsValidator getValidator() {
        return this.m_validator;
    }

    public void setValidator(OptionsValidator validator) {
        this.m_validator = validator;
    }

    public BiBusHeader getHeaders() throws AxisFault {
        if (this.m_headers == null) {
            this.m_headers = BiBusUtilities.extractBiBusHeader();
        }
        return this.m_headers;
    }

    public JobBiBusHeaders getJobHeaders() throws AxisFault {
        if (this.m_job_headers == null) {
            this.m_job_headers = new JobBiBusHeaders(this.getHeaders());
        }
        return this.m_job_headers;
    }

    public void setHeaders(BiBusHeader headers) {
        this.m_headers = headers;
    }

    public ParameterValue[] getParameterValues() {
        return this.m_parameterValues;
    }

    public void setParameterValues(ParameterValue[] parameterValues) {
        this.m_parameterValues = parameterValues;
    }
}

