/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls;

import com.cognos.developer.schemas.bibus._3.ArchiveOption;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseRSSTask;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.Memo;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.RssOption;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.ArchiveOptionsRunnable;
import com.cognos.dls.OptionsRunnable;
import com.cognos.dls.OptionsRunnableFactoryException;
import com.cognos.dls.OptionsValidator;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.rss.RssOptionsRunnable;
import com.cognos.dls.smtp.DeliveryOptionsRunnable;
import com.cognos.dls.smtp.DeliveryOptionsValidator;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.OptionUtils;

public class OptionsRunnableFactory {
    public static OptionsRunnable getRunnable(SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options, BiBusHeader header) throws LocalizableException {
        OptionsRunnable runnable = null;
        QueryRequest rssRequest = new QueryRequest();
        if (objectPath != null) {
            rssRequest.setSearch(objectPath.get_value());
        }
        rssRequest.setProperties(new PropEnum[]{PropEnum.searchPath});
        JobBiBusHeaders jobHeader = new JobBiBusHeaders(header);
        ContentManagerServiceClientPort cmscp = null;
        try {
            BaseClass base = null;
            if (objectPath != null) {
                cmscp = Client.instance().getContentManagerServiceClient(jobHeader);
                base = cmscp.query(rssRequest);
            }
            if (base instanceof BaseRSSTask) {
                runnable = RssOptionsRunnable.getRunnable(objectPath, parameterValues, options, header);
            } else if (base instanceof Memo) {
                DeliveryOptionsValidator oneValidator = new DeliveryOptionsValidator(header);
                runnable = new DeliveryOptionsRunnable(oneValidator, objectPath, parameterValues, options, header);
            } else if (OptionUtils.findOptionsByType((Option[])options, ArchiveOption.class).length > 0) {
                runnable = new ArchiveOptionsRunnable(OptionsValidator.NULL_VALIDATOR, objectPath, parameterValues, options, header);
            } else if (OptionUtils.findOptionsByType((Option[])options, RssOption.class).length > 0) {
                runnable = RssOptionsRunnable.getRunnable(objectPath, parameterValues, options, header);
            } else if (OptionUtils.findOptionsByType((Option[])options, DeliveryOption.class).length > 0) {
                DeliveryOptionsValidator oneValidator = new DeliveryOptionsValidator(header);
                runnable = new DeliveryOptionsRunnable(oneValidator, objectPath, parameterValues, options, header);
            }
        }
        catch (Throwable t) {
            throw new OptionsRunnableFactoryException(DlsI18NCode.MSG_DS_GENERAL_ERROR);
        }
        finally {
            if (cmscp != null) {
                cmscp.close();
            }
        }
        if (runnable == null) {
            throw new OptionsRunnableFactoryException(DlsI18NCode.MSG_DS_INVALID_OPTIONS);
        }
        return runnable;
    }
}

