/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.api;

import com.cognos.developer.schemas.bibus._3.AddressSMTP;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionAddressSMTPArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObjectLinks;
import com.cognos.developer.schemas.bibus._3.NmtokenArrayProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.api.DeliveryServiceHandlerException;
import com.cognos.dls.api.EmailCapabilityPojo;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.util.OptionUtils;

public class DeliveryServiceCapabilityChecker {
    private BiBusHeader m_header;

    public DeliveryServiceCapabilityChecker() {
    }

    public DeliveryServiceCapabilityChecker(BiBusHeader bibusHeader) {
        this.m_header = bibusHeader;
    }

    public EmailCapabilityPojo checkEmailCapability() throws DeliveryServiceHandlerException {
        EmailCapabilityPojo _EmailCapabilityPojo = new EmailCapabilityPojo();
        try {
            NmtokenArrayProp extendedUserCapabilitiesProps = AuthenticatorFactory.getInstance().getExtendedUserCapabilities(this.m_header);
            _EmailCapabilityPojo.setCanEmail(AuthenticatorFactory.getInstance().hasCapability(extendedUserCapabilitiesProps, UserCapabilityEnum.canEmail));
            _EmailCapabilityPojo.setCanAttach(AuthenticatorFactory.getInstance().hasCapability(extendedUserCapabilitiesProps, UserCapabilityEnum.canAttach));
            _EmailCapabilityPojo.setCanShareUsingEmail(AuthenticatorFactory.getInstance().hasCapability(extendedUserCapabilitiesProps, UserCapabilityEnum.canShareUsingEmail));
            _EmailCapabilityPojo.setCanTypeInEmail(AuthenticatorFactory.getInstance().hasCapability(extendedUserCapabilitiesProps, UserCapabilityEnum.canTypeInEmail));
            _EmailCapabilityPojo.setCanIncludeLinkInEmail(AuthenticatorFactory.getInstance().hasCapability(extendedUserCapabilitiesProps, UserCapabilityEnum.canIncludeLinkInEmail));
            _EmailCapabilityPojo.setCanEmailAsDeliveryOption(AuthenticatorFactory.getInstance().hasCapability(extendedUserCapabilitiesProps, UserCapabilityEnum.canEmailAsDeliveryOption));
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).error("Unable to retrieve the capabilities for the current user.");
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
            throw new DeliveryServiceHandlerException(I18NCode.MSG_INSUFFICIENT_USER_CAPABILITIES);
        }
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("User credentials:" + _EmailCapabilityPojo.toString());
        return _EmailCapabilityPojo;
    }

    public boolean checkCanUseEmail() throws DeliveryServiceHandlerException {
        EmailCapabilityPojo emailCapPojo = this.checkEmailCapability();
        boolean found = false;
        try {
            found = emailCapPojo.canEmail();
            if (!found) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Current user does not have canEmail capability.");
                throw new DeliveryServiceHandlerException(DlsI18NCode.SEC_NO_PRIVILEGES);
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Unable to retrieve the capabilities for the current user.");
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
            throw new DeliveryServiceHandlerException(I18NCode.MSG_INSUFFICIENT_USER_CAPABILITIES);
        }
        return found;
    }

    public boolean hasAttachmentAndCapability(EmailCapabilityPojo emailCapPojo, Option[] options) throws DeliveryServiceHandlerException {
        boolean allok = false;
        if (!this.hasAttachmentinEmail(options) || !emailCapPojo.canAttach) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Current user does not have canAttach capability.");
            throw new DeliveryServiceHandlerException(DlsI18NCode.SEC_NO_PRIVILEGES);
        }
        allok = true;
        return allok;
    }

    public boolean hasEmailCapability() throws DeliveryServiceHandlerException {
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("checking hasEmailCapability");
        EmailCapabilityPojo emailCapPojo = this.checkEmailCapability();
        return emailCapPojo.canEmail;
    }

    public boolean isCapabilitiesAllOkForEmailOptions(Option[] options, String namepsaceId) throws DeliveryServiceHandlerException {
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("email namespaceid:" + namepsaceId);
        EmailCapabilityPojo emailCapPojo = this.checkEmailCapability();
        boolean allok = emailCapPojo.canEmail;
        try {
            if (!allok) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Current user does not have canEmail capability.");
                throw new DeliveryServiceHandlerException(DlsI18NCode.SEC_NO_PRIVILEGES);
            }
            if (allok && this.hasLinksinEmail(options) && !emailCapPojo.canIncludeLinkInEmail) {
                allok = false;
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Current user does not have canIncludeLinkInEmail capability.");
                throw new DeliveryServiceHandlerException(DlsI18NCode.SEC_NO_PRIVILEGES);
            }
            if (allok && this.hasAttachmentinEmail(options) && !emailCapPojo.canAttach) {
                allok = false;
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Current user does not have canAttach capability.");
                throw new DeliveryServiceHandlerException(DlsI18NCode.SEC_NO_PRIVILEGES);
            }
            if (allok && this.hasExternalEmailAddress(options, namepsaceId) && !emailCapPojo.canTypeInEmail) {
                allok = false;
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Current user does not have canTypeInEmail capability.");
                throw new DeliveryServiceHandlerException(DlsI18NCode.SEC_NO_PRIVILEGES);
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Unable to retrieve the capabilities for the current user.");
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
            throw new DeliveryServiceHandlerException(I18NCode.MSG_INSUFFICIENT_USER_CAPABILITIES);
        }
        return allok;
    }

    private boolean hasLinksinEmail(Option[] options) {
        MemoPartComposite mp;
        MemoPart[] memos;
        MemoPart memoPart;
        DeliveryOptionMemoPart domp;
        boolean result = false;
        Option[] memoparts = OptionUtils.findOptionsByType((Option[])options, DeliveryOptionMemoPart.class);
        if (memoparts != null && memoparts.length > 0 && memoparts[0] instanceof DeliveryOptionMemoPart && null != (domp = (DeliveryOptionMemoPart)memoparts[0]) && (memoPart = domp.getValue()) instanceof MemoPartComposite && (memos = (mp = (MemoPartComposite)domp.getValue()).getParts()) != null) {
            int isz = memos.length;
            for (int i = 0; i < isz; ++i) {
                if (memos[i] == null || !MemoPartObjectLinks.class.isAssignableFrom(memos[i].getClass())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean hasAttachmentinEmail(Option[] options) {
        MemoPart memoPart;
        DeliveryOptionMemoPart domp;
        boolean result = false;
        Option[] memoparts = OptionUtils.findOptionsByType((Option[])options, DeliveryOptionMemoPart.class);
        if (memoparts != null && memoparts.length > 0 && memoparts[0] instanceof DeliveryOptionMemoPart && null != (domp = (DeliveryOptionMemoPart)memoparts[0]) && (memoPart = domp.getValue()) instanceof MemoPartMIMEAttachment) {
            return true;
        }
        return result;
    }

    private boolean hasExternalEmailAddress(Option[] options, String emailDomain) {
        boolean hasExternal = false;
        Option[] addresses = OptionUtils.findOptionsByType((Option[])options, DeliveryOptionAddressSMTPArray.class);
        if (null != addresses && addresses.length > 0) {
            for (int j = 0; j < addresses.length; ++j) {
                DeliveryOptionAddressSMTPArray stringArray = (DeliveryOptionAddressSMTPArray)addresses[j];
                AddressSMTP[] addressSMTPs = stringArray.getValue();
                for (int i = 0; i < addressSMTPs.length; ++i) {
                    if (addressSMTPs[i].get_value() == null) continue;
                    hasExternal = true;
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("There is an external address:" + addressSMTPs[i].get_value());
                    break;
                }
                if (hasExternal) break;
            }
        }
        return hasExternal;
    }
}

