/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.api;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AddressSMTP;
import com.cognos.developer.schemas.bibus._3.AddressSMTPProp;
import com.cognos.developer.schemas.bibus._3.AgentNotificationStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailAgentNotificationStatus;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Credential;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.Pinboard;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.NotificationList;
import com.cognos.dls.OptionsRunnable;
import com.cognos.dls.OptionsRunnableFactory;
import com.cognos.dls.api.DeliveryServiceHandlerException;
import com.cognos.dls.api.DeliveryServiceImpl;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.util.PinboardClient;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.I18NMessageUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.UserAccountUtil;
import org.apache.axis.AxisFault;

public class DeliveryServiceHandler {
    private Account m_account;
    private final JobBiBusHeaders m_headers;
    private static final String ALL_NOTIFICATIONS = "//*[containsReferences(@notificationList, ~)]";
    private static final String DEFAULT_EMAIL = "notifications@cognos.ibm.com";
    private static final SDSLogger AUDIT_LOGGER = SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT);

    public DeliveryServiceHandler(BiBusHeader a_headers) {
        this(a_headers, true);
    }

    public DeliveryServiceHandler(BiBusHeader a_headers, boolean isAccountRequired) {
        this.m_headers = new JobBiBusHeaders(a_headers);
        if (isAccountRequired) {
            this.initializeAccount();
        }
    }

    void initializeAccount() {
        this.m_account = this.getAccount();
    }

    public void addNotification(SearchPathSingleObject path) throws LocalizableException {
        ContentManagerServiceClientPort cm = this.getCMPort();
        try {
            BaseClass notificationObject = this.getNotificationObject(path);
            if (notificationObject instanceof Pinboard) {
                Pinboard pinboard = (Pinboard)notificationObject;
                String pinboardId = pinboard.getStoreID().getValue().get_value();
                String accountSearchPath = this.m_account.getSearchPath().getValue();
                String mobileDeviceSearchPath = PinboardClient.queryMobileDeviceSearchPath(this.m_headers, accountSearchPath);
                PinboardClient.addPinboardSubscriber(this.m_headers.getBiBusHeader(), pinboardId, accountSearchPath, mobileDeviceSearchPath);
            } else {
                BaseClass[] baseClassArray;
                NotificationList list = new NotificationList(notificationObject);
                list.add(this.getAccountPath());
                boolean updateAccount = this.validateNotificationEmail();
                cm.signNextRequest("DLS");
                StringProp emailProperty = this.m_account.getEmail();
                TokenProp defaultNameProperty = this.m_account.getDefaultName();
                StringProp userNameProperty = this.m_account.getUserName();
                StringProp givenNameProperty = this.m_account.getGivenName();
                StringProp surNameProperty = this.m_account.getSurname();
                if (updateAccount) {
                    if (this.m_account.getEmail() != null && this.m_account.getEmail().getSchemaInfo() != null && !this.m_account.getEmail().getSchemaInfo().isModifiable()) {
                        this.m_account.setEmail(null);
                    }
                    if (this.m_account.getDefaultName() != null && this.m_account.getDefaultName().getSchemaInfo() != null && !this.m_account.getDefaultName().getSchemaInfo().isModifiable()) {
                        this.m_account.setDefaultName(null);
                    }
                    if (this.m_account.getUserName() != null && this.m_account.getUserName().getSchemaInfo() != null && !this.m_account.getUserName().getSchemaInfo().isModifiable()) {
                        this.m_account.setUserName(null);
                    }
                    if (this.m_account.getGivenName() != null && this.m_account.getGivenName().getSchemaInfo() != null && !this.m_account.getGivenName().getSchemaInfo().isModifiable()) {
                        this.m_account.setGivenName(null);
                    }
                    if (this.m_account.getSurname() != null && this.m_account.getSurname().getSchemaInfo() != null && !this.m_account.getSurname().getSchemaInfo().isModifiable()) {
                        this.m_account.setSurname(null);
                    }
                }
                if (updateAccount) {
                    BaseClass[] baseClassArray2 = new BaseClass[2];
                    baseClassArray2[0] = list.getBaseClass();
                    baseClassArray = baseClassArray2;
                    baseClassArray2[1] = this.m_account;
                } else {
                    BaseClass[] baseClassArray3 = new BaseClass[1];
                    baseClassArray = baseClassArray3;
                    baseClassArray3[0] = list.getBaseClass();
                }
                BaseClass[] classes = baseClassArray;
                cm.update(classes, new UpdateOptions());
                this.m_account.setEmail(emailProperty);
                this.m_account.setDefaultName(defaultNameProperty);
                this.m_account.setUserName(userNameProperty);
                this.m_account.setGivenName(givenNameProperty);
                this.m_account.setSurname(surNameProperty);
            }
        }
        catch (Exception e) {
            AUDIT_LOGGER.debug((Throwable)e);
            throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_UPDATE_ERROR, new Object[]{path.get_value()});
        }
        finally {
            cm.close();
        }
    }

    public void removeNotification(SearchPathSingleObject path) throws LocalizableException {
        ContentManagerServiceClientPort cm = this.getCMPort();
        try {
            BaseClass notificationObject = this.getNotificationObject(path);
            if (notificationObject instanceof Pinboard) {
                Pinboard pinboard = (Pinboard)notificationObject;
                String pinboardId = pinboard.getStoreID().getValue().get_value();
                String accountSearchPath = this.m_account.getSearchPath().getValue();
                PinboardClient.removePinboardSubscriber(pinboardId, accountSearchPath);
            } else {
                NotificationList list = new NotificationList(notificationObject);
                list.remove(this.getAccountPath());
                cm.signNextRequest("DLS");
                cm.update(new BaseClass[]{list.getBaseClass()}, null);
            }
        }
        catch (Exception e) {
            AUDIT_LOGGER.debug((Throwable)e);
            throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_UPDATE_ERROR, new Object[]{path.get_value()});
        }
        finally {
            cm.close();
        }
    }

    public void clearNotifications(SearchPathSingleObject path) throws LocalizableException {
        ContentManagerServiceClientPort cm = this.getCMPort();
        try {
            BaseClass target = this.getNotificationObject(path);
            if (!AuthenticatorFactory.getInstance().hasPermissions(target, new String[]{"write", "setPolicy"})) {
                throw new DeliveryServiceHandlerException(DlsI18NCode.SEC_NO_PRIVILEGES);
            }
            NotificationList list = new NotificationList(target);
            list.removeAll();
            cm.signNextRequest("DLS");
            cm.update(new BaseClass[]{list.getBaseClass()}, null);
        }
        catch (EMFSecurityException e) {
            AUDIT_LOGGER.debug((Throwable)e);
            throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_UPDATE_ERROR, new Object[]{path.get_value()});
        }
        finally {
            cm.close();
        }
    }

    public AsynchReply queryNotification(SearchPathSingleObject path) throws Exception {
        BaseClass notificationObject = this.getNotificationObject(path);
        AsynchReply reply = new AsynchReply();
        AsynchDetailAgentNotificationStatus status = new AsynchDetailAgentNotificationStatus();
        if (notificationObject instanceof Pinboard) {
            Pinboard pinboard = (Pinboard)notificationObject;
            String pinboardId = pinboard.getStoreID().getValue().get_value();
            String accountSearchPath = this.m_account.getSearchPath().getValue();
            boolean isSubscriber = PinboardClient.isSubscriber(this.m_headers.getBiBusHeader(), pinboardId, accountSearchPath);
            status.setStatus(isSubscriber ? AgentNotificationStatusEnum.on : AgentNotificationStatusEnum.off);
        } else {
            NotificationList list = new NotificationList(notificationObject);
            if (list.isEnabled()) {
                boolean onList = list.contains(this.getAccountPath());
                status.setStatus(onList ? AgentNotificationStatusEnum.on : AgentNotificationStatusEnum.off);
            } else {
                status.setStatus(AgentNotificationStatusEnum.disabled);
            }
        }
        reply.setDetails(new AsynchDetail[]{status});
        reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
        return reply;
    }

    public BaseClass getNotificationList(SearchPathSingleObject path) throws LocalizableException {
        BaseClass[] bc;
        if (path == null) {
            throw new DeliveryServiceHandlerException(I18NCode.MSG_OBJECT_IS_NULL);
        }
        PropEnum[] props = new PropEnum[]{PropEnum.notificationList, PropEnum.searchPath, PropEnum.permissions};
        String objectPath = path.get_value();
        ContentManagerServiceClientPort cmPort = null;
        try {
            cmPort = this.getCMPort();
            cmPort.signNextRequest("DLS");
            bc = cmPort.query(new SearchPathMultipleObject(objectPath), props, null, null);
        }
        catch (SDKClientException e) {
            AUDIT_LOGGER.log(SDSLevel.ERROR, (LocalizableException)((Object)e));
            AUDIT_LOGGER.debug("[SDKClientException] Error retrieving notification object at :" + path.get_value());
            throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_QUERY_ERROR, new Object[]{path.get_value()}, (LocalizableException)((Object)e));
        }
        catch (EMFSecurityException e) {
            AUDIT_LOGGER.log(SDSLevel.ERROR, (Throwable)e);
            AUDIT_LOGGER.debug("[EMFSecurityException] Error retrieving notification object at :" + path.get_value());
            throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_QUERY_ERROR, new Object[]{path.get_value()});
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        if (bc == null || bc.length == 0) {
            throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_QUERY_ERROR, new String[]{path.get_value()});
        }
        BaseClass notifList = null;
        if (bc[0] instanceof BaseAgentDefinition || bc[0] instanceof BaseReport) {
            boolean hasPermission = AuthenticatorFactory.getInstance().hasPermission(bc[0], "write");
            if (hasPermission) {
                notifList = bc[0];
            }
        } else {
            throw new DeliveryServiceHandlerException(DlsI18NCode.MSG_DS_INVALID_NOTIFICATION_OBJECT, new String[]{path.get_value()});
        }
        return notifList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNotifications() throws LocalizableException {
        ContentManagerServiceClientPort cm = this.getCMPort();
        try {
            PropEnum[] props = new PropEnum[]{PropEnum.notificationList, PropEnum.searchPath};
            BaseClass[] bc = null;
            try {
                cm.signNextRequest("DLS");
                bc = cm.query(new SearchPathMultipleObject(ALL_NOTIFICATIONS), props, null, null);
            }
            catch (EMFSecurityException e) {
                AUDIT_LOGGER.debug((Throwable)e);
                throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_QUERY_ERROR, new Object[]{ALL_NOTIFICATIONS});
            }
            if (bc != null) {
                String user = this.getAccountPath();
                NotificationList list = null;
                for (int i = 0; i != bc.length; ++i) {
                    try {
                        list = new NotificationList(bc[i]);
                        list.remove(user);
                        cm.signNextRequest("DLS");
                        cm.update(new BaseClass[]{list.getBaseClass()}, null);
                        continue;
                    }
                    catch (DeliveryServiceHandlerException deliveryServiceHandlerException) {
                        continue;
                    }
                    catch (EMFSecurityException e) {
                        String path = list != null ? list.getBaseClass().getSearchPath().getValue() : "";
                        throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_UPDATE_ERROR, new Object[]{path});
                    }
                }
            }
        }
        finally {
            cm.close();
        }
    }

    public AsynchReply validate(SearchPathSingleObject objectPath, Option[] options) throws AxisFault, LocalizableException {
        I18NMessageUtil messages = new I18NMessageUtil();
        try {
            OptionsRunnable runnable = OptionsRunnableFactory.getRunnable(objectPath, new ParameterValue[0], options, this.m_headers.getBiBusHeader());
            messages.addMessages(runnable.validate());
        }
        catch (Throwable t) {
            if (t instanceof LocalizableException) {
                messages.addMessage(new I18NMessage((LocalizableException)t));
            }
            messages.addMessage(new I18NMessage(DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{t.getLocalizedMessage()}, SeverityEnum.error));
        }
        AsynchReply reply = new AsynchReply();
        reply.setDetails((AsynchDetail[])messages.getAsynchDetail());
        reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
        return reply;
    }

    public void run(SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) throws AxisFault, LocalizableException {
        if (!DeliveryServiceImpl.isArchiveDelivery(options)) {
            String credentialPath = this.getCredentialPath(this.m_headers.getBiBusHeader());
            this.m_headers.setCamCredential(credentialPath);
        }
        OptionsRunnable runnable = OptionsRunnableFactory.getRunnable(objectPath, parameterValues, options, this.m_headers.getBiBusHeader());
        runnable.run();
    }

    public String getAccountPath() {
        String path = null;
        if (this.m_account != null) {
            path = ObjectModelUtil.getSearchPath((StringProp)this.m_account.getSearchPath());
        }
        return path;
    }

    public BaseClass getNotificationObject(String path) throws DeliveryServiceHandlerException {
        BaseClass[] bc;
        PropEnum[] props = new PropEnum[]{PropEnum.allowNotification, PropEnum.notificationList, PropEnum.searchPath, PropEnum.permissions, PropEnum.storeID};
        String objectPath = path;
        ContentManagerServiceClientPort cmPort = null;
        try {
            cmPort = this.getCMPort();
            cmPort.signNextRequest("DLS");
            bc = cmPort.query(objectPath, props, null, null);
        }
        catch (SDKClientException e) {
            AUDIT_LOGGER.log(SDSLevel.ERROR, (LocalizableException)((Object)e));
            AUDIT_LOGGER.debug("[SDKClientException] Error retrieving notification object at :" + path);
            throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_QUERY_ERROR, new Object[]{path}, (LocalizableException)((Object)e));
        }
        catch (EMFSecurityException e) {
            AUDIT_LOGGER.log(SDSLevel.ERROR, (Throwable)e);
            AUDIT_LOGGER.debug("[EMFSecurityException] Error retrieving notification object at :" + path);
            throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_QUERY_ERROR, new Object[]{path});
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        if (bc == null || bc.length == 0) {
            throw new DeliveryServiceHandlerException(I18NCode.GEN_CM_QUERY_ERROR, new String[]{path});
        }
        if (bc[0] instanceof BaseAgentDefinition || bc[0] instanceof BaseReport || bc[0] instanceof Pinboard) {
            return bc[0];
        }
        throw new DeliveryServiceHandlerException(DlsI18NCode.MSG_DS_INVALID_NOTIFICATION_OBJECT, new String[]{path});
    }

    public BaseClass getNotificationObject(SearchPathSingleObject path) throws DeliveryServiceHandlerException {
        if (path == null) {
            throw new DeliveryServiceHandlerException(I18NCode.MSG_OBJECT_IS_NULL);
        }
        return this.getNotificationObject(path.get_value());
    }

    protected ContentManagerServiceClientPort getCMPort() {
        return Client.instance().getContentManagerServiceClient(this.m_headers);
    }

    protected Account getAccount() {
        UserAccountUtil util = new UserAccountUtil(this.m_headers);
        return util.getUserAccount();
    }

    private String getCredentialPath(BiBusHeader header) {
        String path = null;
        try {
            Credential cred = AuthenticatorFactory.getInstance().getCredential(header);
            StringProp credProp = cred != null ? cred.getSearchPath() : null;
            String string = path = credProp != null ? credProp.getValue() : null;
            if (path != null) {
                header.getCAM().setCAMCredentialPath(path);
            }
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("[SDKClientException] Error when retrieving the credential for the user, delayed message sending may be affected if the passport expires.");
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug((Throwable)e);
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("[EMFSecurityException] Error when retrieving the credential for the user, delayed message sending may be affected if the passport expires.");
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug((Throwable)e);
        }
        catch (Throwable e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("[Throwable] Error when retrieving the credential for the user, delayed message sending may be affected if the passport expires.");
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug(e);
        }
        return path;
    }

    private String getAddress(AddressSMTPProp prop) {
        AddressSMTP addSMTP;
        String email = null;
        if (prop != null && (addSMTP = prop.getValue()) != null) {
            email = addSMTP.get_value();
        }
        return email;
    }

    private boolean validateNotificationEmail() throws DeliveryServiceHandlerException {
        boolean needsUpdate = false;
        String notificationEmail = this.getAddress(this.m_account.getNotificationEMail());
        if (notificationEmail == null || notificationEmail.length() == 0) {
            String string = notificationEmail = this.m_account.getEmail() != null ? this.m_account.getEmail().getValue() : null;
            if (notificationEmail == null || notificationEmail.length() == 0) {
                String warningMsg = "The user, " + this.m_account.getSearchPath().getValue() + ", doesn't have an email address. Set to default email address so that he/she can receive notificaitons.";
                AUDIT_LOGGER.log(SDSLevel.WARN, null, new Object[]{warningMsg});
                notificationEmail = DEFAULT_EMAIL;
            }
            AddressSMTP addSMTP = new AddressSMTP(notificationEmail);
            AddressSMTPProp prop = new AddressSMTPProp();
            prop.setValue(addSMTP);
            this.m_account.setNotificationEMail(prop);
            needsUpdate = true;
        }
        return needsUpdate;
    }
}

