/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.api;

import com.cognos.developer.schemas.bibus._3.ArchiveOption;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryService_PortType;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.api.DeliveryServiceCapabilityChecker;
import com.cognos.dls.api.DeliveryServiceHandler;
import com.cognos.dls.api.DeliveryServiceHandlerException;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.SMTPDeliveryChannel;
import com.cognos.dls.smtp.queue.SMTPQueueConsumerManager;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.soap.service.ServiceImplBase;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.util.TrackingThreadProperties;
import com.cognos.jsmcommon.util.UserAccountUtil;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.AxisFault;

public class DeliveryServiceImpl
extends ServiceImplBase
implements DeliveryService_PortType {
    private static Map originalSettings = new HashMap();

    static boolean isArchiveDelivery(Option[] options) {
        return OptionUtils.findOptionsByType((Option[])options, ArchiveOption.class).length > 0;
    }

    public static boolean isHTSNotification(Option[] options) {
        return OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.notificationList) != null;
    }

    public static boolean isEmailDelivery(Option[] options) {
        boolean isEmail = false;
        if (OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.to) != null || OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.toAddress) != null || OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.cc) != null || OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.ccAddress) != null || OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.bcc) != null || OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.bccAddress) != null) {
            isEmail = true;
        }
        return isEmail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply run(SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)DLSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        try {
            boolean capabilitiesOK;
            BiBusHeader header = BiBusUtilities.extractBiBusHeader();
            boolean bl = capabilitiesOK = !DeliveryServiceImpl.isEmailDelivery(options) || this.checkAllCapabilities(header, options);
            if (capabilitiesOK) {
                TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
                JobBiBusHeaders headers = new JobBiBusHeaders(header);
                if (!DeliveryServiceImpl.isArchiveDelivery(options)) {
                    this.authenticate(headers);
                }
                boolean isAccountRequired = false == DeliveryServiceImpl.isArchiveDelivery(options);
                DeliveryServiceHandler dsh = new DeliveryServiceHandler(headers.getBiBusHeader(), isAccountRequired);
                dsh.run(objectPath, parameterValues, options);
                this.debugWait("primary.wait.dls");
            }
        }
        catch (LocalizableException e) {
            this.throwAxisFault(e);
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return this.getConversationCompleteReply();
    }

    private boolean checkAllCapabilities(BiBusHeader header, Option[] options) throws DeliveryServiceHandlerException {
        DeliveryServiceCapabilityChecker dscc = new DeliveryServiceCapabilityChecker(header);
        UserAccountUtil uau = new UserAccountUtil(new JobBiBusHeaders(header));
        String namespaceId = uau.getNameSpaceId();
        boolean canEmail = dscc.isCapabilitiesAllOkForEmailOptions(options, namespaceId);
        return canEmail;
    }

    private boolean checkEmailCapabilities(BiBusHeader header) throws DeliveryServiceHandlerException {
        DeliveryServiceCapabilityChecker dscc = new DeliveryServiceCapabilityChecker(header);
        boolean canEmail = dscc.checkCanUseEmail();
        return canEmail;
    }

    public AsynchReply runSpecification(AsynchSpecification specification, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        return this.run(null, parameterValues, options);
    }

    public AsynchReply validate(SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        AsynchReply r = null;
        try {
            DeliveryServiceHandler sv = this.getServiceHandler();
            r = sv.validate(objectPath, options);
            this.debugWait("primary.wait.asv");
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
        return r;
    }

    public void setTestProperties(String[] names, String[] values) throws RemoteException {
        try {
            BiBusHeader header = BiBusUtilities.extractBiBusHeader();
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            if (!AuthenticatorFactory.getInstance().hasCapability(header, UserCapabilityEnum.canUsePortalAdministrationTool)) {
                throw new DeliveryServiceHandlerException(DlsI18NCode.SEC_NO_PRIVILEGES);
            }
            SMTPQueueConsumerManager.getInstance().stop();
            for (int i = 0; i < values.length; ++i) {
                boolean isReset;
                boolean bl = isReset = values[i] == null || "".equals(values[i]);
                if (isReset && originalSettings.containsKey(names[i])) {
                    CRNProperties.getInstance().setProperty(names[i], (String)originalSettings.get(names[i]));
                    continue;
                }
                if (isReset) continue;
                if (!originalSettings.containsKey(names[i])) {
                    originalSettings.put(names[i], CRNProperties.getInstance().getProperty(names[i]));
                }
                CRNProperties.getInstance().setProperty(names[i], values[i]);
            }
            SMTPDeliveryChannel.resetProperties();
            SMTPQueueConsumerManager.reset();
            SMTPQueueConsumerManager.getInstance().start();
        }
        catch (Exception e) {
            throw new AxisFault(e.getLocalizedMessage());
        }
    }

    public AsynchReply wait(AsynchRequest conversation, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        String errorMessage = "A 'wait' request was recieved out of context. (The DeliveryService uses the async toolkit, and expects a wait request to be associated with a current conversation)";
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(errorMessage);
        throw new AxisFault(errorMessage);
    }

    public AsynchReply addNotification(SearchPathSingleObject spso) throws RemoteException {
        boolean canEmail;
        BiBusHeader header = BiBusUtilities.extractBiBusHeader();
        try {
            canEmail = this.checkEmailCapabilities(header);
        }
        catch (DeliveryServiceHandlerException e1) {
            throw new RemoteException("addnotification capability check failed", (Throwable)((Object)e1));
        }
        if (canEmail) {
            try {
                DeliveryServiceHandler sv = this.getServiceHandler();
                sv.addNotification(spso);
                this.debugWait("primary.wait.dls");
            }
            catch (Exception e) {
                throw AxisFault.makeFault((Exception)e);
            }
        }
        return this.getConversationCompleteReply();
    }

    public AsynchReply clearNotifications(SearchPathSingleObject spso) throws RemoteException {
        try {
            DeliveryServiceHandler sv = this.getServiceHandler();
            sv.clearNotifications(spso);
            this.debugWait("primary.wait.dls");
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
        return this.getConversationCompleteReply();
    }

    private boolean checkUserCanEmail() throws RemoteException {
        boolean canEmail;
        try {
            BiBusHeader header = BiBusUtilities.extractBiBusHeader();
            canEmail = this.checkEmailCapabilities(header);
        }
        catch (Exception e1) {
            throw new RemoteException("addnotification capability check failed", e1);
        }
        return canEmail;
    }

    public AsynchReply deleteAllNotifications() throws RemoteException {
        try {
            DeliveryServiceHandler sv = this.getServiceHandler();
            sv.removeAllNotifications();
            this.debugWait("primary.wait.dls");
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
        return this.getConversationCompleteReply();
    }

    public AsynchReply deleteNotification(SearchPathSingleObject spso) throws RemoteException {
        try {
            DeliveryServiceHandler sv = this.getServiceHandler();
            sv.removeNotification(spso);
            this.debugWait("primary.wait.dls");
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
        return this.getConversationCompleteReply();
    }

    public AsynchReply queryNotification(SearchPathSingleObject spso) throws RemoteException {
        AsynchReply r = null;
        try {
            DeliveryServiceHandler sv = this.getServiceHandler();
            r = sv.queryNotification(spso);
            this.debugWait("primary.wait.dls");
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
        return r;
    }

    public BaseClass getNotificationList(SearchPathSingleObject path) throws RemoteException {
        BaseClass r = null;
        try {
            BiBusHeader header = BiBusUtilities.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            DeliveryServiceHandler sv = this.getServiceHandler();
            r = sv.getNotificationList(path);
            this.debugWait("primary.wait.dls");
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
        return r;
    }

    protected DeliveryServiceHandler getServiceHandler() throws AxisFault {
        return new DeliveryServiceHandler(this.extractBiBusHeader());
    }

    private AsynchReply getConversationCompleteReply() {
        AsynchReply asyncReply = new AsynchReply();
        asyncReply.setStatus(AsynchReplyStatusEnum.conversationComplete);
        return asyncReply;
    }

    public void cancel(AsynchRequest conversation) throws RemoteException {
        this.throwUnsupportedOperation();
    }

    public void release(AsynchRequest conversation) throws RemoteException {
        this.throwUnsupportedOperation();
    }

    public AsynchReply validateSpecification(AsynchSpecification specification, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        return this.validate(null, parameterValues, options);
    }
}

