/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.api;

import com.cognos.developer.schemas.bibus._3.AnyURIProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.MemoPartObjectLinks;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.URL;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.CafUtilities;
import java.util.ArrayList;
import org.apache.axis.AxisFault;

public final class MemoValidationResult {
    private MemoPartObjectLinks m_memoLinks;
    private BiBusHeader m_header;

    public MemoValidationResult(MemoPartObjectLinks memoLinks, BiBusHeader header) {
        this.m_memoLinks = memoLinks;
        this.m_header = header;
    }

    public I18NMessage[] validate() {
        I18NMessage[] result = new I18NMessage[]{};
        if (this.m_memoLinks == null) {
            return result;
        }
        ArrayList<I18NMessage> messages = new ArrayList<I18NMessage>();
        ObjectLink[] theLinks = this.m_memoLinks.getLinks();
        if (theLinks != null) {
            I18NMessage oneMessage = null;
            for (int counter = 0; counter < theLinks.length; ++counter) {
                oneMessage = this.validateOneLink(theLinks[counter]);
                if (oneMessage == null) continue;
                messages.add(oneMessage);
            }
            result = messages.toArray(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private I18NMessage validateOneLink(ObjectLink link) {
        I18NMessage result = null;
        if (link == null || link.getSearchPath() == null) {
            return result;
        }
        SearchPathSingleObject linkPath = link.getSearchPath();
        PropEnum[] queryProps = new PropEnum[]{PropEnum.searchPath, PropEnum.uri};
        ContentManagerServiceClientPort cmPort = null;
        try {
            String uri;
            URL url;
            AnyURIProp uriProp;
            if (this.m_header == null) {
                this.m_header = BiBusUtilities.extractBiBusHeader();
            }
            JobBiBusHeaders headers = new JobBiBusHeaders(this.m_header);
            cmPort = Client.instance().getContentManagerServiceClient(headers);
            QueryRequest theRequest = new QueryRequest();
            theRequest.setSearch(linkPath.get_value());
            theRequest.setProperties(queryProps);
            BaseClass reply = cmPort.query(theRequest);
            if (reply == null) {
                result = new I18NMessage(DlsI18NCode.MSG_DS_URL_LINK_NOT_AVAILABLE, new Object[]{linkPath.get_value()}, SeverityEnum.error);
            } else if (reply instanceof URL && null != (uriProp = (url = (URL)reply).getUri()) && !CafUtilities.isValidURL((String)(uri = uriProp.getValue()))) {
                result = new I18NMessage(DlsI18NCode.MSG_DS_URL_LINK_NOT_VALID, new Object[]{uri}, SeverityEnum.error);
            }
        }
        catch (AxisFault ex) {
            result = new I18NMessage(DlsI18NCode.MSG_DS_URL_LINK_NOT_AVAILABLE, new Object[]{linkPath.get_value()}, SeverityEnum.error);
        }
        catch (EMFSecurityException ex) {
            result = new I18NMessage(DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{ex.getLocalizedMessage()}, SeverityEnum.error);
        }
        catch (SDKClientException ex) {
            result = new I18NMessage(DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{ex.getLocalizedMessage()}, SeverityEnum.error);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return result;
    }
}

