/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.cpns;

import com.cognos.dls.DLSCategory;
import com.cognos.dls.cpns.message.CPNSMessage;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.ServerConfigPropertyUtils;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;

public class CPNSPushServiceCaller {
    private static final String PUSH_NOTIFICATION_SERVICE_URL = "/mobile-gateway/push-notification-client/messages";
    private static final String PERSIST_MEDIA_TYPE = "application/json";
    static CPNSPushServiceCaller m_instance = new CPNSPushServiceCaller();

    public static CPNSPushServiceCaller getInstance() {
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean callPushService(CPNSMessage cpnsMsg) {
        RESTClient restClient = null;
        boolean result = false;
        String cpnsServiceURL = PUSH_NOTIFICATION_SERVICE_URL;
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("CPNSPushServiceCaller -->" + cpnsMsg.getTargetDeviceIdsString());
        try {
            String gateway = CPNSPushServiceCaller.cleanGatewayURI();
            if (null != gateway) {
                cpnsServiceURL = gateway + cpnsServiceURL;
            } else {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("DLS.CPNSPushServiceCaller gateway is null");
            }
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("DLS.CPNSPushServiceCaller cpns URL:" + cpnsServiceURL);
            String jsonString = cpnsMsg.getJsonString();
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("CPNSPushServiceCaller:" + jsonString);
            JsonObject jsObject = JsonObject.parseString((String)jsonString, (boolean)false);
            restClient = RESTClientFactory.getInstance().getClient(new RESTClientConfig());
            if (null != restClient) {
                boolean res = restClient.makeTrusted("DLS");
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("CPNSPushServiceCaller - rest.makeTrusted return: " + res);
                restClient.setRequestHeader("Cache-Control", "no-cache");
                restClient.setRequestHeader("Accept", PERSIST_MEDIA_TYPE);
                restClient.setRequestHeader("Content-Type", PERSIST_MEDIA_TYPE);
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("CPNSPushServiceCaller createResource(" + cpnsServiceURL + ")" + "[messages]" + jsObject);
                int code = restClient.createResource(cpnsServiceURL, "messages", jsObject);
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("CPNSPushServiceCaller createResource(" + cpnsServiceURL + ")" + " - response code = " + code);
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("CPNSPushServiceCaller:done");
                result = true;
            } else {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("CPNSPushServiceCaller - restclient not initilised: " + restClient);
            }
        }
        catch (IOException e) {
            result = false;
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("DLS.CPNSPushServiceCaller callPushService " + cpnsServiceURL + ":error " + e.getMessage());
        }
        finally {
            if (restClient != null) {
                try {
                    restClient.close();
                }
                catch (IOException e) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("DLS.CPNSPushServiceCaller rest client closing error " + e.getMessage());
                }
            }
        }
        return result;
    }

    public static String cleanGatewayURI() {
        int lastSlash;
        String gatewayURI = null;
        try {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("DLS.CPNSPushServiceCaller cleanGatewayURI(): getting gateway");
            gatewayURI = ServerConfigPropertyUtils.getServerGateWay();
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("DLS.CPNSPushServiceCaller cleanGatewayURI(): gateway" + gatewayURI);
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("DLS.CPNSPushServiceCaller cleanGatewayURI():" + e.getMessage());
        }
        if (null != gatewayURI && (lastSlash = gatewayURI.lastIndexOf("/")) != -1) {
            gatewayURI = gatewayURI.substring(0, lastSlash);
        }
        SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("DLS.CPNSPushServiceCaller cleanGatewayURI(): clean gateway" + gatewayURI);
        return gatewayURI;
    }
}

