/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.cpns;

import com.cognos.dls.DLSCategory;
import com.cognos.dls.cpns.CPNSPushServiceCaller;
import com.cognos.dls.cpns.message.CPNSMessage;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;

class MobilePushThread
implements Runnable {
    CPNSMessage _cpnsMessage;

    MobilePushThread() {
    }

    MobilePushThread(CPNSMessage cpnsMessage) {
        this._cpnsMessage = cpnsMessage;
        this.debug("MobilePushThread" + cpnsMessage);
    }

    @Override
    public void run() {
        try {
            this.debug("MobilePushThread: run " + this._cpnsMessage.toString() + " calling push service");
            boolean success = CPNSPushServiceCaller.getInstance().callPushService(this._cpnsMessage);
            if (success) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Sent push notification for" + this._cpnsMessage.getTargetDeviceIdsString());
            } else {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Push notification failed for " + this._cpnsMessage.getTargetDeviceIdsString());
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).error("Error sending push notification for" + this._cpnsMessage.getTargetDeviceIdsString());
        }
    }

    private void debug(String string) {
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(string);
    }
}

