/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.fs;

import com.cognos.developer.schemas.bibus._3.AnyURIProp;
import com.cognos.developer.schemas.bibus._3.ArchiveConflictResolutionEnum;
import com.cognos.developer.schemas.bibus._3.ArchiveDescriptor;
import com.cognos.developer.schemas.bibus._3.ArchiveLocation;
import com.cognos.developer.schemas.bibus._3.ArchiveOption;
import com.cognos.developer.schemas.bibus._3.ArchiveOptionConflictResolution;
import com.cognos.developer.schemas.bibus._3.ArchiveOptionDescriptor;
import com.cognos.developer.schemas.bibus._3.ArchiveOptionEnum;
import com.cognos.developer.schemas.bibus._3.ArchiveOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.ArchiveOptionString;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionChannel;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionLanguageArray;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.fs.ArchiveOptionsException;
import com.cognos.dls.fs.OutputPropertiesBean;
import com.cognos.dls.fs.ResolutionType;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.service.DLSConfiguration;
import com.cognos.dls.service.DLSConfigurationListener;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Attachment;
import com.cognos.jsmcommon.soap.client.AttachmentException;
import com.cognos.jsmcommon.soap.client.AttachmentFactory;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.XMLUtils;
import com.cognos.pogo.pdk.Configuration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;

public class ArchiveOptionsProcessor {
    private static final String TAG_START_PARAMETER_VALUES = "<parameterValues>";
    private static final String TAG_END_PARAMETER_VALUES = "</parameterValues>";
    private static final String TAG_EMPTY_PARAMETER_VALUES = "<parameterValues/>";
    private static final String TAG_START_ITEM = "<item>";
    private static final String TAG_END_ITEM = "</item>";
    private static final String TAG_START_VALUE = "<value>";
    private static final String TAG_END_VALUE = "</value>";
    private static final String TAG_START_USE = "<use>";
    private static final String TAG_END_USE = "</use>";
    private static final String TAG_START_DISPLAY = "<display>";
    private static final String TAG_END_DISPLAY = "</display>";
    private static final String TAG_START_INCLUSIVE = "<inclusive>";
    private static final String TAG_END_INCLUSIVE = "</inclusive>";
    private static final String TAG_START_NAME = "<name>";
    private static final String TAG_END_NAME = "</name>";
    private URL m_root;
    private OutputPropertiesBean m_props;
    private String m_alias;
    private static final Map s_aliases = Collections.synchronizedMap(new HashMap());
    String root_value = null;

    ArchiveOptionsProcessor() {
    }

    void process(Option[] options, BiBusHeader header) throws ArchiveOptionsException {
        this.m_props = new OutputPropertiesBean();
        List<Option> deliveryOptionList = Arrays.asList(OptionUtils.findOptionsByType((Option[])options, DeliveryOption.class));
        DeliveryOption[] deliveryOption = deliveryOptionList.toArray(new DeliveryOption[deliveryOptionList.size()]);
        this.handleDeliveryOptions(deliveryOption);
        List<Option> archiveOptionList = Arrays.asList(OptionUtils.findOptionsByType((Option[])options, ArchiveOption.class));
        ArchiveOption[] archiveOption = archiveOptionList.toArray(new ArchiveOption[archiveOptionList.size()]);
        this.handleArchiveOptions(archiveOption, header);
    }

    void setRoot(URL root) {
        this.m_root = root;
    }

    void setAlias(String alias) {
        this.m_alias = alias;
    }

    public ArchiveOptionsProcessor(Option[] options, BiBusHeader header) throws ArchiveOptionsException {
        this.process(options, header);
    }

    public OutputPropertiesBean getProperties() {
        return this.m_props;
    }

    private void handleArchiveOptions(ArchiveOption[] options, BiBusHeader header) throws ArchiveOptionsException {
        for (int i = 0; i < options.length; ++i) {
            ArchiveOption option = options[i];
            ArchiveOptionEnum archiveOptionEnum = option.getName();
            if (archiveOptionEnum.equals((Object)ArchiveOptionEnum.archiveLocation)) {
                this.setArchiveLocation(option, header);
                continue;
            }
            if (archiveOptionEnum.equals((Object)ArchiveOptionEnum.conflictResolution)) {
                this.setConflictResolution(option);
                continue;
            }
            if (archiveOptionEnum.equals((Object)ArchiveOptionEnum.descriptor)) {
                this.setDescriptor(option);
                continue;
            }
            if (archiveOptionEnum.equals((Object)ArchiveOptionEnum.filenameExtension)) {
                this.setFilenameExtension(option);
                continue;
            }
            if (!archiveOptionEnum.equals((Object)ArchiveOptionEnum.filenameStub)) continue;
            this.setFilenameStub(option);
        }
    }

    private void handleDeliveryOptions(DeliveryOption[] options) throws ArchiveOptionsException {
        for (int i = 0; i < options.length; ++i) {
            DeliveryOption option = options[i];
            DeliveryOptionEnum deliveryOptionEnum = option.getName();
            if (deliveryOptionEnum.equals((Object)DeliveryOptionEnum.channel)) {
                this.setChannel(option);
                continue;
            }
            if (!deliveryOptionEnum.equals((Object)DeliveryOptionEnum.memoPart)) continue;
            this.setAttachment(option);
        }
    }

    private void setParameters(ParameterValue[] parameters) {
        StringBuffer buf = new StringBuffer();
        if (parameters.length == 0) {
            buf.append(TAG_EMPTY_PARAMETER_VALUES);
        } else {
            buf.append(TAG_START_PARAMETER_VALUES);
            for (int i = 0; i < parameters.length; ++i) {
                ParameterValue p = parameters[i];
                String name = p.getName();
                ParmValueItem[] items = p.getValue();
                for (int j = 0; j < items.length; ++j) {
                    if (!(items[j] instanceof SimpleParmValueItem)) continue;
                    SimpleParmValueItem item = (SimpleParmValueItem)items[j];
                    buf.append(TAG_START_ITEM);
                    String xml = this.renderSimpleParmAsXML(name, item);
                    buf.append(xml);
                    buf.append(TAG_END_ITEM);
                }
            }
            buf.append(TAG_END_PARAMETER_VALUES);
        }
        this.m_props.setParameters(buf.toString());
    }

    private void setAttachment(DeliveryOption option) throws ArchiveOptionsException {
        if (!(option instanceof DeliveryOptionMemoPart)) {
            this.throwIncorrectOption(option.getName().getValue(), option.getClass().getName(), MemoPart.class.getName());
        }
        Message currentMessage = MessageContext.getCurrentContext().getRequestMessage();
        try {
            Attachment[] attachments = AttachmentFactory.getAttachments((Message)currentMessage);
            if (attachments.length == 0 || attachments.length > 1) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Either the report output attachment is missing or more than one exists. Only one is expected");
                throw new ArchiveOptionsException(DlsI18NCode.MSG_DS_INVALID_OPTIONS);
            }
            this.m_props.setAttachment(attachments[0]);
        }
        catch (AttachmentException ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Error reading that attachments from the message");
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            throw new ArchiveOptionsException(DlsI18NCode.MSG_DS_INVALID_OPTIONS);
        }
    }

    private void setChannel(DeliveryOption option) throws ArchiveOptionsException {
        if (!(option instanceof DeliveryOptionChannel)) {
            this.throwIncorrectOption(option.getName().getValue(), option.getClass().getName(), DeliveryOptionChannel.class.getName());
        }
        DeliveryOptionChannel channel = (DeliveryOptionChannel)option;
        this.m_props.setChannel(channel.getValue().getValue());
    }

    private URL getRoot(BiBusHeader header) throws ArchiveOptionsException {
        if (this.m_root != null) {
            return this.m_root;
        }
        try {
            String root;
            this.root_value = root = CRNProperties.getInstance().getProperty("archiveLocationFileSchemeRoot");
            if (root == null || root.length() <= 1) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).error("The root location has not been defined in Cognos configuration or is invalid. Found archive root value: " + root);
                throw new ArchiveOptionsException(DlsI18NCode.MSG_DS_INVALID_ROOT, new Object[]{root});
            }
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("The archive directory for report output in Cognos configuration '" + root + "'");
            this.m_root = new URL(root);
        }
        catch (MalformedURLException ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).error("The archive root location is not a valid URL. Found archive root value: " + this.root_value);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)ex);
            throw new ArchiveOptionsException(DlsI18NCode.MSG_DS_INVALID_ROOT);
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).error("The root location has not been defined in Cognos configuration or is invalid. Found archive root value: " + this.root_value);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            throw new ArchiveOptionsException(DlsI18NCode.MSG_DS_INVALID_ROOT);
        }
        return this.m_root;
    }

    private String getAlias(String searchPath, BiBusHeader header) throws ArchiveOptionsException {
        block11: {
            if (this.m_alias != null) {
                return this.m_alias;
            }
            String val = (String)s_aliases.get(searchPath);
            if (val != null) {
                return val;
            }
            QueryRequest locationRequest = new QueryRequest();
            locationRequest.setSearch(searchPath);
            locationRequest.setProperties(new PropEnum[]{PropEnum.uri});
            JobBiBusHeaders jobHeader = new JobBiBusHeaders(header);
            ContentManagerServiceClientPort cmscp = Client.instance().getContentManagerServiceClient(jobHeader);
            try {
                cmscp.signNextRequest("DLS");
                BaseClass base = cmscp.query(locationRequest);
                if (base != null && base instanceof ArchiveLocation) {
                    ArchiveLocation archiveLocation = (ArchiveLocation)base;
                    AnyURIProp uriProp = archiveLocation.getUri();
                    this.m_alias = uriProp.getValue();
                    if (this.m_alias == null) {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("The alias location has not been defined in CM");
                        throw new ArchiveOptionsException(DlsI18NCode.MSG_DS_MISSING_ALIAS, new Object[]{searchPath});
                    }
                    s_aliases.put(searchPath, this.m_alias);
                    break block11;
                }
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("The alias location has not been defined in CM");
                throw new ArchiveOptionsException(DlsI18NCode.MSG_DS_MISSING_ALIAS, new Object[]{searchPath});
            }
            catch (LocalizableException ex) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Cannot retrieve the alias location from CM");
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, ex);
                throw new ArchiveOptionsException(DlsI18NCode.MSG_DS_MISSING_ALIAS, new Object[]{searchPath});
            }
            catch (EMFSecurityException ex) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Cannot retrieve the alias location from CM due to a security problem");
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)ex);
                throw new ArchiveOptionsException(DlsI18NCode.MSG_DS_MISSING_ALIAS, new Object[]{searchPath});
            }
            finally {
                if (cmscp != null) {
                    cmscp.close();
                }
            }
        }
        return this.m_alias;
    }

    private void setFilenameStub(ArchiveOption option) {
        String reportName = this.getValue(option);
        this.m_props.setFileNameStub(reportName);
    }

    private void setFilenameExtension(ArchiveOption option) {
        String extension = this.getValue(option);
        this.m_props.setExtension(extension);
    }

    private void setDescriptor(ArchiveOption option) throws ArchiveOptionsException {
        if (!(option instanceof ArchiveOptionDescriptor)) {
            this.throwIncorrectOption(option.getName().getValue(), option.getClass().getName(), ArchiveOptionDescriptor.class.getName());
        }
        ArchiveOptionDescriptor archiveOptionDescriptor = (ArchiveOptionDescriptor)option;
        ArchiveDescriptor archiveDescriptor = archiveOptionDescriptor.getValue();
        this.m_props.setBurstKey(archiveDescriptor.getBurstKey());
        this.m_props.setAsOfTime(archiveDescriptor.getAsOfTime());
        this.m_props.setDefaultDescription(archiveDescriptor.getDefaultDescription());
        this.m_props.setDefaultName(archiveDescriptor.getDefaultName());
        this.m_props.setFileName(archiveDescriptor.getFilename());
        this.m_props.setExecutionTime(archiveDescriptor.getExecutionTime());
        Option[] options = archiveDescriptor.getOptions();
        for (int i = 0; i < options.length; ++i) {
            RunOptionLanguageArray langArr;
            if (options[i] instanceof RunOptionStringArray) {
                RunOptionStringArray stringArr = (RunOptionStringArray)options[i];
                if (!stringArr.getName().equals((Object)RunOptionEnum.outputFormat)) continue;
                String format = this.getFormat((RunOptionStringArray)options[i]);
                this.m_props.setFormat(format);
                continue;
            }
            if (!(options[i] instanceof RunOptionLanguageArray) || !(langArr = (RunOptionLanguageArray)options[i]).getName().equals((Object)RunOptionEnum.outputLocale)) continue;
            String locale = this.getLocale((RunOptionLanguageArray)options[i]);
            this.m_props.setLocale(locale);
        }
        ParameterValue[] parameters = archiveDescriptor.getParameters();
        this.setParameters(parameters);
        SearchPathSingleObject reportViewSearchPath = archiveDescriptor.getReportViewSearchPath();
        SearchPathSingleObject reportsearchPath = archiveDescriptor.getReportSearchPath();
        if (reportViewSearchPath != null) {
            Guid viewGuid = archiveDescriptor.getReportViewStoreID();
            this.m_props.setReportId(viewGuid.get_value());
            this.m_props.setReportViewSearchPath(reportViewSearchPath.get_value());
        } else {
            Guid guid = archiveDescriptor.getReportStoreID();
            this.m_props.setReportId(guid.get_value());
            this.m_props.setReportSearchPath(reportsearchPath.get_value());
        }
    }

    private String getFormat(RunOptionStringArray runOptionArray) throws ArchiveOptionsException {
        String format = "";
        String[] formats = runOptionArray.getValue();
        if (formats.length == 0 || formats.length > 1) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Only one archive format is allowed");
            throw new ArchiveOptionsException(DlsI18NCode.MSG_DS_INVALID_OPTIONS);
        }
        format = formats[0];
        return format;
    }

    private String getLocale(RunOptionLanguageArray languageArray) throws ArchiveOptionsException {
        String locale = "";
        String[] locales = languageArray.getValue();
        if (locales.length == 0 || locales.length > 1) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Only one archive locale is allowed");
            throw new ArchiveOptionsException(DlsI18NCode.MSG_DS_INVALID_OPTIONS);
        }
        locale = locales[0];
        return locale;
    }

    private void setConflictResolution(ArchiveOption option) throws ArchiveOptionsException {
        if (!(option instanceof ArchiveOptionConflictResolution)) {
            this.throwIncorrectOption(option.getName().getValue(), option.getClass().getName(), ArchiveOptionConflictResolution.class.getName());
        }
        ArchiveOptionConflictResolution resolution = (ArchiveOptionConflictResolution)option;
        ArchiveConflictResolutionEnum resolutionEnum = resolution.getValue();
        ResolutionType resolutionType = ResolutionType.CONFLICT_RESOLUTION_REPLACE;
        if (resolutionEnum.equals((Object)ArchiveConflictResolutionEnum.appendDateTime)) {
            resolutionType = ResolutionType.CONFLICT_RESOLUTION_UNIQUE_TIMESTAMP;
        } else if (resolutionEnum.equals((Object)ArchiveConflictResolutionEnum.appendSequenceNumber)) {
            resolutionType = ResolutionType.CONFLICT_RESOLUTION_UNIQUE_SEQUENCE;
        } else if (resolutionEnum.equals((Object)ArchiveConflictResolutionEnum.fail)) {
            resolutionType = ResolutionType.CONFLICT_RESOLUTION_FAIL;
        }
        this.m_props.setType(resolutionType);
    }

    private void setArchiveLocation(ArchiveOption option, BiBusHeader header) throws ArchiveOptionsException {
        if (!(option instanceof ArchiveOptionSearchPathSingleObject)) {
            this.throwIncorrectOption(option.getName().getValue(), option.getClass().getName(), ArchiveOptionSearchPathSingleObject.class.getName());
        }
        URL root = this.getRoot(header);
        this.m_props.setRoot(root);
        ArchiveOptionSearchPathSingleObject searchPath = (ArchiveOptionSearchPathSingleObject)option;
        SearchPathSingleObject path = searchPath.getValue();
        if (path != null) {
            String location = this.getAlias(path.get_value(), header);
            this.m_props.setAlias(location);
        }
    }

    private String throwIncorrectOption(String name, String clazzName, String expectedClazzName) throws ArchiveOptionsException {
        throw new ArchiveOptionsException(DlsI18NCode.MSG_DS_INVALID_ARCHIVE_OPTION, new Object[]{name, clazzName, expectedClazzName});
    }

    private String getValue(ArchiveOption option) {
        String value = "";
        if (option instanceof ArchiveOptionString) {
            ArchiveOptionString archiveOptionString = (ArchiveOptionString)option;
            value = archiveOptionString.getValue();
        }
        return value;
    }

    private String renderSimpleParmAsXML(String name, SimpleParmValueItem item) {
        StringBuffer buffer = new StringBuffer();
        String display = item.getDisplay();
        String use = item.getUse();
        boolean inclusive = item.isInclusive();
        buffer.append(TAG_START_NAME);
        buffer.append(XMLUtils.forceEscape((String)name));
        buffer.append(TAG_END_NAME);
        buffer.append(TAG_START_VALUE);
        buffer.append(TAG_START_ITEM);
        buffer.append(TAG_START_INCLUSIVE);
        buffer.append(inclusive);
        buffer.append(TAG_END_INCLUSIVE);
        buffer.append(TAG_START_DISPLAY);
        buffer.append(XMLUtils.forceEscape((String)display));
        buffer.append(TAG_END_DISPLAY);
        buffer.append(TAG_START_USE);
        buffer.append(XMLUtils.forceEscape((String)use));
        buffer.append(TAG_END_USE);
        buffer.append(TAG_END_ITEM);
        buffer.append(TAG_END_VALUE);
        return buffer.toString();
    }

    static {
        ArchiveConfigurationListener listener = new ArchiveConfigurationListener();
        DLSConfiguration.getInstance().addListener(listener);
    }

    private static class ArchiveConfigurationListener
    implements DLSConfigurationListener {
        private ArchiveConfigurationListener() {
        }

        @Override
        public void configure(Configuration configuration) {
            s_aliases.clear();
        }
    }
}

