/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.fs;

import com.cognos.dls.DLSCategory;
import com.cognos.dls.fs.IWriter;
import com.cognos.dls.fs.OutputPropertiesBean;
import com.cognos.dls.fs.ResolutionType;
import com.cognos.dls.fs.WriteMetric;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.client.Attachment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

class DescriptorWriter
implements IWriter {
    private static final String OUTPUT_DESCRIPTOR = "outputDescriptor";
    private String COMMENT = "Copyright (C) _YEAR_ by IBM Cognos Analytics. All rights reserved.\r\nLicensed Materials - Property of IBM. (c) Copyright IBM Corp. _YEAR_\r\nU.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String PARAMETER_VALUES = "parameterValues";
    private static final String REPORT_VIEW_SEARCH_PATH = "reportViewSearchPath";
    private static final String REPORT_SEARCH_PATH = "reportSearchPath";
    private static final String REPORT_ID = "reportId";
    private static final String REPORT_EXECUTION_TIME = "reportExecutionTime";
    private static final String OUTPUT_FORMAT = "outputFormat";
    private static final String OUTPUT_LOCALE = "outputLocale";
    private static final String FILE_NAME = "fileName";
    private static final String DEFAULT_DESCRIPTION = "defaultDescription";
    private static final String DEFAULT_NAME = "defaultName";
    private static final String BURST_KEY = "burstKey";
    private static final String AS_OF_TIME = "asOfTime";
    private static final String UTF8 = "UTF-8";
    private OutputPropertiesBean m_props;
    private WriteMetric m_metric;

    public DescriptorWriter(OutputPropertiesBean props) {
        this.m_props = props;
        this.m_metric = new WriteMetric();
    }

    @Override
    public String write() throws IOException {
        return this.writeUsingDOM();
    }

    @Override
    public boolean validate() {
        File outputFile = this.m_props.getOutputFile();
        String locale = this.m_props.getLocale();
        ResolutionType type = this.m_props.getType();
        String extension = this.m_props.getExtension();
        Calendar asOfTime = this.m_props.getAsOfTime();
        Attachment att = this.m_props.getAttachment();
        String defaultName = this.m_props.getDefaultName();
        Calendar execTime = this.m_props.getExecutionTime();
        String format = this.m_props.getFormat();
        String searchPath = this.m_props.getReportSearchPath() != null ? this.m_props.getReportSearchPath() : this.m_props.getReportViewSearchPath();
        File root = this.m_props.getRootFileName();
        String channel = this.m_props.getChannel();
        return outputFile != null && locale != null && locale.length() > 0 && type != null && extension != null && extension.length() > 0 && asOfTime != null && att != null && defaultName != null && defaultName.length() > 0 && execTime != null && format != null && format.length() > 0 && searchPath != null && searchPath.length() > 0 && root != null && channel != null && channel.equalsIgnoreCase("archive");
    }

    @Override
    public WriteMetric getMetric() {
        return this.m_metric;
    }

    private void add(Element parent, String tag, String value) {
        Element child = parent.addElement(tag);
        if (value != null && value.length() > 0) {
            child.addText(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeUsingDOM() throws IOException {
        XMLWriter writer = null;
        boolean exists = false;
        boolean success = false;
        Document params = null;
        String descriptor = "";
        try {
            exists = this.m_props.getOutputFile().exists();
            String descriptorFileName = this.m_props.getOutputFile().getName();
            String regExp = "\\-" + this.m_props.getExtension() + "_desc" + ".xml";
            String outputFileName = descriptorFileName.replaceAll(regExp, "") + "." + this.m_props.getExtension();
            String asOfTime = new Date(this.m_props.getAsOfTime().getTimeInMillis()).toString();
            String burstKey = this.m_props.getBurstKey();
            String defaultDescription = this.m_props.getDefaultDescription();
            String defaultName = this.m_props.getDefaultName();
            String locale = this.m_props.getLocale();
            String format = this.m_props.getFormat();
            String executionTime = new Date(this.m_props.getExecutionTime().getTimeInMillis()).toString();
            String sParmXML = this.m_props.getParameters();
            String reportId = this.m_props.getReportId();
            String reportSearchPath = this.m_props.getReportSearchPath();
            String reportViewSearchPath = this.m_props.getReportViewSearchPath();
            File descriptorFile = this.m_props.getOutputFile();
            Document document = DocumentHelper.createDocument();
            document.addComment(this.updateYear(this.COMMENT));
            Element outputDescriptor = document.addElement(OUTPUT_DESCRIPTOR);
            this.add(outputDescriptor, AS_OF_TIME, asOfTime);
            this.add(outputDescriptor, BURST_KEY, burstKey);
            this.add(outputDescriptor, DEFAULT_NAME, defaultName);
            this.add(outputDescriptor, DEFAULT_DESCRIPTION, defaultDescription);
            this.add(outputDescriptor, FILE_NAME, outputFileName);
            this.add(outputDescriptor, OUTPUT_LOCALE, locale);
            this.add(outputDescriptor, OUTPUT_FORMAT, format);
            this.add(outputDescriptor, REPORT_EXECUTION_TIME, executionTime);
            this.add(outputDescriptor, REPORT_ID, reportId);
            this.add(outputDescriptor, REPORT_SEARCH_PATH, reportSearchPath);
            this.add(outputDescriptor, REPORT_VIEW_SEARCH_PATH, reportViewSearchPath);
            try {
                params = DocumentHelper.parseText((String)sParmXML);
                outputDescriptor.appendContent((Branch)params);
            }
            catch (DocumentException ex) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Could not parse the parameterValues xml for " + descriptorFile + ". An empty tag has been created");
                this.add(outputDescriptor, PARAMETER_VALUES, null);
            }
            OutputFormat of = OutputFormat.createPrettyPrint();
            of.setEncoding(UTF8);
            writer = new XMLWriter((OutputStream)new FileOutputStream(descriptorFile), of);
            writer.write(document);
            success = true;
            descriptor = document.asXML();
        }
        finally {
            if (writer != null) {
                writer.close();
                this.m_metric.setWritten(success);
                this.m_metric.setReplaced(exists);
            }
        }
        return descriptor;
    }

    private String updateYear(String commentStr) {
        Calendar now = Calendar.getInstance();
        int year = now.get(1);
        commentStr = commentStr.replaceAll("_YEAR_", String.valueOf(year));
        return commentStr;
    }
}

