/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.fs;

import com.cognos.dls.fs.ReportOutputException;
import com.cognos.dls.fs.ResolutionType;
import com.cognos.dls.fs.TimestampGenerator;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.FileUtil;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.io.Externalizable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.apache.oro.io.Perl5FilenameFilter;

class FileNameConflictResolver {
    private final boolean ADV_PROP_ALWAYS_TIMESTAMP_SET = this.isTimeStampAlwaysOn();
    private String m_lastTimeStamp = "";
    private String m_lastSequenceNumber;
    private final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");

    FileNameConflictResolver() {
    }

    public String resolve(File outputFile, ResolutionType type, String locale, String decorator, String suffix) throws ReportOutputException {
        String newName = "";
        newName = outputFile.getName();
        if (type.equals(ResolutionType.CONFLICT_RESOLUTION_UNIQUE_TIMESTAMP) && this.ADV_PROP_ALWAYS_TIMESTAMP_SET) {
            newName = this.appendTimeStampToFilename(outputFile, locale, decorator, suffix);
        } else {
            if (type.equals(ResolutionType.CONFLICT_RESOLUTION_REPLACE)) {
                newName = outputFile.getName();
                return newName;
            }
            if (outputFile.exists()) {
                if (type.equals(ResolutionType.CONFLICT_RESOLUTION_FAIL)) {
                    this.fail(outputFile);
                } else if (type.equals(ResolutionType.CONFLICT_RESOLUTION_UNIQUE_SEQUENCE)) {
                    String sequenceStr;
                    if (suffix != null && suffix.length() > 0) {
                        sequenceStr = suffix;
                    } else {
                        int sequence = this.generateSequenceNumber(outputFile, decorator);
                        sequenceStr = String.valueOf(sequence);
                    }
                    newName = this.appendSuffix(outputFile, locale, sequenceStr, decorator);
                } else if (type.equals(ResolutionType.CONFLICT_RESOLUTION_UNIQUE_TIMESTAMP)) {
                    newName = this.appendTimeStampToFilename(outputFile, locale, decorator, suffix);
                }
            }
        }
        return newName;
    }

    private String appendTimeStampToFilename(File outputFile, String locale, String decorator, String suffix) {
        String timeStamp;
        if (suffix != null && suffix.length() > 0) {
            timeStamp = suffix;
        } else {
            this.m_lastTimeStamp = timeStamp = TimestampGenerator.getInstance().getSuffix();
        }
        String newName = this.appendSuffix(outputFile, locale, timeStamp, decorator);
        return newName;
    }

    public String getLastTimeStamp() {
        return this.m_lastTimeStamp;
    }

    public String getLastSequenceNumber() {
        return this.m_lastSequenceNumber;
    }

    public String getSuffix(ResolutionType type) {
        String suffix = "";
        if (type.equals(ResolutionType.CONFLICT_RESOLUTION_UNIQUE_SEQUENCE)) {
            suffix = String.valueOf(this.m_lastSequenceNumber);
        } else if (type.equals(ResolutionType.CONFLICT_RESOLUTION_UNIQUE_TIMESTAMP)) {
            suffix = this.m_lastTimeStamp;
        }
        if (suffix == null) {
            suffix = "";
        }
        return suffix;
    }

    private String appendSuffix(File fileName, String locale, String suffix, String decorator) {
        String[] parts;
        boolean hasDecorator;
        String[] fileNameArr = FileUtil.getFileNameParts((String)fileName.getName());
        String name = fileNameArr[0];
        boolean bl = hasDecorator = decorator != null && decorator.length() > 0;
        if (hasDecorator && (parts = fileNameArr[0].split("\\" + decorator)).length > 0) {
            name = parts[0];
        }
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append("_");
        buf.append(suffix);
        if (hasDecorator) {
            buf.append(decorator);
        }
        buf.append(".");
        buf.append(fileNameArr[1]);
        return buf.toString();
    }

    private void fail(File fileName) throws ReportOutputException {
        throw new ReportOutputException(DlsI18NCode.MSG_DS_DUPLICATE_REPORT_OUTPUT, new Object[]{fileName});
    }

    private int generateSequenceNumber(File outputFile, String decorator) {
        String[] parts;
        int sequence = 0;
        File aliasDir = new File(outputFile.getParent());
        if (aliasDir.isDirectory() && outputFile.exists() && (parts = FileUtil.getFileNameParts((String)outputFile.getName()))[0].length() > 0) {
            parts[0] = this.SPECIAL_REGEX_CHARS.matcher(parts[0]).replaceAll("\\\\$0");
            parts[1] = this.SPECIAL_REGEX_CHARS.matcher(parts[1]).replaceAll("\\\\$0");
            Perl5FilenameFilter pff = new Perl5FilenameFilter();
            String perlExp = "";
            if (decorator != null) {
                String[] fileNameMinusDecorator = parts[0].split("\\" + decorator);
                if (fileNameMinusDecorator.length > 0) {
                    perlExp = fileNameMinusDecorator[0] + "_\\d+\\" + decorator + "." + parts[1];
                }
            } else {
                perlExp = parts[0] + "_\\d+\\." + parts[1];
            }
            pff.setFilterExpression(perlExp);
            String[] related = aliasDir.list((FilenameFilter)pff);
            if (related.length > 0) {
                Arrays.sort(related, new SequencedFileComparator(decorator));
                String lastOutput = related[related.length - 1];
                sequence = this.extractSequence(lastOutput, decorator);
            }
        }
        int newSequence = ++sequence;
        this.m_lastSequenceNumber = String.valueOf(sequence);
        return newSequence;
    }

    private int extractSequence(String file, String decorator) {
        String[] fileNameMinusDecorator;
        String name = FileUtil.stripFileExtension((String)file);
        if (decorator != null && (fileNameMinusDecorator = name.split("\\" + decorator)).length > 0) {
            name = fileNameMinusDecorator[0];
        }
        int sequenceNumber = 0;
        int pos = name.lastIndexOf("_");
        if (pos != -1) {
            String intStr = name.substring(++pos);
            try {
                Integer seqInt = Integer.decode(intStr);
                sequenceNumber = seqInt;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return sequenceNumber;
    }

    private boolean isTimeStampAlwaysOn() {
        boolean enabled = false;
        try {
            String str = CRNProperties.getInstance().getProperty("emf.archive.filetimestamp.enabled");
            if (str != null && str.trim().length() > 0) {
                enabled = Boolean.valueOf(str);
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, (LocalizableException)((Object)ex));
        }
        catch (Throwable t) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
        }
        return enabled;
    }

    private class SequencedFileComparator
    implements Comparator<String>,
    Serializable,
    Externalizable {
        private static final long serialVersionUID = 70009003L;
        private String m_decorator;

        private SequencedFileComparator(String decorator) {
            this.m_decorator = decorator;
        }

        @Override
        public int compare(String fileName1, String fileName2) {
            Integer seq1 = new Integer(FileNameConflictResolver.this.extractSequence(fileName1, this.m_decorator));
            Integer seq2 = new Integer(FileNameConflictResolver.this.extractSequence(fileName2, this.m_decorator));
            return seq1.compareTo(seq2);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }
}

