/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.fs;

import com.cognos.dls.fs.OutputPropertiesBean;
import com.cognos.jsmcommon.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FileNameEncoder {
    private Map<Character, String> m_replacementTable;
    private String m_fileName;
    private String m_burstKey;
    private OutputPropertiesBean m_props;
    private String m_item;

    public FileNameEncoder(OutputPropertiesBean props) {
        this.m_props = props;
        this.m_replacementTable = new HashMap<Character, String>(11);
        this.m_replacementTable.put(new Character('\u0000'), "");
        this.m_replacementTable.put(new Character('<'), "_3C");
        this.m_replacementTable.put(new Character('>'), "_3E");
        this.m_replacementTable.put(new Character('|'), "_7C");
        this.m_replacementTable.put(new Character('\"'), "_22");
        this.m_replacementTable.put(new Character('\\'), "_5C");
        this.m_replacementTable.put(new Character('/'), "_2F");
        this.m_replacementTable.put(new Character(':'), "_3A");
        this.m_replacementTable.put(new Character('*'), "_2A");
        this.m_replacementTable.put(new Character('?'), "_3F");
        this.m_replacementTable.put(new Character('#'), "_23");
    }

    public String encode() {
        String fileName = this.m_props.getFileName();
        String burstKey = this.m_props.getBurstKey();
        fileName = this.encodeItem(fileName, burstKey, new char[0]);
        this.m_burstKey = this.m_item;
        this.m_fileName = this.encodeItem(fileName, fileName, new char[]{'/', '\\'});
        return this.m_fileName;
    }

    public boolean isEncoded() {
        return this.m_fileName != null;
    }

    public String getBurstKey() {
        return this.m_burstKey;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    private String encodeItem(String fileName, String item, char[] exclusions) {
        if (item != null && item.length() > 0) {
            ArrayList<Character> exclusionsList = new ArrayList<Character>(exclusions.length);
            for (int i = 0; i < exclusions.length; ++i) {
                exclusionsList.add(new Character(exclusions[i]));
            }
            boolean replaced = false;
            int pos = fileName.lastIndexOf(item);
            StringBuffer buf = new StringBuffer();
            if (pos != -1) {
                char[] itemKeyChars = item.toCharArray();
                for (int i = 0; i < itemKeyChars.length; ++i) {
                    Character itemChar = new Character(itemKeyChars[i]);
                    if (this.m_replacementTable.containsKey(itemChar) && !exclusionsList.contains(itemChar)) {
                        buf.append(this.m_replacementTable.get(itemChar));
                        if (replaced) continue;
                        replaced = true;
                        continue;
                    }
                    buf.append(itemChar);
                }
                if (replaced) {
                    this.m_item = buf.toString();
                    fileName = StringUtil.replace((String)fileName, (String)item, (String)buf.toString());
                } else {
                    this.m_item = item;
                }
            }
        }
        return fileName;
    }
}

