/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.fs;

import com.cognos.dls.fs.ResolutionType;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.soap.client.Attachment;
import java.io.File;
import java.net.URL;
import java.util.Calendar;

public class OutputPropertiesBean
implements Cloneable {
    private static final int MAX_FILENAME_LENGTH = 255;
    private int m_maxFilenameLength;
    private String m_reportName;
    private String m_alias;
    private String m_locale;
    private ResolutionType m_type = ResolutionType.CONFLICT_RESOLUTION_REPLACE;
    private String m_burstKey;
    private String m_extension;
    private File m_outputFile;
    private Calendar m_asOfTime;
    private String m_defaultName;
    private String m_defaultDescription;
    private String m_format;
    private URL m_root;
    private Attachment m_attachment;
    private String m_reportSearchPath;
    private String m_reportViewSearchPath;
    private Calendar m_executionTime;
    private String m_reportId;
    private String m_parameters;
    private String m_channel;
    private String m_fileNameDecorator;
    private String m_filename;

    public OutputPropertiesBean() {
    }

    public OutputPropertiesBean(String reportName, String alias, String locale, ResolutionType type, String burstKey, String extension, File outputFile, Calendar asOfTime, String defaultName, String defaultDescription, String format, URL root, Attachment attachment, String reportSearchPath, String reportViewSearchPath, Calendar executionTime, String reportId, String parameters, String channel, String decorator) {
        this.m_reportName = reportName;
        this.m_alias = alias;
        this.m_locale = locale;
        this.m_type = type;
        this.m_burstKey = burstKey;
        this.m_extension = extension;
        this.m_outputFile = outputFile;
        this.m_asOfTime = asOfTime;
        this.m_defaultName = defaultName;
        this.m_defaultDescription = defaultDescription;
        this.m_format = format;
        this.m_root = root;
        this.m_attachment = attachment;
        this.m_reportSearchPath = reportSearchPath;
        this.m_reportViewSearchPath = reportViewSearchPath;
        this.m_executionTime = executionTime;
        this.m_reportId = reportId;
        this.m_parameters = parameters;
        this.m_channel = channel;
        this.m_fileNameDecorator = decorator;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public File getAliasFile() {
        File alias = this.m_alias == null ? this.getRootFileName() : new File(this.getRootFileName(), this.m_alias);
        return alias;
    }

    public String getBurstKey() {
        return this.m_burstKey;
    }

    public void setBurstKey(String burstKey) {
        this.m_burstKey = burstKey;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public void setLocale(String locale) {
        this.m_locale = locale;
    }

    public String getFileNameStub() {
        return this.m_reportName;
    }

    public void setFileNameStub(String reportName) {
        this.m_reportName = reportName;
    }

    public void setRoot(URL root) {
        this.m_root = root;
    }

    public File getRootFileName() {
        String letter;
        String[] parts;
        String fileName = this.m_root.getFile();
        String protocol = this.m_root.getProtocol();
        String authority = this.m_root.getAuthority();
        String filePath = this.m_root.getFile();
        String host = this.m_root.getHost();
        if (protocol.equals("file") && authority != null && host.length() > 0 && (parts = authority.split("\\:")).length == 1 && (letter = parts[0]).equals(host)) {
            fileName = authority + filePath;
        }
        return new File(fileName);
    }

    public ResolutionType getType() {
        return this.m_type;
    }

    public void setType(ResolutionType type) {
        this.m_type = type;
    }

    public String getExtension() {
        return this.m_extension;
    }

    public void setExtension(String extension) {
        this.m_extension = extension;
    }

    public void setOutputFile(File file) {
        this.m_outputFile = file;
    }

    public File getOutputFile() {
        return this.m_outputFile;
    }

    public void setAsOfTime(Calendar cal) {
        this.m_asOfTime = cal;
    }

    public Calendar getAsOfTime() {
        return this.m_asOfTime;
    }

    public void setDefaultName(String name) {
        this.m_defaultName = name;
    }

    public String getDefaultName() {
        return this.m_defaultName;
    }

    public void setDefaultDescription(String desc) {
        this.m_defaultDescription = desc;
    }

    public String getDefaultDescription() {
        return this.m_defaultDescription;
    }

    public void setFormat(String format) {
        this.m_format = format;
    }

    public String getFormat() {
        return this.m_format;
    }

    public void setAttachment(Attachment attachment) {
        this.m_attachment = attachment;
    }

    public Attachment getAttachment() {
        return this.m_attachment;
    }

    public void setReportSearchPath(String path) {
        this.m_reportSearchPath = path;
    }

    public String getReportSearchPath() {
        return this.m_reportSearchPath;
    }

    public void setReportViewSearchPath(String path) {
        this.m_reportViewSearchPath = path;
    }

    public String getReportViewSearchPath() {
        return this.m_reportViewSearchPath;
    }

    public void setExecutionTime(Calendar cal) {
        this.m_executionTime = cal;
    }

    public Calendar getExecutionTime() {
        return this.m_executionTime;
    }

    public void setParameters(String params) {
        this.m_parameters = params;
    }

    public String getParameters() {
        return this.m_parameters;
    }

    public void setReportId(String id) {
        this.m_reportId = id;
    }

    public String getReportId() {
        return this.m_reportId;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setChannel(String value) {
        this.m_channel = value;
    }

    public String getChannel() {
        return this.m_channel;
    }

    public String getFileNameDecorator() {
        return this.m_fileNameDecorator;
    }

    public void setFileNameDecorator(String dec) {
        this.m_fileNameDecorator = dec;
    }

    public String getFileName() {
        return this.m_filename;
    }

    public void setFileName(String fileName) {
        this.m_filename = fileName;
    }

    public int getMaximumFileNameLength() {
        if (this.m_maxFilenameLength == 0) {
            try {
                String max = CRNProperties.getInstance().getProperty("archive.max.filename.length");
                this.m_maxFilenameLength = Integer.parseInt(max);
                if (this.m_maxFilenameLength == 0) {
                    this.m_maxFilenameLength = 255;
                }
            }
            catch (PropertiesException ex) {
                this.m_maxFilenameLength = 255;
            }
            catch (NumberFormatException ex) {
                this.m_maxFilenameLength = 255;
            }
        }
        return this.m_maxFilenameLength;
    }

    void setMaximumFileNameLength(int maxFileNameLength) {
        this.m_maxFilenameLength = maxFileNameLength;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("alias:" + this.getAlias());
        result.append(", BurstKey:" + this.getBurstKey());
        result.append(", channel:" + this.getChannel());
        result.append(", DefaultDescription:" + this.getDefaultDescription());
        result.append(", Defaultname:" + this.getDefaultName());
        result.append(", extension:" + this.getExtension());
        result.append(", FileName:" + this.getFileName());
        result.append(", Locale:" + this.getLocale());
        result.append(", MaximumFileNameLength:" + this.getMaximumFileNameLength());
        result.append(", AsOfTime:" + this.getAsOfTime());
        result.append(", Format:" + this.getFormat());
        return result.toString();
    }
}

