/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.fs;

import com.cognos.dls.fs.IWriter;
import com.cognos.dls.fs.OutputPropertiesBean;
import com.cognos.dls.fs.ResolutionType;
import com.cognos.dls.fs.WriteMetric;
import com.cognos.jsmcommon.soap.client.Attachment;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import javax.activation.DataHandler;

class OutputWriter
implements IWriter {
    private OutputPropertiesBean m_props;
    private WriteMetric m_metric;

    public OutputWriter(OutputPropertiesBean props) {
        this.m_props = props;
        this.m_metric = new WriteMetric();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String write() throws IOException {
        boolean success = false;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        boolean exists = false;
        try {
            Attachment attach = this.m_props.getAttachment();
            DataHandler handler = attach.getDataHandler();
            File outputFile = this.m_props.getOutputFile();
            exists = outputFile.exists();
            bis = new BufferedInputStream(handler.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(outputFile, false));
            byte[] buf = new byte[4096];
            int bytesRead = bis.read(buf, 0, 4096);
            while (bytesRead != -1) {
                ((BufferedOutputStream)bos).write(buf, 0, bytesRead);
                bytesRead = bis.read(buf, 0, 4096);
            }
            ((BufferedOutputStream)bos).flush();
            success = true;
        }
        finally {
            if (bis != null) {
                bis.close();
                if (bos != null) {
                    bos.close();
                    this.m_metric.setWritten(success);
                    this.m_metric.setReplaced(exists);
                }
            }
        }
        return "Success";
    }

    @Override
    public boolean validate() {
        File outputFile = this.m_props.getOutputFile();
        String locale = this.m_props.getLocale();
        ResolutionType type = this.m_props.getType();
        String extension = this.m_props.getExtension();
        File root = this.m_props.getRootFileName();
        String channel = this.m_props.getChannel();
        return outputFile != null && locale != null && locale.length() > 0 && type != null && extension != null && extension.length() > 0 && root != null && channel != null && channel.equalsIgnoreCase("archive");
    }

    @Override
    public WriteMetric getMetric() {
        return this.m_metric;
    }
}

