/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.fs;

import com.cognos.dls.fs.ReportOutputException;
import com.cognos.dls.fs.UnsafePathChecker;
import com.cognos.dls.i18n.DlsI18NCode;
import java.io.File;

public class PathBuilder {
    private File m_root;
    private String m_alias;

    public PathBuilder(File root, String alias) {
        this.m_root = root;
        this.m_alias = alias;
    }

    boolean aliasExists() {
        File aliasDir = this.getAliasDir(this.m_alias);
        return aliasDir.exists();
    }

    public synchronized File build() throws ReportOutputException {
        if (!UnsafePathChecker.isPathSafe(this.m_root, this.m_alias)) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_UNSAFE_ALIAS, new Object[]{this.m_alias});
        }
        return this.createAlias();
    }

    private File getAliasDir(String aliasStr) {
        File alias = aliasStr == null ? this.m_root : new File(this.m_root, aliasStr);
        return alias;
    }

    private File createAlias() {
        this.m_root.mkdirs();
        File aliasDir = this.getAliasDir(this.m_alias);
        aliasDir.mkdirs();
        return aliasDir;
    }
}

