/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.fs;

import com.cognos.dls.DLSCategory;
import com.cognos.dls.fs.FileNameConflictResolver;
import com.cognos.dls.fs.IWriter;
import com.cognos.dls.fs.OutputPropertiesBean;
import com.cognos.dls.fs.ReportOutputException;
import com.cognos.dls.fs.ResolutionType;
import com.cognos.dls.fs.WriteMetric;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.FileUtil;
import com.cognos.jsmcommon.util.StringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.oro.io.Perl5FilenameFilter;

public class ReportOutput {
    private static final int DIFF_INCREMENT_CONSTANT = 2;
    private static final int RESERVERED_CHARS_LENGTH = 6;
    private OutputPropertiesBean m_props;
    private IWriter m_writer;
    private String m_suffix;
    private int MAX_FILE_PATH_LENGTH;

    protected ReportOutput(OutputPropertiesBean props) {
        this.m_props = props;
        this.MAX_FILE_PATH_LENGTH = this.m_props.getMaximumFileNameLength();
        this.buildFileName();
        this.logDebug("Report output: " + this.m_props.toString());
    }

    public void resolveConflicts(FileNameConflictResolver resolver) throws ReportOutputException {
        this.resolveConflicts(resolver, "");
    }

    public void resolveConflicts(FileNameConflictResolver resolver, String suffix) throws ReportOutputException {
        File outputFile = this.m_props.getOutputFile();
        ResolutionType resolutionType = this.m_props.getType();
        String locale = this.m_props.getLocale();
        String dec = this.m_props.getFileNameDecorator();
        String fileName = resolver.resolve(outputFile, resolutionType, locale, dec, suffix);
        this.m_suffix = resolver.getSuffix(resolutionType);
        this.logDebug(" The OutputProprty bean attributes : " + this.m_props.toString());
        File newFile = new File(outputFile.getParent(), fileName);
        newFile = this.truncate(newFile, resolutionType);
        this.m_props.setOutputFile(newFile);
    }

    public boolean exists() throws ReportOutputException {
        this.validateAlias();
        return this.m_props.getOutputFile().exists();
    }

    public File getOutputFile() {
        return this.m_props.getOutputFile();
    }

    public ResolutionType getType() {
        return this.m_props.getType();
    }

    public String getSuffix() {
        if (this.m_suffix == null) {
            this.m_suffix = "";
        }
        return this.m_suffix;
    }

    public String write() throws ReportOutputException {
        boolean success;
        String sOutput = null;
        WriteMetric writeMetric = this.m_writer.getMetric();
        long lastMod = this.m_props.getOutputFile().lastModified();
        writeMetric.setModifiedDate(lastMod);
        if (this.m_writer == null) {
            this.logDebug("Cannot write the report output {0}. The writer is null", this.m_props.getOutputFile());
            writeMetric.setFailed(true);
        }
        if (!(success = this.m_writer.validate())) {
            writeMetric.setFailed(true);
            throw new ReportOutputException(DlsI18NCode.MSG_DS_INVALID_PROPERTIES);
        }
        File outputFile = this.m_props.getOutputFile();
        if (outputFile.exists() && (this.getType().equals(ResolutionType.CONFLICT_RESOLUTION_UNIQUE_SEQUENCE) || this.getType().equals(ResolutionType.CONFLICT_RESOLUTION_UNIQUE_TIMESTAMP))) {
            writeMetric.setFailed(true);
            throw new ReportOutputException(DlsI18NCode.MSG_DS_DUPLICATE_REPORT_OUTPUT, new Object[]{outputFile.getName()});
        }
        try {
            sOutput = this.m_writer.write();
            if (!outputFile.exists()) {
                this.logDebug("Problem!! {0} was not written!!!!!", outputFile.getName());
            }
        }
        catch (IOException ex) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_CANNOT_WRITE_REPORT_OUTPUT, new Object[]{ex});
        }
        return sOutput;
    }

    public void setWriter(IWriter writer) {
        this.m_writer = writer;
    }

    public IWriter getWriter() {
        return this.m_writer;
    }

    public WriteMetric getWriteMetrics() {
        return this.m_writer.getMetric();
    }

    public String toString() {
        return this.getOutputFile().toString();
    }

    private void validateAlias() throws ReportOutputException {
        File aliasDir = this.m_props.getAliasFile();
        if (!aliasDir.exists()) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_INVALID_ALIAS, new Object[]{aliasDir});
        }
        if (!aliasDir.canRead()) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_INVALID_ALIAS, new Object[]{aliasDir});
        }
    }

    private void buildFileName() {
        String fileNameDecorator = this.m_props.getFileNameDecorator();
        File file = this.m_props.getOutputFile();
        String[] fileNameArr = FileUtil.getFileNameParts((String)file.getName());
        StringBuffer buf = new StringBuffer();
        buf.append(fileNameArr[0]);
        if (fileNameDecorator != null && fileNameDecorator.length() > 0) {
            buf.append(fileNameDecorator);
        }
        buf.append(".");
        buf.append(fileNameArr[1]);
        File fullFileName = new File(file.getParentFile(), buf.toString());
        this.m_props.setOutputFile(fullFileName);
    }

    private File truncate(File outputFile, ResolutionType resolutionType) throws ReportOutputException {
        File truncatedFile = outputFile;
        String canonPath = this.getCanonPath(outputFile);
        int fullpathLength = canonPath.length();
        this.logDebug("canonical path : " + canonPath + " " + fullpathLength);
        this.logDebug("max filename length constant : " + this.MAX_FILE_PATH_LENGTH);
        if (fullpathLength > this.MAX_FILE_PATH_LENGTH) {
            String fileName;
            block7: {
                int pathLengthDifference = fullpathLength - this.MAX_FILE_PATH_LENGTH;
                String ext = FilenameUtils.getExtension((String)canonPath);
                String baseReportName = this.stripAll(outputFile);
                String burstKey = this.m_props.getBurstKey() == null ? "" : this.m_props.getBurstKey();
                fileName = outputFile.getName();
                this.logDebug("baseReportname :" + baseReportName);
                this.logDebug("diff in filepath and max : " + pathLengthDifference);
                String parentDir = outputFile.getParentFile().getAbsolutePath();
                int parentDirCharLength = parentDir.length() + 1;
                if (parentDirCharLength > this.MAX_FILE_PATH_LENGTH - 6) {
                    String errmsg = "DLS error msg:" + parentDir + " File path bigger than default or configured value [archive.max.filename.length] advanced setting: " + this.MAX_FILE_PATH_LENGTH;
                    this.logError(new Exception(errmsg));
                    throw new ReportOutputException(DlsI18NCode.MSG_DS_TRUNCATE_FAILED, new Object[]{errmsg});
                }
                try {
                    if (baseReportName.length() > pathLengthDifference + 2) {
                        fileName = this.truncateReportName(baseReportName, burstKey, ext, pathLengthDifference);
                        break block7;
                    }
                    if (this.itemExists(burstKey) && burstKey.length() > pathLengthDifference) {
                        fileName = this.truncateBurstKey(baseReportName, burstKey, ext, pathLengthDifference);
                        break block7;
                    }
                    this.logDebug("Cannot truncate report output :" + outputFile.getName());
                    throw new ReportOutputException(DlsI18NCode.MSG_DS_TRUNCATE_FAILED, new Object[]{outputFile.getName()});
                }
                catch (Exception e) {
                    this.logDebug("Cannot truncate report output " + outputFile.getName());
                    throw new ReportOutputException(DlsI18NCode.MSG_DS_TRUNCATE_FAILED, new Object[]{truncatedFile + " " + outputFile.getName()});
                }
            }
            truncatedFile = new File(outputFile.getParentFile(), fileName);
            if (!resolutionType.equals(ResolutionType.CONFLICT_RESOLUTION_REPLACE)) {
                truncatedFile = this.handleDuplicateFile(truncatedFile);
            }
        }
        return truncatedFile;
    }

    private String getCanonPath(File outputFile) throws ReportOutputException {
        String canonPath = "";
        try {
            canonPath = outputFile.getCanonicalPath();
        }
        catch (IOException ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)ex);
            this.logDebug("Cannot canonicalise report output :" + outputFile.toString() + ex.getMessage());
            throw new ReportOutputException(DlsI18NCode.MSG_DS_TRUNCATE_FAILED, new Object[]{outputFile.toString()});
        }
        return canonPath;
    }

    private String truncateReportName(String baseReportName, String burstKey, String ext, int diff) {
        this.logDebug("diff in truncateReportName :" + (diff += 2));
        this.logDebug("baseReportName in truncateReportName : " + baseReportName);
        baseReportName = baseReportName.substring(0, baseReportName.length() - diff);
        return this.assembleTruncatedFileName(baseReportName, burstKey, ext);
    }

    private String truncateBurstKey(String baseReportName, String burstKey, String ext, int diff) {
        burstKey = burstKey.substring(0, burstKey.length() - (diff += 2));
        return this.assembleTruncatedFileName(baseReportName, burstKey, ext);
    }

    private void logDebug(String msg, Object prop) {
        HashMap<String, Object> props = new HashMap<String, Object>(1);
        props.put("0", prop);
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(msg, props);
    }

    private void logDebug(String msg) {
        HashMap<String, String> props = new HashMap<String, String>(1);
        props.put("0", "");
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(msg, props);
    }

    private void logError(Exception ex) {
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)ex);
    }

    private File handleDuplicateFile(File truncatedFile) {
        if (truncatedFile.exists()) {
            File aliasDir = truncatedFile.getParentFile();
            String[] related = this.getRelatedFiles(truncatedFile);
            String lastOutput = related[related.length - 1];
            truncatedFile = this.getNewSequencedFileName(aliasDir, lastOutput);
        }
        return truncatedFile;
    }

    private String stripAll(File outputFile) {
        String key = this.m_props.getBurstKey();
        String dec = this.m_props.getFileNameDecorator();
        String fileName = FilenameUtils.getBaseName((String)outputFile.toString());
        fileName = StringUtil.replace((String)fileName, (String)("-" + this.m_props.getLocale()), (String)"");
        if (this.itemExists(key)) {
            fileName = StringUtil.replace((String)fileName, (String)("-" + key), (String)"");
        }
        if (this.itemExists(dec)) {
            fileName = StringUtil.replace((String)fileName, (String)dec, (String)"");
        }
        if (this.itemExists(this.m_suffix)) {
            fileName = StringUtil.replace((String)fileName, (String)("_" + this.m_suffix), (String)"");
        }
        return fileName;
    }

    private String assembleTruncatedFileName(String reportName, String burstKey, String ext) {
        StringBuffer buf = new StringBuffer();
        this.appendItem(buf, null, reportName, "-");
        this.appendItem(buf, null, this.m_props.getLocale(), null);
        this.appendItem(buf, "-", burstKey, null);
        buf.append("~1");
        this.appendItem(buf, null, this.m_props.getFileNameDecorator(), null);
        this.appendItem(buf, null, ".", ext);
        return buf.toString();
    }

    private boolean itemExists(String item) {
        return item != null && item.length() > 0;
    }

    private StringBuffer appendItem(StringBuffer buf, String prefix, String item, String suffix) {
        if (this.itemExists(item)) {
            if (prefix != null) {
                buf.append(prefix);
            }
            buf.append(item);
            if (suffix != null) {
                buf.append(suffix);
            }
        }
        return buf;
    }

    private File getNewSequencedFileName(File parent, String fileName) {
        File file = new File(parent, fileName);
        String lastOutput = file.toString();
        String ext = FilenameUtils.getExtension((String)lastOutput);
        int oldSequence = this.extractSequence(lastOutput);
        int newSequence = oldSequence + 1;
        String baseName = FilenameUtils.getBaseName((String)file.toString());
        String newFileName = StringUtil.replace((String)baseName, (String)("~" + oldSequence), (String)("~" + newSequence)) + "." + ext;
        file = new File(parent, newFileName);
        return file;
    }

    private String[] getRelatedFiles(File file) {
        Perl5FilenameFilter pff = this.buildFilter(file);
        File aliasDir = file.getParentFile();
        String[] related = aliasDir.list((FilenameFilter)pff);
        this.sort(related);
        return related;
    }

    private Perl5FilenameFilter buildFilter(File file) {
        Perl5FilenameFilter pff = new Perl5FilenameFilter();
        String perlExp = "";
        String[] parts = FileUtil.getFileNameParts((String)file.getName());
        String tempName = StringUtil.replace((String)parts[0], (String)"~1", (String)"");
        String decorator = this.m_props.getFileNameDecorator();
        if (decorator != null) {
            String[] fileNameMinusDecorator = tempName.split("\\" + decorator);
            if (fileNameMinusDecorator.length > 0) {
                perlExp = fileNameMinusDecorator[0] + "~\\d+\\" + decorator + "." + parts[1];
            }
        } else {
            perlExp = tempName + "~\\d+\\." + parts[1];
        }
        pff.setFilterExpression(perlExp);
        return pff;
    }

    private void sort(String[] files) {
        if (files.length > 1) {
            Arrays.sort(files, new Comparator<String>(){

                @Override
                public int compare(String fileName1, String fileName2) {
                    Integer seq1 = new Integer(ReportOutput.this.extractSequence(fileName1));
                    Integer seq2 = new Integer(ReportOutput.this.extractSequence(fileName2));
                    return seq1.compareTo(seq2);
                }
            });
        }
    }

    private int extractSequence(String fileName) {
        int pos;
        String name = FileUtil.stripFileExtension((String)fileName);
        int sequenceNumber = 0;
        String decorator = this.m_props.getFileNameDecorator();
        if (decorator != null) {
            name = StringUtil.replace((String)name, (String)decorator, (String)"");
        }
        if ((pos = name.lastIndexOf("~")) != -1) {
            String intStr = name.substring(++pos);
            try {
                Integer seqInt = Integer.decode(intStr);
                sequenceNumber = seqInt;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return sequenceNumber;
    }
}

