/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.fs;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.DLSVersionInfo;
import com.cognos.dls.fs.DescriptorWriter;
import com.cognos.dls.fs.FileNameConflictResolver;
import com.cognos.dls.fs.FileNameEncoder;
import com.cognos.dls.fs.OutputPropertiesBean;
import com.cognos.dls.fs.OutputWriter;
import com.cognos.dls.fs.PathBuilder;
import com.cognos.dls.fs.ReportOutput;
import com.cognos.dls.fs.ReportOutputException;
import com.cognos.dls.fs.ResolutionType;
import com.cognos.dls.fs.UnsafePathChecker;
import com.cognos.dls.fs.WriteMetric;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.jsmcommon.audit.CommonServiceLogUtil;
import com.cognos.jsmcommon.lock.ResourceLock;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.ResourceLockManager;
import com.cognos.jsmcommon.lock.jvm.JvmResourceLockFactory;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.FileUtil;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ThreadProperties;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;

public class ReportOutputBuilder {
    static final String BAK_EXT = ".bak";
    static final String DESC_SUFFIX = "_desc";
    static final String DESC_EXT = ".xml";
    private FileNameEncoder m_encoder;
    private static long filesOutputWaitingForLock = 0L;
    private static long fileLockCount = 0L;
    private OutputPropertiesBean m_props;
    private FileNameConflictResolver m_resolver;
    private BiBusHeader m_biBusHeader;

    public ReportOutputBuilder(OutputPropertiesBean props, BiBusHeader biBusHeader) throws ReportOutputException {
        this.m_props = props;
        this.m_biBusHeader = biBusHeader;
        this.m_resolver = new FileNameConflictResolver();
        this.m_encoder = new FileNameEncoder(props);
        File rootFile = this.m_props.getRootFileName();
        String alias = this.m_props.getAlias();
        PathBuilder pathBuilder = new PathBuilder(rootFile, alias);
        pathBuilder.build();
    }

    public OutputBundle buildOutputs() throws ReportOutputException {
        OutputBundle bundle = null;
        try {
            ReportOutput output = this.buildOutput();
            ReportOutput descriptor = this.buildDescriptor();
            bundle = new OutputBundle(output, descriptor, this.m_resolver);
        }
        catch (CloneNotSupportedException ex) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_CANNOT_PROCESS_REPORT_OUTPUTS, new Object[]{ex});
        }
        catch (ReportOutputException ex) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_CANNOT_PROCESS_REPORT_OUTPUTS, new Object[]{ex}, ex);
        }
        return bundle;
    }

    public String resolveConflicts(ReportOutput output) throws ReportOutputException {
        output.resolveConflicts(this.m_resolver);
        return output.getOutputFile().getName();
    }

    public List<ReportOutput> writeOutputs() throws ReportOutputException {
        OutputBundle outputs = this.buildOutputs();
        try {
            this.backup(outputs);
        }
        catch (IOException ex) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_CANNOT_PROCESS_REPORT_OUTPUTS, new Object[]{ex});
        }
        try {
            outputs.write();
        }
        catch (Throwable throwable) {
            try {
                this.tidyUp(outputs);
            }
            catch (IOException ex) {
                throw new ReportOutputException(DlsI18NCode.MSG_DS_CANNOT_PROCESS_REPORT_OUTPUTS, new Object[]{ex});
            }
            throw throwable;
        }
        try {
            this.tidyUp(outputs);
        }
        catch (IOException ex) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_CANNOT_PROCESS_REPORT_OUTPUTS, new Object[]{ex});
        }
        return outputs.getList();
    }

    private void backup(OutputBundle outputs) throws IOException {
        if (this.m_props.getType().equals(ResolutionType.CONFLICT_RESOLUTION_REPLACE)) {
            for (ReportOutput output : outputs.getList()) {
                if (!output.getOutputFile().exists()) continue;
                String backupFileName = output.getOutputFile().getName() + BAK_EXT;
                File backup = FileUtil.copy((File)output.getOutputFile(), (String)backupFileName);
                output.getWriteMetrics().setBackup(backup);
            }
        }
    }

    private void tidyUp(OutputBundle outputs) throws IOException {
        boolean failed = false;
        Iterator<ReportOutput> iter = outputs.getList().iterator();
        while (iter.hasNext() && !failed) {
            ReportOutput output = iter.next();
            failed = output.getWriteMetrics().isFailed();
        }
        if (failed) {
            for (ReportOutput output : outputs.getList()) {
                WriteMetric metric = output.getWriteMetrics();
                if (this.m_props.getType().equals(ResolutionType.CONFLICT_RESOLUTION_REPLACE) && metric.isWritten() && metric.hasBackup()) {
                    File backup = metric.getBackup();
                    FileUtil.copy((File)backup, (String)output.getOutputFile().getName());
                    continue;
                }
                if (!metric.isWritten()) continue;
                output.getOutputFile().delete();
            }
        }
        this.removeBackups(outputs);
    }

    private void removeBackups(OutputBundle outputs) {
        for (ReportOutput output : outputs.getList()) {
            File backupFile;
            WriteMetric metric = output.getWriteMetrics();
            if (!metric.hasBackup() || !(backupFile = metric.getBackup()).exists()) continue;
            backupFile.delete();
        }
    }

    private ReportOutput buildOutput() throws CloneNotSupportedException, ReportOutputException {
        ReportOutput output = null;
        String reportName = this.getFileName();
        String ext = this.m_props.getExtension().toLowerCase();
        File alias = this.m_props.getAliasFile();
        boolean isSafe = UnsafePathChecker.isPathSafe(this.m_props.getRootFileName(), this.m_props.getAlias(), reportName);
        if (!isSafe) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_UNSAFE_FILENAME, new Object[]{reportName});
        }
        if (ext.indexOf("/") > -1 || ext.indexOf("\\") > -1) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_INVALID_EXT, new Object[]{ext});
        }
        OutputPropertiesBean clonedProps = (OutputPropertiesBean)this.m_props.clone();
        File outputFile = new File(alias, reportName + "." + ext);
        clonedProps.setOutputFile(outputFile);
        output = new ReportOutput(clonedProps);
        output.setWriter(new OutputWriter(clonedProps));
        return output;
    }

    private String getFileName() {
        String fileName = "";
        fileName = this.m_encoder.encode();
        return fileName;
    }

    private ReportOutput buildDescriptor() throws CloneNotSupportedException, ReportOutputException {
        ReportOutput desc = null;
        String reportName = this.getFileName();
        File alias = this.m_props.getAliasFile();
        boolean isSafe = UnsafePathChecker.isPathSafe(this.m_props.getRootFileName(), this.m_props.getAlias(), reportName);
        if (!isSafe) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_UNSAFE_FILENAME, new Object[]{reportName});
        }
        OutputPropertiesBean clonedProps = (OutputPropertiesBean)this.m_props.clone();
        File descriptorFile = new File(alias, reportName + DESC_EXT);
        String decorator = "-" + this.m_props.getExtension() + DESC_SUFFIX;
        clonedProps.setFileNameDecorator(decorator);
        clonedProps.setOutputFile(descriptorFile);
        desc = new ReportOutput(clonedProps);
        desc.setWriter(new DescriptorWriter(clonedProps));
        return desc;
    }

    class OutputBundle {
        private ReportOutput m_output;
        private ReportOutput m_descriptor;

        public OutputBundle(ReportOutput output, ReportOutput descriptor, FileNameConflictResolver resolver) {
            this.m_output = output;
            this.m_descriptor = descriptor;
        }

        public ReportOutput getOutput() {
            return this.m_output;
        }

        public ReportOutput getDescriptor() {
            return this.m_descriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void write() throws ReportOutputException {
            ResourceLock lock = null;
            String strReportOutputLockKey = null;
            String srtReportOutputAbsolutePath = null;
            long timestampForDebugging = System.currentTimeMillis();
            UUID uniqueId = UUID.randomUUID();
            MessageDigest md = null;
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.AUDIT).debug("DLS ReportOutputBuilder:Outputbundle write call...");
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException nsae) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("ReportOutputBuilder : unable to load MD5 message digest algorithm : " + nsae.getMessage());
            }
            try {
                strReportOutputLockKey = srtReportOutputAbsolutePath = this.m_output.getOutputFile().getAbsolutePath();
                if (md != null) {
                    strReportOutputLockKey = new HexBinaryAdapter().marshal(md.digest(strReportOutputLockKey.getBytes()));
                }
                if (strReportOutputLockKey.length() > 50) {
                    strReportOutputLockKey = strReportOutputLockKey.substring(strReportOutputLockKey.length() - 50);
                    if (md == null) {
                        strReportOutputLockKey = strReportOutputLockKey.trim();
                    }
                }
                this.logDebug("DLS writing output for report ", srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                Object lockManager = (ResourceLockManager)ThreadProperties.getObject((String)"resource.lock.manager");
                lock = lockManager != null ? lockManager.getResourceLock(strReportOutputLockKey) : JvmResourceLockFactory.instance().getLock(strReportOutputLockKey);
                SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).debug("ReportOutputBuilder localmanager is" + lock.toString());
                this.logDebug("DLS trying to get a lock for report Output file ", srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                filesOutputWaitingForLock++;
                SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).debug("ReportOutputBuilder filesOutputWaitingForLock Count = " + filesOutputWaitingForLock + srtReportOutputAbsolutePath + timestampForDebugging + uniqueId);
                lock.lock();
                fileLockCount++;
                filesOutputWaitingForLock--;
                this.logDebug("fileLockAttemptCount = " + filesOutputWaitingForLock, srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                this.logDebug("fileLockCount = " + fileLockCount, srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                this.logDebug("DLS LOCKED ", srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).debug("ReportOutputBuilder LOCKED " + srtReportOutputAbsolutePath + timestampForDebugging + uniqueId);
                this.m_output.resolveConflicts(ReportOutputBuilder.this.m_resolver, "");
                String suffix = this.m_output.getSuffix();
                this.m_descriptor.resolveConflicts(ReportOutputBuilder.this.m_resolver, suffix);
                this.mkDirs(this.m_output);
                String sOutput = null;
                for (ReportOutput output : this.getList()) {
                    sOutput = output.write();
                    if (!(output.getWriter() instanceof DescriptorWriter)) continue;
                    this.logReportOutputAvailability(sOutput);
                }
                this.logDebug("DLS Report Output write completed !", srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
            }
            catch (Exception ex) {
                this.logDebug("Error writing the report output to the file system ", srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                this.logDebug("DLS :: CNC-DS-0025 Cannot write the report output to the file system :{0}. " + ex.getMessage(), srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                throw new ReportOutputException(DlsI18NCode.MSG_DS_CANNOT_WRITE_REPORT_OUTPUT, new Object[]{ex});
            }
            finally {
                block26: {
                    try {
                        if (lock == null || !lock.isLocked()) break block26;
                        String string = lock.getResource();
                        synchronized (string) {
                            this.logDebug("DLS Unlocking file...", srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.AUDIT).debug("DLS Unlocking file..." + srtReportOutputAbsolutePath + " " + timestampForDebugging + " " + uniqueId);
                            lock.unlock();
                            this.logDebug("DLS UNLOCKED Report Output file ", srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                            fileLockCount--;
                            this.logDebug("fileLockCount = " + fileLockCount, srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                        }
                    }
                    catch (Exception e) {
                        this.logDebug("DLS UNLOCK : Error releasing report output lock for file ", srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                        this.logDebug("DLS UNLOCK : Error " + e.getMessage(), srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.INFO, DlsI18NCode.MSG_DS_CANNOT_UNLOCK_REPORT_OUTPUTS);
                        try {
                            this.logDebug("DLS UNLOCK : Error so jvm lock cleanup called", srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                            JvmResourceLockFactory.instance().breakLocksForOwner(lock.getOwner());
                        }
                        catch (ResourceLockException e1) {
                            this.logDebug("UNLOCK : Error in calling breakLocksForOwner " + e1.getMessage(), srtReportOutputAbsolutePath, timestampForDebugging, uniqueId);
                            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.INFO, DlsI18NCode.MSG_DS_CANNOT_UNLOCK_REPORT_OUTPUTS);
                        }
                    }
                }
            }
        }

        private void logDebug(String message, String reportPath, long timestamp, UUID uniqueId) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("*ReportOutputBuilder* WRITE: " + uniqueId + " : " + timestamp + " : " + reportPath + " : " + message);
        }

        private void logReportOutputAvailability(String sOutput) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.ARCHIVE).debug(sOutput);
            String logText = "<parameters><item name=\"outputDescriptor\" type=\"blob\"><![CDATA[" + sOutput + "]]></item></parameters>";
            CommonServiceLogUtil.getLogUtil((SDSCategory)DLSCategory.RUNTIME, (Integer)DLSVersionInfo.getBuild(), (BiBusHeader)ReportOutputBuilder.this.m_biBusHeader, (String)ReportOutputBuilder.this.m_props.getReportSearchPath()).logDLSReportOutputArchive(logText);
        }

        public List<ReportOutput> getList() {
            ArrayList<ReportOutput> outputs = new ArrayList<ReportOutput>(2);
            outputs.add(this.m_output);
            outputs.add(this.m_descriptor);
            return outputs;
        }

        private void mkDirs(ReportOutput reportOutput) {
            File output = reportOutput.getOutputFile();
            if (!output.getParentFile().exists()) {
                output.getParentFile().mkdirs();
            }
        }
    }
}

