/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.fs;

import com.cognos.dls.fs.ReportOutputException;
import com.cognos.dls.i18n.DlsI18NCode;
import java.io.File;
import java.io.IOException;

public class UnsafePathChecker {
    private static final boolean isFileSystemCaseSensitive = !new File("a").equals(new File("A"));

    public static boolean isPathSafe(File root, String alias, String file) throws ReportOutputException {
        boolean safe = false;
        String canonAlias = "";
        String canonRoot = "";
        String canonRootAndAliasAndFile = "";
        if (alias == null) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_INVALID_ALIAS);
        }
        File fileDir = new File(root, alias);
        try {
            canonRoot = root.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_CANNOT_RETRIEVE_PATH, new Object[]{root.toString()});
        }
        try {
            canonAlias = fileDir.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new ReportOutputException(DlsI18NCode.MSG_DS_CANNOT_RETRIEVE_PATH, new Object[]{fileDir.toString()});
        }
        String sep = System.getProperty("file.separator");
        if (canonRoot != canonAlias && !canonRoot.endsWith(sep)) {
            canonRoot = canonRoot + sep;
        }
        if ((safe = canonAlias.startsWith(canonRoot)) && file != null) {
            File rootAndAliasAndFile = new File(fileDir, file);
            try {
                canonRootAndAliasAndFile = rootAndAliasAndFile.getCanonicalPath();
                String canonMinusFile = UnsafePathChecker.stripFileName(canonRootAndAliasAndFile, file);
                if (!canonAlias.equals(canonMinusFile)) {
                    safe = false;
                }
            }
            catch (IOException ex) {
                throw new ReportOutputException(DlsI18NCode.MSG_DS_CANNOT_RETRIEVE_PATH, new Object[]{rootAndAliasAndFile.toString()});
            }
        }
        return safe;
    }

    private static String stripFileName(String canonRootAndAliasAndFile, String fileName) throws IOException {
        fileName = new File(fileName).toString();
        String stripped = canonRootAndAliasAndFile;
        if (fileName.indexOf(System.getProperty("file.separator")) > -1) {
            StringBuffer buf = null;
            int pos = 0;
            if (isFileSystemCaseSensitive) {
                buf = new StringBuffer(canonRootAndAliasAndFile);
                pos = buf.indexOf(fileName);
            } else {
                buf = new StringBuffer(canonRootAndAliasAndFile.toLowerCase());
                pos = buf.indexOf(fileName.toLowerCase());
                buf = new StringBuffer(canonRootAndAliasAndFile);
            }
            if (pos > 1) {
                buf.delete(pos - 1, buf.length());
            }
            stripped = buf.toString();
        } else {
            stripped = new File(canonRootAndAliasAndFile).getParentFile().getCanonicalPath();
        }
        return stripped;
    }

    public static boolean isPathSafe(File root) throws ReportOutputException {
        return UnsafePathChecker.isPathSafe(root, null, null);
    }

    public static boolean isPathSafe(File root, String alias) throws ReportOutputException {
        return UnsafePathChecker.isPathSafe(root, alias, null);
    }
}

