/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.notification;

import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.AncestorInfoArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionString;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartObjectLinks;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.NotificationList;
import com.cognos.dls.api.DeliveryServiceHandler;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.notification.HTSNotificationException;
import com.cognos.dls.util.CMStoreIDWrapper;
import com.cognos.jsmcommon.http.HTTPRequest;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.XMLUtils;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class HTSConnector {
    private BiBusHeader header;
    private Option[] options;
    private static final SDSLogger TRACE_LOGGER = SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE);
    private static final SDSLogger RUNTIME_LOGGER = SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME);

    public HTSConnector(BiBusHeader header, Option[] options) {
        this.header = header;
        this.options = options;
    }

    public void notifyHTS() throws LocalizableException {
        NotificationList nList;
        BaseClass bcObj;
        SearchPathSingleObject spso;
        DeliveryServiceHandler handler = new DeliveryServiceHandler(this.header, true);
        DeliveryOption notificationListOption = (DeliveryOption)OptionUtils.findFirstOptionWithNameEnum((Option[])this.options, (Object)DeliveryOptionEnum.notificationList);
        if (notificationListOption != null && notificationListOption instanceof DeliveryOptionSearchPathSingleObject && (spso = ((DeliveryOptionSearchPathSingleObject)notificationListOption).getValue()) != null && (bcObj = handler.getNotificationObject(spso)) != null && (nList = new NotificationList((BaseClass)((BaseReport)bcObj))).isEnabled()) {
            this.sendNotification(nList.getAllUsers());
        }
    }

    private void sendNotification(List<String> recipients) throws HTSNotificationException {
        DeliveryOptionMemoPart memoPartOption;
        MemoPart memoPart;
        for (String recipient : recipients) {
            TRACE_LOGGER.debug("DLS sending notification to HTS for user: " + recipient);
        }
        DeliveryOptionString subjectOption = (DeliveryOptionString)OptionUtils.findFirstOptionWithNameEnum((Option[])this.options, (Object)DeliveryOptionEnum.subject);
        String subject = subjectOption == null ? null : subjectOption.getValue();
        DeliveryOption option = (DeliveryOption)OptionUtils.findFirstOptionWithNameEnum((Option[])this.options, (Object)DeliveryOptionEnum.memoPart);
        if (option != null && option instanceof DeliveryOptionMemoPart && (memoPart = (memoPartOption = (DeliveryOptionMemoPart)option).getValue()) instanceof MemoPartComposite) {
            MemoPart[] parts;
            MemoPartComposite compMemoPart = (MemoPartComposite)memoPart;
            for (MemoPart part : parts = compMemoPart.getParts()) {
                if (!(part instanceof MemoPartObjectLinks)) continue;
                ObjectLink[] links = ((MemoPartObjectLinks)part).getLinks();
                LinksInfo linksInfo = this.getLinksInfoFromCM(links);
                this.callHTS(recipients, subject, linksInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callHTS(List<String> recipients, String subject, LinksInfo linksInfo) throws HTSNotificationException {
        ReportViewInfo reportViewInfo = linksInfo.getReportView();
        TRACE_LOGGER.debug("DLS calling HTS with Subject: " + subject + "; Label: " + reportViewInfo.getName() + "; Number of links: " + linksInfo.getLinks().size());
        Scanner scanner = null;
        try {
            InputStream is = HTSConnector.class.getResourceAsStream("notificationTask.xml");
            scanner = new Scanner(is, "UTF-8");
            String htsRequest = scanner.useDelimiter("\\A").next();
            String soapAction = "http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1";
            htsRequest = htsRequest.replaceAll("_RECIPIENTS_", this.prepareRecipientsPart(recipients)).replaceAll("_SUBJECT_", XMLUtils.forceEscape((String)subject)).replaceAll("_LINKS_", this.prepareLinksPart(linksInfo));
            this.sendSOAPRequest(soapAction, htsRequest);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String prepareRecipientsPart(List<String> recipients) {
        String template;
        StringBuffer result = new StringBuffer();
        Scanner scanner = null;
        try {
            InputStream is = HTSConnector.class.getResourceAsStream("notificationTaskRecipient.xml");
            scanner = new Scanner(is, "UTF-8");
            template = scanner.useDelimiter("\\A").next();
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        for (String recipient : recipients) {
            TRACE_LOGGER.debug("prepare recipient: " + recipient);
            result.append(template.replaceAll("_RECIPIENT_", XMLUtils.forceEscape((String)recipient)));
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String prepareLinksPart(LinksInfo linksInfo) {
        String template;
        StringBuffer result = new StringBuffer();
        Scanner scanner = null;
        try {
            InputStream is = HTSConnector.class.getResourceAsStream("notificationTaskLink.xml");
            scanner = new Scanner(is, "UTF-8");
            template = scanner.useDelimiter("\\A").next();
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        List<OutputInfo> links = linksInfo.getLinks();
        for (OutputInfo link : links) {
            CMStoreIDWrapper outputStoreId = new CMStoreIDWrapper(link.getLink());
            ReportViewInfo reportView = linksInfo.getReportView();
            TRACE_LOGGER.debug("prepare link: " + reportView.getName() + " >" + outputStoreId.getSearchPath() + "<");
            result.append(template.replaceAll("_LABEL_", XMLUtils.forceEscape((String)reportView.getName())).replaceAll("_CLASS_", "output").replaceAll("_REPORTVIEWSEARCHPATH_", reportView.getSearchPath()).replaceAll("_OUTPUTSEARCHPATH_", outputStoreId.getStoreId()).replaceAll("_FORMAT_", link.getFormat()));
        }
        return result.toString();
    }

    private void sendSOAPRequest(String soapAction, String body) throws HTSNotificationException {
        TRACE_LOGGER.debug("DLS sending SOAP request: " + body);
        HTTPRequest request = new HTTPRequest(soapAction);
        try {
            BIBusEnvelope envelope = BiBusUtilities.getHeadedEnvelope((BiBusHeader)this.header);
            if (body != null && body.length() > 0) {
                try {
                    Document document = DocumentHelper.parseText((String)body);
                    Element rootEl = document.getRootElement();
                    if (rootEl != null) {
                        envelope.getBody().add(rootEl.detach());
                    }
                }
                catch (DocumentException e) {
                    throw new HTSNotificationException(DlsI18NCode.MSG_DS_HTS_REQUEST_FAULT, new Object[]{e.getMessage()});
                }
            }
            StringWriter aWriter = new StringWriter();
            OutputFormat format = new OutputFormat();
            format.setNewLineAfterDeclaration(false);
            XMLWriter xmlWriter = new XMLWriter((Writer)aWriter, format);
            xmlWriter.write(envelope.getAsDocument());
            xmlWriter.flush();
            request.setRequestBody(aWriter.toString());
            String response = request.retrieveContent();
            TRACE_LOGGER.debug("DLS Received HTS response: " + response);
            BIBusEnvelope responseEnvelope = null;
            responseEnvelope = new BIBusEnvelope((Reader)new StringReader(response));
            String faultDetail = responseEnvelope.getFaultString();
            if (faultDetail != null) {
                throw new HTSNotificationException(DlsI18NCode.MSG_DS_HTS_REQUEST_FAULT, new Object[]{faultDetail});
            }
        }
        catch (HTSNotificationException e) {
            RUNTIME_LOGGER.log(SDSLevel.ERROR, (LocalizableException)e);
            throw e;
        }
        catch (Exception ex) {
            RUNTIME_LOGGER.log(SDSLevel.ERROR, (Throwable)ex);
            throw new HTSNotificationException(DlsI18NCode.MSG_DS_HTS_REQUEST_FAULT, new Object[]{ex.getMessage()}, ex, SeverityEnum.fatal);
        }
    }

    private LinksInfo getLinksInfoFromCM(ObjectLink[] links) {
        if (links == null || links.length == 0) {
            return null;
        }
        String label = links[0].getLabel();
        LinksInfo linksInfo = null;
        PropEnum[] properties = new PropEnum[]{PropEnum.storeID, PropEnum.ancestors, PropEnum.format};
        ArrayList<QueryRequest> requests = new ArrayList<QueryRequest>();
        for (ObjectLink link : links) {
            QueryRequest baseRequest = new QueryRequest();
            baseRequest.setSearch(link.getSearchPath().get_value());
            baseRequest.setProperties(properties);
            requests.add(baseRequest);
        }
        QueryReply[] replies = this.queryCM(requests);
        if (replies != null && replies.length > 0) {
            ReportViewInfo reportViewInfo = this.extractReportViewFromAncestorInfo(replies[0], label);
            linksInfo = new LinksInfo(reportViewInfo);
            OutputInfo output = null;
            for (QueryReply reply : replies) {
                BaseClass[] objects = reply.getQueryResult();
                if (objects == null || objects.length != 1 || !(objects[0] instanceof Output)) continue;
                Output obj = (Output)objects[0];
                output = new OutputInfo("storeID('" + obj.getStoreID().getValue().get_value() + "')", obj.getFormat().getValue());
                if (output.format.equals("MHT") || output.format.equals("layoutDataXML")) continue;
                linksInfo.addLink(output);
            }
        }
        return linksInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryReply[] queryCM(List<QueryRequest> requestList) {
        QueryRequest[] requests = requestList.toArray(new QueryRequest[0]);
        QueryReply[] replies = null;
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(this.header));
        try {
            replies = cmPort.queryMultiple(requests);
        }
        catch (SDKClientException e) {
            RUNTIME_LOGGER.log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_CM_REQUEST_FAULT, new Object[]{e.getFaultString()});
            TRACE_LOGGER.debug((Throwable)e, true);
        }
        catch (EMFSecurityException e) {
            RUNTIME_LOGGER.log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_CM_REQUEST_FAULT, new Object[]{e.getMessage()});
            TRACE_LOGGER.debug((Throwable)e, true);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return replies;
    }

    private ReportViewInfo extractReportViewFromAncestorInfo(QueryReply result, String defaultName) {
        BaseClass[] objects;
        ReportViewInfo reportViewInfo = null;
        if (result != null && (objects = result.getQueryResult()) != null && objects.length == 1) {
            AncestorInfo[] ancestorInfoArray;
            BaseClass objectBaseClass = objects[0];
            AncestorInfoArrayProp ancestorInfoArrayProp = objectBaseClass.getAncestors();
            for (AncestorInfo ancestorInfo : ancestorInfoArray = ancestorInfoArrayProp.getValue()) {
                if (!ancestorInfo.getObjectClass().getValue().equals("reportView") && !ancestorInfo.getObjectClass().getValue().equals("report")) continue;
                String name = ancestorInfo.getTitle();
                String storeIDSearchPath = "storeID('" + ancestorInfo.getStoreID() + "')";
                reportViewInfo = new ReportViewInfo(name, storeIDSearchPath);
                break;
            }
        }
        if (reportViewInfo == null) {
            TRACE_LOGGER.debug("Failed to retrieve the reportView name from CM. Use the output format label instead.");
            reportViewInfo = new ReportViewInfo(defaultName, null);
        }
        return reportViewInfo;
    }

    private static class ReportViewInfo {
        private String name = null;
        private String searchPath = null;

        public ReportViewInfo(String name, String searchPath) {
            this.name = name;
            this.searchPath = searchPath;
        }

        public String getName() {
            return this.name;
        }

        public String getSearchPath() {
            return this.searchPath;
        }
    }

    private static class OutputInfo {
        private String link = null;
        private String format = null;

        public OutputInfo(String link, String format) {
            this.link = link;
            this.format = format;
        }

        public String getLink() {
            return this.link;
        }

        public String getFormat() {
            return this.format;
        }
    }

    private static class LinksInfo {
        private ReportViewInfo reportViewInfo = null;
        private ArrayList<OutputInfo> links = new ArrayList();

        public LinksInfo(ReportViewInfo reportViewInfo) {
            this.reportViewInfo = reportViewInfo;
        }

        public ReportViewInfo getReportView() {
            return this.reportViewInfo;
        }

        public List<OutputInfo> getLinks() {
            return this.links;
        }

        public void addLink(OutputInfo link) {
            this.links.add(link);
        }
    }
}

