/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.rss;

import com.cognos.developer.schemas.bibus._3.AgentOutputEnum;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseRSSTask;
import com.cognos.developer.schemas.bibus._3.MultilingualStringProp;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.RssOption;
import com.cognos.developer.schemas.bibus._3.RssOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.RssOptionEnum;
import com.cognos.developer.schemas.bibus._3.RssOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.RssOptionString;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.ShortcutAgentRSSTask;
import com.cognos.developer.schemas.bibus._3.ShortcutRSSTask;
import com.cognos.developer.schemas.bibus._3.UrlRSSTask;
import com.cognos.dls.HistoryTopicsProcessor;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.util.HashMap;
import java.util.Map;

public class RssOptionsParser {
    private String m_name;
    private String m_description;
    private String m_screenTip;
    private String m_channel;
    private String m_url;
    private SearchPathSingleObject m_target;
    private Boolean m_createObject;
    private HistoryTopicsProcessor m_historyTopicProcessor = null;
    private static int NAME_LENGTH = 255;

    public RssOptionsParser(BaseRSSTask task) {
        this.process(null, task);
    }

    public RssOptionsParser(RssOption[] options, BaseRSSTask task, ParameterValue[] parameterValues) {
        if (parameterValues != null) {
            this.m_historyTopicProcessor = new HistoryTopicsProcessor(parameterValues);
        }
        this.process(options, task);
    }

    private void process(RssOption[] options, BaseRSSTask task) {
        HashMap<RssOptionEnum, RssOption> option_map = new HashMap<RssOptionEnum, RssOption>();
        for (int i = 0; options != null && i < options.length; ++i) {
            option_map.put(options[i].getName(), options[i]);
        }
        if (option_map.containsKey(RssOptionEnum.itemName)) {
            this.setName(this.extractOptionString(option_map, RssOptionEnum.itemName, NAME_LENGTH));
        } else {
            this.setName(this.extractMultiLingualString(task.getTitle(), NAME_LENGTH));
        }
        if (option_map.containsKey(RssOptionEnum.itemDescription)) {
            this.setDescription(this.extractOptionString(option_map, RssOptionEnum.itemDescription, -1));
        } else {
            this.setDescription(this.extractMultiLingualString(task.getDescription(), -1));
        }
        if (option_map.containsKey(RssOptionEnum.itemScreenTip)) {
            this.setScreenTip(this.extractOptionString(option_map, RssOptionEnum.itemScreenTip, -1));
        } else {
            this.setScreenTip(this.extractMultiLingualString(task.getScreenTip(), -1));
        }
        if (option_map.containsKey(RssOptionEnum.createItem)) {
            this.setCreateObject(Boolean.TRUE);
        } else if (option_map.containsKey(RssOptionEnum.deleteItem)) {
            this.setCreateObject(Boolean.FALSE);
        }
        if (option_map.containsKey(RssOptionEnum.itemTarget)) {
            RssOptionSearchPathSingleObject spOption = (RssOptionSearchPathSingleObject)option_map.get(RssOptionEnum.itemTarget);
            this.setTarget(spOption.getValue());
        } else if (option_map.containsKey(RssOptionEnum.itemURI)) {
            RssOptionAnyURI uriOption = (RssOptionAnyURI)option_map.get(RssOptionEnum.itemURI);
            this.setUrl(uriOption.getValue());
        } else if (task instanceof ShortcutRSSTask) {
            BaseClass[] link = ((ShortcutRSSTask)task).getLink().getValue();
            if (link != null && link.length > 0) {
                this.setTarget(ObjectModelUtil.makeSearPathSingleObject((String)link[0].getSearchPath().getValue()));
            }
        } else if (task instanceof ShortcutAgentRSSTask) {
            AgentOutputEnum link_type = ((ShortcutAgentRSSTask)task).getLink().getValue();
            if (AgentOutputEnum.hotList.equals((Object)link_type)) {
                SearchPathSingleObject asp = ObjectModelUtil.getAgentAncestorSp((BaseClass)task);
                SearchPathSingleObject aosp = ObjectModelUtil.changeAgentpathsToAgentOutputPaths((SearchPathSingleObject)asp, (String)"HTML");
                this.setTarget(aosp);
            }
        } else if (task instanceof UrlRSSTask) {
            String link = ((UrlRSSTask)task).getLink().getValue();
            this.setUrl(link);
        }
        BaseClass[] channel = task.getChannel().getValue();
        if (channel != null && channel.length > 0) {
            this.setChannel(channel[0].getSearchPath().getValue());
        }
    }

    public String getChannel() {
        return this.m_channel;
    }

    public void setChannel(String channel) {
        this.m_channel = channel;
    }

    public Boolean isCreateObject() {
        return this.m_createObject;
    }

    public void setCreateObject(Boolean createObject) {
        this.m_createObject = createObject;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getScreenTip() {
        return this.m_screenTip;
    }

    public void setScreenTip(String screenTip) {
        this.m_screenTip = screenTip;
    }

    public SearchPathSingleObject getTarget() {
        return this.m_target;
    }

    public void setTarget(SearchPathSingleObject target) {
        this.m_target = target;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    private String extractMultiLingualString(MultilingualStringProp stringsProp, int name_length) {
        String the_extracted = null;
        if (stringsProp != null && stringsProp.getValue() != null && stringsProp.getValue().length > 0 && stringsProp.getValue()[0] != null) {
            the_extracted = stringsProp.getValue()[0].getValue();
        }
        if (this.m_historyTopicProcessor != null) {
            the_extracted = this.m_historyTopicProcessor.replace(the_extracted, name_length);
        }
        return the_extracted;
    }

    private String extractOptionString(Map option_map, RssOptionEnum name, int name_length) {
        String value;
        RssOptionString ros = (RssOptionString)option_map.get(name);
        String string = value = ros != null ? ros.getValue() : null;
        if (this.m_historyTopicProcessor != null && value != null) {
            value = this.m_historyTopicProcessor.replace(value, name_length);
        }
        return value;
    }
}

