/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.rss;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseRSSTask;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.developer.schemas.bibus._3.MultilingualString;
import com.cognos.developer.schemas.bibus._3.MultilingualStringProp;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.RssOption;
import com.cognos.developer.schemas.bibus._3.RssOptionEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.ShortcutAgentRSSTask;
import com.cognos.developer.schemas.bibus._3.ShortcutRSSTask;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.UiClass;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UrlRSSTask;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.OptionsRunnable;
import com.cognos.dls.OptionsRunnableFactoryException;
import com.cognos.dls.OptionsValidator;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.rss.RssException;
import com.cognos.dls.rss.RssOptionsParser;
import com.cognos.dls.rss.ShortcutRssOptionsRunnable;
import com.cognos.dls.rss.UrlRssOptionsRunnable;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tasks.AgentTaskOutputState;
import com.cognos.jsmcommon.tasks.AgentTaskOutputStateService;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.apache.axis.AxisFault;

public abstract class RssOptionsRunnable
extends OptionsRunnable {
    private BaseRSSTask m_baseRss;
    private RssOptionsParser m_options_parser;

    public static RssOptionsRunnable getRunnable(SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options, BiBusHeader header) throws LocalizableException {
        RssOptionsRunnable rssRunnable = null;
        QueryRequest rssRequest = new QueryRequest();
        rssRequest.setSearch(objectPath.get_value());
        rssRequest.setProperties(new PropEnum[]{PropEnum.ancestors, PropEnum.searchPath, PropEnum.channel, PropEnum.defaultName, PropEnum.description, PropEnum.link, PropEnum.screenTip, PropEnum.title, PropEnum.uri, PropEnum.storeID});
        JobBiBusHeaders jobHeader = new JobBiBusHeaders(header);
        ContentManagerServiceClientPort cmscp = Client.instance().getContentManagerServiceClient(jobHeader);
        try {
            BaseClass base = cmscp.query(rssRequest);
            if (base instanceof UrlRSSTask) {
                rssRunnable = new UrlRssOptionsRunnable((UrlRSSTask)base, parameterValues, options, jobHeader);
            } else if (base instanceof ShortcutRSSTask) {
                rssRunnable = new ShortcutRssOptionsRunnable((BaseRSSTask)((ShortcutRSSTask)base), parameterValues, options, jobHeader);
            } else if (base instanceof ShortcutAgentRSSTask) {
                rssRunnable = new ShortcutRssOptionsRunnable((BaseRSSTask)base, parameterValues, options, jobHeader);
            }
        }
        catch (Throwable t) {
            if (t instanceof LocalizableException) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, (LocalizableException)t);
            } else {
                String msg = t.getLocalizedMessage();
                if (msg == null) {
                    msg = t.getClass().getName();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    pw.close();
                    String debugMsg = sw.toString();
                    SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug(debugMsg);
                }
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_3RD_PARTY_FAULT, new Object[]{msg});
            }
            throw new OptionsRunnableFactoryException(DlsI18NCode.MSG_DS_GENERAL_ERROR);
        }
        finally {
            cmscp.close();
        }
        return rssRunnable;
    }

    public RssOptionsRunnable(BaseRSSTask baseRss, ParameterValue[] parameterValues, Option[] options) throws LocalizableException {
        super(OptionsValidator.RSS_VALIDATOR, baseRss.getStoreID(), parameterValues, options);
        this.setBaseRss(baseRss);
    }

    public RssOption[] getRSSOptions() {
        Option[] options = this.getOptions();
        List<Option> listOptions = Arrays.asList(OptionUtils.findOptionsByType((Option[])options, RssOption.class));
        return listOptions.toArray(new RssOption[listOptions.size()]);
    }

    @Override
    public void run() throws LocalizableException, AxisFault {
        boolean runCreate = true;
        RssOption[] options = this.getRSSOptions();
        for (int i = 0; i < options.length; ++i) {
            if (!RssOptionEnum.deleteItem.equals((Object)options[i].getName())) continue;
            runCreate = false;
        }
        try {
            if (runCreate) {
                this.runCreate();
            } else {
                this.runDelete();
            }
        }
        catch (LocalizableException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, e);
            throw e;
        }
        catch (Exception e) {
            String msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = e.getClass().getName();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.close();
                String debugMsg = sw.toString();
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug(debugMsg);
            }
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, I18NCode.GEN_3RD_PARTY_FAULT, new Object[]{msg});
            throw new RssException(I18NCode.GEN_3RD_PARTY_FAULT, new Object[]{e});
        }
    }

    private void runCreate() throws Exception {
        BaseRSSTask baseRss = this.getBaseRss();
        Option[] options = this.getOptions();
        OptionArrayProp optionArrayProp = new OptionArrayProp();
        optionArrayProp.setValue(options);
        baseRss.setOptions(optionArrayProp);
        AgentTaskOutputState state = AgentTaskOutputStateService.getAgentTaskOutputState((BaseClass)baseRss, (JobBiBusHeaders)this.getJobHeaders());
        this.removeOutputObject(state);
        BaseClass[] creates = null;
        creates = this.createOutputObject();
        AgentTaskOutputStateService.updateAgentTaskOutputState((BaseClass[])creates, (AgentTaskOutputState)state, (BaseClass)baseRss, (JobBiBusHeaders)this.getJobHeaders());
        baseRss.setOptions(null);
    }

    private void runDelete() throws Exception {
        AgentTaskOutputState state = AgentTaskOutputStateService.getAgentTaskOutputState((BaseClass)this.m_baseRss, (JobBiBusHeaders)this.getJobHeaders());
        this.removeOutputObject(state);
        AgentTaskOutputStateService.clearAgentTaskOutputState((AgentTaskOutputState)state, (BaseClass)this.m_baseRss, (JobBiBusHeaders)this.getJobHeaders());
    }

    protected BaseClass[] createOutputObject() throws Exception {
        BaseClass[] the_created;
        block7: {
            BaseClass to_save = this.getCreateObject();
            AddOptions aop = new AddOptions();
            aop.setUpdateAction(UpdateActionEnum.replace);
            the_created = null;
            ContentManagerServiceClientPort cmsp = Client.instance().getContentManagerServiceClient(this.getJobHeaders());
            try {
                String path = this.getOptionsParser().getChannel();
                if (path != null) {
                    the_created = cmsp.add(new SearchPathSingleObject(path), new BaseClass[]{to_save}, aop);
                    if (the_created.length == 0) {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, I18NCode.AGENT_RUN_ERROR, new Object[0]);
                        String name = this.getOptionsParser().getName();
                        throw new RssException(DlsI18NCode.MSG_DS_RSS_FAILED_CREATE, new Object[]{name});
                    }
                    break block7;
                }
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, I18NCode.AGENT_RUN_ERROR, new Object[0]);
                String name = this.getOptionsParser().getName();
                throw new RssException(DlsI18NCode.MSG_DS_RSS_FAILED_TARGET, new Object[]{name});
            }
            catch (SDKClientException sdke) {
                String name = this.getOptionsParser().getName();
                throw new RssException(DlsI18NCode.MSG_DS_RSS_FAILED_LINK, new Object[]{name}, (LocalizableException)((Object)sdke));
            }
            finally {
                cmsp.close();
            }
        }
        return the_created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOutputObject(AgentTaskOutputState state) throws Exception {
        if (state == null || state.getObjectPaths().length == 0) {
            return;
        }
        BaseClass[] searchPaths = this.getDeleteObjects(state.getObjectPaths());
        DeleteOptions dop = new DeleteOptions();
        dop.setForce(true);
        dop.setRecursive(true);
        dop.setFaultIfObjectReferenced(false);
        ContentManagerServiceClientPort cmsp = Client.instance().getContentManagerServiceClient(this.getJobHeaders());
        try {
            cmsp.delete(searchPaths, dop);
            state.clear();
        }
        finally {
            cmsp.close();
        }
    }

    protected abstract BaseClass getCreateObject() throws AxisFault;

    protected abstract BaseClass[] getDeleteObjects(String[] var1);

    protected void setBaseRss(BaseRSSTask baseRss) {
        this.m_baseRss = baseRss;
    }

    protected BaseRSSTask getBaseRss() {
        return this.m_baseRss;
    }

    protected RssOptionsParser getOptionsParser() {
        if (this.m_options_parser == null) {
            this.m_options_parser = new RssOptionsParser(this.getRSSOptions(), this.getBaseRss(), this.getParameterValues());
        }
        return this.m_options_parser;
    }

    protected void setBaseStrings(UiClass obj) throws AxisFault {
        RssOptionsParser optionsParser = this.getOptionsParser();
        StringProp sp = new StringProp();
        sp.setValue(optionsParser.getChannel());
        obj.setSearchPath(sp);
        obj.setDescription(this.makeStringProp(optionsParser.getDescription()));
        String s = optionsParser.getName();
        if (s != null && s.indexOf(39) != -1) {
            s = s.replace('\"', '\'');
        } else if (s != null && s.indexOf(34) != -1) {
            s = s.replace('\'', '\"');
        }
        obj.setName(this.makeTokenProp(s));
        obj.setScreenTip(this.makeStringProp(optionsParser.getScreenTip()));
    }

    private MultilingualStringProp makeStringProp(String value) throws AxisFault {
        if (value == null) {
            return null;
        }
        MultilingualString[] mls = new MultilingualString[]{new MultilingualString()};
        mls[0].setValue(value);
        mls[0].setLocale(LocaleUtil.getRequestProductLocale((BiBusHeader)this.getHeaders()).toString());
        MultilingualStringProp mlsp = new MultilingualStringProp();
        mlsp.setValue(mls);
        return mlsp;
    }

    private MultilingualTokenProp makeTokenProp(String value) throws AxisFault {
        if (value == null) {
            return null;
        }
        MultilingualToken[] mlt = new MultilingualToken[]{new MultilingualToken()};
        mlt[0].setValue(value);
        mlt[0].setLocale(LocaleUtil.getRequestProductLocale((BiBusHeader)this.getHeaders()).toString());
        MultilingualTokenProp mltp = new MultilingualTokenProp();
        mltp.setValue(mlt);
        return mltp;
    }
}

