/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.rss;

import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.RssOption;
import com.cognos.developer.schemas.bibus._3.RssOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.RssOptionEnum;
import com.cognos.developer.schemas.bibus._3.RssOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.RssOptionString;
import com.cognos.dls.OptionsValidator;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.rss.RssException;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.util.OptionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RssOptionsValidator
extends OptionsValidator {
    private static final Map m_option_definitions = new HashMap();
    private static OptionDefinition NAME = new OptionDefinition(RssOptionEnum.itemName, new Class[]{RssOptionString.class});
    private static OptionDefinition CREATE = new OptionDefinition(RssOptionEnum.createItem, new Class[]{RssOptionString.class});
    private static OptionDefinition DELETE = new OptionDefinition(RssOptionEnum.deleteItem, new Class[]{RssOptionString.class});
    private static OptionDefinition DESCRIPTION = new OptionDefinition(RssOptionEnum.itemDescription, new Class[]{RssOptionString.class});
    private static OptionDefinition SCREEN_TIP = new OptionDefinition(RssOptionEnum.itemScreenTip, new Class[]{RssOptionString.class});
    private static OptionDefinition TARGET = new OptionDefinition(RssOptionEnum.itemTarget, new Class[]{RssOptionSearchPathSingleObject.class});
    private static OptionDefinition URI = new OptionDefinition(RssOptionEnum.itemURI, new Class[]{RssOptionAnyURI.class});

    @Override
    public I18NMessage[] validate(Option[] options) throws RssException {
        ArrayList<RssOption> create_delete_options = new ArrayList<RssOption>();
        ArrayList<RssOption> target_uri_options = new ArrayList<RssOption>();
        for (int i = 0; i < options.length; ++i) {
            if (options[i] instanceof RssOption) {
                RssOption rss_option = (RssOption)options[i];
                this.validateOption(rss_option);
                if (RssOptionEnum.createItem.equals((Object)rss_option.getName()) || RssOptionEnum.deleteItem.equals((Object)rss_option.getName())) {
                    create_delete_options.add(rss_option);
                }
                if (!RssOptionEnum.itemTarget.equals((Object)rss_option.getName()) && !RssOptionEnum.itemURI.equals((Object)rss_option.getName())) continue;
                target_uri_options.add(rss_option);
                continue;
            }
            throw new RssException(DlsI18NCode.MSG_DS_INVALID_OPTIONS, new Object[0]);
        }
        if (target_uri_options.size() != 1 || create_delete_options.size() != 1) {
            throw new RssException(DlsI18NCode.MSG_DS_INVALID_OPTIONS, new Object[0]);
        }
        return new I18NMessage[0];
    }

    @Override
    public void runTimeValidate(Option[] options) throws LocalizableException {
        Option[] rssOptions = OptionUtils.findOptionsByType((Option[])options, RssOption.class);
        for (int counter = 0; counter < rssOptions.length; ++counter) {
            RssOption oneRssOption = (RssOption)rssOptions[counter];
            this.validateOption(oneRssOption);
        }
    }

    private void validateOption(RssOption rss_option) throws RssException {
        OptionDefinition def = (OptionDefinition)m_option_definitions.get(rss_option.getName());
        if (def == null) {
            throw new RssException(DlsI18NCode.MSG_DS_INVALID_OPTIONS, new Object[0]);
        }
        def.checkOption(rss_option);
    }

    static {
        m_option_definitions.put(NAME.option_name, NAME);
        m_option_definitions.put(CREATE.option_name, CREATE);
        m_option_definitions.put(DELETE.option_name, DELETE);
        m_option_definitions.put(DESCRIPTION.option_name, DESCRIPTION);
        m_option_definitions.put(SCREEN_TIP.option_name, SCREEN_TIP);
        m_option_definitions.put(TARGET.option_name, TARGET);
        m_option_definitions.put(URI.option_name, URI);
    }

    private static class OptionDefinition {
        private RssOptionEnum option_name;
        private Set option_classes = new HashSet();

        public OptionDefinition(RssOptionEnum name, Class[] classes) {
            this.option_name = name;
            for (int i = 0; i < classes.length; ++i) {
                this.option_classes.add(classes[i]);
            }
        }

        public void checkOption(RssOption option) throws RssException {
            if (!this.option_classes.contains(option.getClass())) {
                throw new RssException(DlsI18NCode.MSG_DS_INVALID_RSS_OPTION_ENUM, new Object[]{this.option_name.getValue(), this.option_classes.toString()});
            }
        }

        public RssOptionEnum getOptionName() {
            return this.option_name;
        }
    }
}

