/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.service;

import com.cognos.dls.service.DLSConfigurationListener;
import com.cognos.dls.smtp.WhiteListAddressChecker;
import com.cognos.dls.smtp.rest.CogConfigRestCache;
import com.cognos.jsmcommon.soap.service.IServiceConfiguration;
import com.cognos.pogo.pdk.Configuration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DLSConfiguration
implements IServiceConfiguration {
    private static final String wsddfile = "/com/cognos/dls/service/dlsdeploy.wsdd";
    private static final String wsddClientFile = "/com/cognos/dls/service/dlsClientDeploy.wsdd";
    private static final String serviceName = "deliveryService";
    private static Map properties;
    private static final DLSConfiguration m_instance;
    private Set listeners = new HashSet();

    private DLSConfiguration() {
        properties = new HashMap();
        properties.put("wsdd.file", wsddfile);
        properties.put("wsdd.client.file", wsddClientFile);
        properties.put("service.name", serviceName);
    }

    public static DLSConfiguration getInstance() {
        return m_instance;
    }

    public Object getProperty(Object key) {
        return properties.get(key);
    }

    public void setProperty(Object key, Object value) {
        properties.put(key, value);
    }

    synchronized void configuration(Configuration configuration) {
        for (DLSConfigurationListener listener : this.listeners) {
            listener.configure(configuration);
        }
        CogConfigRestCache.reset(true);
        WhiteListAddressChecker.reset(true);
    }

    public synchronized void addListener(DLSConfigurationListener listener) {
        this.listeners.add(listener);
    }

    static {
        m_instance = new DLSConfiguration();
    }
}

