/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.service;

import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.service.DLSAsyncService;
import com.cognos.dls.service.DLSConfiguration;
import com.cognos.dls.smtp.queue.SMTPQueueConsumerManager;
import com.cognos.dls.smtp.smtpRules.SmtpActionsManager;
import com.cognos.dls.util.AttachmentsProcessorFactory;
import com.cognos.dls.util.CMAttachmentsProcessor;
import com.cognos.dls.util.CMEmailRetriever;
import com.cognos.dls.util.CMLinksProcessor;
import com.cognos.dls.util.EmailLimits;
import com.cognos.dls.util.EmailRetrieverFactory;
import com.cognos.dls.util.IAttachmentsProcessor;
import com.cognos.dls.util.IEmailRetriever;
import com.cognos.dls.util.ILinksProcessor;
import com.cognos.dls.util.LinksProcessorFactory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.jms.provider.metrics.JmsQueueMetrics;
import com.cognos.jsmcommon.jms.resource.JMSProperties;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.ResourceLockManager;
import com.cognos.jsmcommon.lock.database.SdsInstanceAwareResourceLockManager;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.service.ServiceProperties;
import com.cognos.jsmcommon.service.ServicePropertiesException;
import com.cognos.jsmcommon.soap.service.AxisServiceHandler;
import com.cognos.jsmcommon.soap.service.IServiceConfiguration;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.Asyncable;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidator;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidatorAtIntervals;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Locale;
import org.dom4j.Element;

public class DLSHandler
extends BasicHandler
implements Asyncable {
    private static final String DELIVERY_SERVICE = "delivery-service";
    private PogoEngine engine = null;
    private boolean m_suspended = false;
    private ResourceLockManager resourceLockManager;
    private RESTClientFactory m_restFactory;

    public DLSHandler() {
        super(null);
    }

    public AsyncService getAsyncRequest(MessageContext context) {
        String method;
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)context.getProperty("request.envelope");
        Element body = requestEnvelope.getBody();
        Iterator children = body.elementIterator();
        if (children.hasNext() && (method = ((Element)children.next()).getName()) != null && (method.equals("queryNotification") || method.equals("clearNotifications") || method.equals("addNotification") || method.equals("deleteNotification") || method.equals("getNotificationList") || method.equals("validate") || method.equals("validateSpecification") || method.equals("setTestProperties"))) {
            return null;
        }
        return new DLSAsyncService(this, context);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.engine = engine;
        if (null == engine.getServiceMap().get("batchReportService")) {
            EmailLimits.isBatchReportServiceEnabled(false);
        }
        ServiceProperties dlsServiceProperties = null;
        try {
            dlsServiceProperties = new ServiceProperties(this.getConfig());
        }
        catch (ServicePropertiesException e) {
            throw new PogoException("Handler config problem: " + e.getLocalizedMessage());
        }
        String emailRetrieverClass = dlsServiceProperties.getProperty("IEmailRetriever.impl");
        if (emailRetrieverClass != null) {
            try {
                Class<?> retrieverClass = Class.forName(emailRetrieverClass);
                Constructor<?> constructor = retrieverClass.getConstructor(new Class[0]);
                IEmailRetriever retriever = (IEmailRetriever)retrieverClass.newInstance();
                EmailRetrieverFactory.setEmailRetriever(retriever);
            }
            catch (Exception e) {
                throw new PogoException("Handler config problem: " + e.getLocalizedMessage());
            }
        } else {
            EmailRetrieverFactory.setEmailRetriever(new CMEmailRetriever());
        }
        String linksProcessorStr = dlsServiceProperties.getProperty("ILinksProcessor.impl");
        if (linksProcessorStr != null) {
            try {
                Class<?> linksProcessorClass = Class.forName(linksProcessorStr);
                Constructor<?> constructor = linksProcessorClass.getConstructor(new Class[0]);
                ILinksProcessor linksProcessor = (ILinksProcessor)linksProcessorClass.newInstance();
                LinksProcessorFactory.setLinksProcessor(linksProcessor);
            }
            catch (Exception e) {
                throw new PogoException("Handler config problem: " + e.getLocalizedMessage());
            }
        } else {
            LinksProcessorFactory.setLinksProcessor(new CMLinksProcessor());
        }
        String attachmentsProcessorStr = dlsServiceProperties.getProperty("IAttachmentsProcessor.impl");
        if (attachmentsProcessorStr != null) {
            try {
                Class<?> attachmentsProcessorClass = Class.forName(attachmentsProcessorStr);
                Constructor<?> constructor = attachmentsProcessorClass.getConstructor(new Class[0]);
                IAttachmentsProcessor attachmentsProcessor = (IAttachmentsProcessor)attachmentsProcessorClass.newInstance();
                AttachmentsProcessorFactory.setAttachmentsProcessor(attachmentsProcessor);
            }
            catch (Exception e) {
                throw new PogoException("Handler config problem: " + e.getLocalizedMessage());
            }
        } else {
            AttachmentsProcessorFactory.setAttachmentsProcessor(new CMAttachmentsProcessor());
        }
    }

    public void configure(Configuration configuration) {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)DLSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        CRNProperties cclConfig = CRNProperties.getInstance();
        cclConfig.init(configuration.getICCLConfiguration(), this.getName());
        CMProperties cmConfig = CMProperties.getInstance();
        cmConfig.init(configuration.getICCLConfiguration());
        DLSConfiguration.getInstance().configuration(configuration);
        try {
            JMSProperties.getInstance().loadProperties();
            JmsQueueMetrics.configure((String)JMSProperties.getInstance().getProperty(JMSProperties.EMAIL_QUEUE_NAME));
            SmtpActionsManager.resetInstance();
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
        }
        perf.stop();
    }

    public void dispose() {
        super.dispose();
    }

    public void initialize() {
        super.initialize();
        try {
            this.resourceLockManager = new SdsInstanceAwareResourceLockManager();
        }
        catch (Exception x) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug((Throwable)x);
        }
    }

    public void allServicesStarted() {
        try {
            SMTPQueueConsumerManager.getInstance().start();
        }
        catch (JMSException e) {
            String errMsg = I18NUtil.getMessage((I18NCode)I18NCode.ERROR_STARTING_JMS_SERVICE, (Locale)SDSLogger.getLocale());
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).startService("DeliveryService", "Failure", errMsg);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, (Object[])new String[]{e.getLocalizedMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)DLSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        try {
            if (this.isSuspended()) {
                mc.setFault(new Fault("AbortIfSuspendedHandler.serviceStopped"));
                return;
            }
            BIBusEnvelope biBusEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
            ThreadProperties.setProperty((String)"componentID", (String)"DLS");
            String requestOp = BiBusUtilities.getOperation((BIBusEnvelope)biBusEnv);
            if (requestOp != null) {
                ThreadProperties.setProperty((String)"requestOperation", (String)requestOp);
            }
            ThreadProperties.setObject((String)"resource.lock.manager", (Object)this.resourceLockManager);
            AxisServiceHandler handler = AxisServiceHandler.getHandler((IServiceConfiguration)DLSConfiguration.getInstance(), (MessageContext)mc);
            handler.setAsAsync(true);
            handler.prepare();
            handler.execute();
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    public void reconfigure(Configuration configuration) {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)DLSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        this.configure(configuration);
        perf.stop();
    }

    private void startResourceLockManager() {
        try {
            this.resourceLockManager.start();
        }
        catch (ResourceLockException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLS: Error in resume/starting resource locker");
        }
    }

    private void stopResourceLockManager() {
        try {
            this.resourceLockManager.stop();
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLS: Error in suspend/stopping resource locker");
        }
    }

    public void resume() {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)DLSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        try {
            SMTPQueueConsumerManager.getInstance().start();
            this.startResourceLockManager();
            this.setSuspended(false);
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).startService("DeliveryService", "Success");
        }
        catch (JMSException e) {
            String errMsg = I18NUtil.getMessage((I18NCode)I18NCode.ERROR_STARTING_JMS_SERVICE, (Locale)SDSLogger.getLocale());
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).startService("DeliveryService", "Failure", errMsg);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, (Object[])new String[]{e.getLocalizedMessage()});
            this.flagNotStartable();
            throw new RuntimeException("Delivery Service failed to resume");
        }
        catch (Exception e) {
            String errMsg = I18NUtil.getMessage((I18NCode)I18NCode.ERROR_STARTING_JMS_SERVICE, (Locale)SDSLogger.getLocale());
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).startService("DeliveryService", "Failure", errMsg);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, (Object[])new String[]{e.getLocalizedMessage()});
            this.flagNotStartable();
            throw new RuntimeException("Delivery Service failed to resume");
        }
        finally {
            perf.stop();
        }
    }

    public void start() {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)DLSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        try {
            SMTPQueueConsumerManager.getInstance().start();
            this.startResourceLockManager();
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).startService("DeliveryService", "Success");
            DBSchemaValidatorAtIntervals.getInstance().startDBSchemaValidationAtIntervals(DBSchemaValidator.ComponentName.NC);
            this.initializeRESTClient();
            this.setSuspended(false);
        }
        catch (JMSException e) {
            String errMsg = I18NUtil.getMessage((I18NCode)I18NCode.ERROR_STARTING_JMS_SERVICE, (Locale)SDSLogger.getLocale());
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).startService("DeliveryService", "Failure", errMsg);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, (Object[])new String[]{e.getLocalizedMessage()});
            this.flagNotStartable();
            throw new RuntimeException("Delivery Service Failed to start");
        }
        catch (Exception ex) {
            String errMsg = I18NUtil.getMessage((I18NCode)I18NCode.ERROR_STARTING_JMS_SERVICE, (Locale)SDSLogger.getLocale());
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).startService("DeliveryService", "Failure", errMsg);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, (Object[])new String[]{ex.getLocalizedMessage()});
            this.flagNotStartable();
            throw new RuntimeException("Delivery Service Failed to start");
        }
        finally {
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)DLSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        try {
            this.shutdownRestClient();
            SMTPQueueConsumerManager.getInstance().stop();
            this.stopResourceLockManager();
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).stopService("DeliveryService", "Success");
            this.setSuspended(true);
        }
        catch (JMSException e) {
            String errMsg = I18NUtil.getMessage((I18NCode)I18NCode.ERROR_STOPPING_JMS_SERVICE, (Locale)SDSLogger.getLocale());
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).stopService("DeliveryService", "Failure", errMsg);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, (Object[])new String[]{e.getLocalizedMessage()});
        }
        finally {
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(boolean immediate) {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)DLSCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        try {
            SMTPQueueConsumerManager.getInstance().stop();
            this.stopResourceLockManager();
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).stopService("DeliveryService", "Success");
            this.setSuspended(true);
        }
        catch (JMSException e) {
            String errMsg = I18NUtil.getMessage((I18NCode)I18NCode.ERROR_STOPPING_JMS_SERVICE, (Locale)SDSLogger.getLocale());
            SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).stopService("DeliveryService", "Failure", errMsg);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, (Object[])new String[]{e.getLocalizedMessage()});
        }
        finally {
            perf.stop();
        }
    }

    private void initializeRESTClient() {
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("DLSHandler initializing RESTClient factory");
        try {
            this.m_restFactory = RESTClientFactory.getInstance();
            this.m_restFactory.startup(DELIVERY_SERVICE);
        }
        catch (Throwable ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).error("CPNSPushServiceCaller: " + ex.getMessage());
        }
    }

    private void shutdownRestClient() {
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("DLSHandler shutting down RESTClient factory");
        try {
            this.m_restFactory.shutdown();
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).error("DLSHandler exception when shutting down the rest client: " + e.getMessage());
        }
        SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLSHandler finished shutting down RESTClient factory");
    }

    private void setSuspended(boolean suspended) {
        this.m_suspended = suspended;
    }

    private boolean isSuspended() {
        return this.m_suspended;
    }
}

