/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.caf.CAFLibrary;
import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.AncestorInfoArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.MimeMessageBuilderException;
import com.cognos.dls.smtp.MimeTextEncoder;
import com.cognos.dls.smtp.ProcessedLinks;
import com.cognos.dls.smtp.QueryRepliesHandler;
import com.cognos.dls.util.CMStoreIDWrapper;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.datasource.DataSourceFactory;
import com.cognos.jsmcommon.util.datasource.NCDataSource;
import com.cognos.pogo.util.URLEncoderDecoder;
import java.io.IOException;
import java.util.Locale;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimePart;

public abstract class AbstractMemoObjectbuilder {
    protected EmailOptionsDeliverable m_eod;
    protected String m_emailEncoding;
    private MimeTextEncoder m_mimeTextEncoder;
    protected final String m_prefix = "<A href=\"";
    protected final String m_flags = "?b_action=cognosViewer&ui.action=view&ui.object=";
    protected final String m_downloadflags = "?b_action=xts.run&m=portal/download.xts&format=application%2fvnd.coc-xl&m_download_obj=";
    protected String m_postfix = "&nh=1&tb=0";
    protected final String m_downloadpostfix = "/documentVersion[last()]/documentContent[last()]";
    protected String m_gateway;
    protected final String SUPPORTED_VIEWER_FORMATS = "CSV HTML HTMLFragment MHT PDF singleXLS spreadsheetML XHTML XLS XLWA XML xlsxData";
    private final String CAM_NAMESPACE_EMAIL_LINK = "true";
    protected static final String NEW_VIEWER_OURPUT_PREFIX = "?objRef=";
    protected static final String NEW_VIEWER_REPORT_PREFIX = "&reportId=";

    public AbstractMemoObjectbuilder(String emailEncoding, EmailOptionsDeliverable eod, MimeTextEncoder mimeTextEncoder) throws MimeMessageBuilderException {
        this.m_emailEncoding = emailEncoding;
        this.m_eod = eod;
        this.m_mimeTextEncoder = mimeTextEncoder;
        try {
            String nameSpace;
            this.m_gateway = CRNProperties.getInstance().getProperty("gateway");
            String addNameSpace = CRNProperties.getInstance().getProperty("CAMNamespaceOnEmailLink");
            if ("true".equalsIgnoreCase(addNameSpace) && null != (nameSpace = eod.getNameSpaceId()) && nameSpace.length() > 0) {
                this.m_postfix = this.m_postfix + "&CAMNamespace=" + nameSpace;
            }
        }
        catch (PropertiesException e) {
            throw new MimeMessageBuilderException(DlsI18NCode.MSG_DS_NO_GATEWAY_URI_AVAILABLE, e);
        }
    }

    public abstract ProcessedLinks buildLink(ObjectLink var1) throws MimeMessageBuilderException;

    public abstract MimePart buildAttachment(MimePart var1, MemoPartObject var2, QueryRepliesHandler var3) throws MimeMessageBuilderException;

    protected abstract QueryRequest[] createObjectQueryRequests(String var1);

    protected String encodeURLText(String text) {
        if (text == null) {
            return null;
        }
        String encodedText = null;
        try {
            encodedText = URLEncoderDecoder.encode((String)text, (String)this.m_emailEncoding);
            encodedText = CAFLibrary.tpXSSEncode((String)encodedText);
        }
        catch (Exception xex) {
            encodedText = text;
        }
        return encodedText;
    }

    protected QueryReply[] getBaseObjects(SearchPathSingleObject spso) throws MimeMessageBuilderException {
        String searchPath = spso.get_value();
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(this.m_eod.getHeader()));
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setDataEncoding(EncodingEnum.base64);
        QueryReply[] replies = null;
        try {
            replies = cmPort.queryMultiple(this.createObjectQueryRequests(searchPath));
        }
        catch (SDKClientException e) {
            throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
        }
        catch (EMFSecurityException e) {
            throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return replies;
    }

    protected ProcessedLinks createErrorLinks(ObjectLink link) {
        ProcessedLinks processedLink = new ProcessedLinks();
        String strMsg = link.getLabel();
        if (null == strMsg || strMsg.length() <= 0) {
            strMsg = link.getSearchPath().get_value();
        }
        String msg = I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_DEFAULT_OUTPUT_NOT_AVALABLE, (Object)strMsg, (Locale)this.m_eod.getLocale());
        processedLink.appendHtmlUrl(msg);
        processedLink.appendTextUrl(msg);
        return processedLink;
    }

    protected MimePart createErrorOutput(MimePart bp, QueryRepliesHandler replies, String fileName) throws MessagingException, IOException {
        int lastDot;
        TokenProp nameProp;
        SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_OUTPUT_NOT_AVALABLE);
        String name = fileName;
        BaseClass base = replies.getBase();
        TokenProp tokenProp = nameProp = base != null ? base.getDefaultName() : null;
        if (null != nameProp && null != nameProp.getValue() && nameProp.getValue().length() > 0) {
            name = nameProp.getValue();
        }
        if (null == fileName || fileName.length() <= 0) {
            String string = fileName = name == null ? "?" : name;
        }
        if ((lastDot = fileName.lastIndexOf(".")) != -1) {
            fileName = fileName.substring(0, lastDot);
        }
        fileName = fileName + ".html";
        String msg = I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_OUTPUT_NOT_AVALABLE, (Object)name, (Locale)this.m_eod.getLocale());
        String htmlMsg = "<html><body>" + msg + "</body></html>";
        byte[] bytes = htmlMsg.getBytes();
        String dataType = "text/html";
        bp = this.processBytes(bp, bytes, dataType, fileName);
        return bp;
    }

    protected MimePart processData(MimePart bp, Output output, String filename) throws IOException, MessagingException {
        byte[] bytes = output.getData().getValue();
        String dataType = output.getDataType().getValue();
        bp = this.processBytes(bp, bytes, dataType, filename);
        bytes = null;
        output.setData(null);
        return bp;
    }

    protected MimePart processBytes(MimePart bp, byte[] bytes, String dataType, String filename) throws IOException, MessagingException {
        NCDataSource data = DataSourceFactory.getPreZippedDataSource((byte[])bytes, (String)dataType, (String)filename);
        DataHandler dh = new DataHandler((DataSource)data);
        if (filename != null && !filename.equals("")) {
            filename = this.m_mimeTextEncoder.encodeMimeText(filename);
            bp.setFileName(filename);
        }
        bp.setDataHandler(dh);
        return bp;
    }

    protected boolean isPowerPlayReport(SearchPathSingleObject searchPathObj) throws MimeMessageBuilderException {
        QueryReply[] replies;
        boolean isPowerPlayReport = false;
        block0: for (QueryReply reply : replies = this.getBaseObjects(searchPathObj)) {
            AncestorInfo[] ancestorInfoArray;
            BaseClass[] baseObjects = reply.getQueryResult();
            if (null == baseObjects || baseObjects.length <= 0) continue;
            BaseClass baseObj = baseObjects[0];
            AncestorInfoArrayProp ancestorInfoArrayProp = baseObj.getAncestors();
            for (AncestorInfo ancestorInfo : ancestorInfoArray = ancestorInfoArrayProp.getValue()) {
                if (!ancestorInfo.getObjectClass().getValue().toLowerCase().contains("powerplay")) continue;
                isPowerPlayReport = true;
                continue block0;
            }
        }
        return isPowerPlayReport;
    }

    protected String getOutputStoreID(SearchPathSingleObject searchPathObj) throws MimeMessageBuilderException {
        String outputStoreID = "";
        String storeID = "";
        if (null != searchPathObj && null != searchPathObj.get_value()) {
            outputStoreID = searchPathObj.get_value().startsWith("storeID(") ? new CMStoreIDWrapper(searchPathObj.get_value()).getStoreId() : ((storeID = this.geObjectOutputStoreID(searchPathObj)) != null && !storeID.trim().equals("") ? storeID : searchPathObj.get_value());
        }
        return outputStoreID;
    }

    protected String getReportStoreID(SearchPathSingleObject searchPathObj) throws MimeMessageBuilderException {
        QueryReply[] replies;
        String reportStoreID = "";
        block0: for (QueryReply reply : replies = this.getBaseObjects(searchPathObj)) {
            AncestorInfo[] ancestorInfoArray;
            BaseClass[] baseObjects = reply.getQueryResult();
            if (null == baseObjects || baseObjects.length <= 0) continue;
            BaseClass baseObj = baseObjects[0];
            AncestorInfoArrayProp ancestorInfoArrayProp = baseObj.getAncestors();
            for (AncestorInfo ancestorInfo : ancestorInfoArray = ancestorInfoArrayProp.getValue()) {
                if (!ancestorInfo.getObjectClass().getValue().equals("reportView") && !ancestorInfo.getObjectClass().getValue().equals("report")) continue;
                reportStoreID = ancestorInfo.getStoreID().toString();
                continue block0;
            }
        }
        return reportStoreID;
    }

    private String geObjectOutputStoreID(SearchPathSingleObject searchPathObj) throws MimeMessageBuilderException {
        QueryReply[] replies;
        String objectOutputStoreID = "";
        block0: for (QueryReply reply : replies = this.getBaseObjects(searchPathObj)) {
            BaseClass[] baseObjects = reply.getQueryResult();
            if (null == baseObjects || baseObjects.length <= 0) continue;
            for (BaseClass baseClass : baseObjects) {
                if (baseClass == null || baseClass.getObjectClass() == null || baseClass.getObjectClass().getValue() == null || !baseClass.getObjectClass().getValue().toString().equalsIgnoreCase("output")) continue;
                if (baseClass.getStoreID() == null || baseClass.getStoreID().getValue() == null) break block0;
                objectOutputStoreID = baseClass.getStoreID().getValue().toString();
                break block0;
            }
        }
        return objectOutputStoreID;
    }
}

