/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.AbstractMemoObjectbuilder;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.LabelGenerator;
import com.cognos.dls.smtp.MimeMessageBuilderException;
import com.cognos.dls.smtp.MimeTextEncoder;
import com.cognos.dls.smtp.ProcessedLinks;
import com.cognos.dls.smtp.QueryRepliesHandler;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.io.IOException;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.internet.MimePart;

public class AgentMemoObjectbuilder
extends AbstractMemoObjectbuilder {
    public AgentMemoObjectbuilder(String emailEncoding, EmailOptionsDeliverable eod, MimeTextEncoder mimeTextEncoder) throws MimeMessageBuilderException {
        super(emailEncoding, eod, mimeTextEncoder);
    }

    @Override
    public ProcessedLinks buildLink(ObjectLink link) throws MimeMessageBuilderException {
        String label = link.getLabel();
        SearchPathSingleObject searchPath = link.getSearchPath();
        SearchPathSingleObject newPath = ObjectModelUtil.changeAgentpathsToAgentOutputPaths((SearchPathSingleObject)searchPath, (String)"HTML");
        String urlID = this.getBuiltSearchPath(newPath);
        if (null == label || label.length() <= 0) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_LABEL_NOT_AVAILABLE_GENERATING_ONE);
            label = this.buildLinkLabel(searchPath);
        }
        ProcessedLinks processedLink = new ProcessedLinks();
        if (urlID.length() > 0) {
            processedLink.appendHtmlUrl("<A href=\"" + this.m_gateway);
            processedLink.appendHtmlUrl("?b_action=cognosViewer&ui.action=view&ui.object=");
            processedLink.appendHtmlUrl(urlID);
            processedLink.appendHtmlUrl(this.m_postfix);
            processedLink.appendHtmlUrl("\">");
            processedLink.appendHtmlUrl(label);
            processedLink.appendHtmlUrl("</A>");
            processedLink.appendHtmlUrl("<br>");
            processedLink.appendTextUrl(label);
            processedLink.appendTextUrl("\n<");
            processedLink.appendTextUrl(this.m_gateway);
            processedLink.appendTextUrl("?b_action=cognosViewer&ui.action=view&ui.object=");
            processedLink.appendTextUrl(urlID);
            processedLink.appendTextUrl(this.m_postfix);
            processedLink.appendTextUrl(">");
            processedLink.appendTextUrl("\n");
        } else {
            String strMsg = label;
            if (null == label || label.length() <= 0) {
                strMsg = searchPath.get_value();
            }
            String msg = I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_EVENT_OUTPUT_NOT_AVALABLE, (Object)strMsg, (Locale)this.m_eod.getLocale());
            processedLink.appendHtmlUrl(msg);
            processedLink.appendTextUrl(msg);
        }
        return processedLink;
    }

    @Override
    public MimePart buildAttachment(MimePart bp, MemoPartObject mpo, QueryRepliesHandler replies) throws MimeMessageBuilderException {
        try {
            Output output = (Output)replies.getEventOutput();
            String filename = mpo.getName();
            if (null != output) {
                if (filename == null || filename.equals("")) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_LABEL_NOT_AVAILABLE_GENERATING_ONE);
                    LabelGenerator generator = new LabelGenerator(this.m_eod);
                    generator.generateAgentLabel((BaseAgentDefinition)replies.getBase(), output);
                    filename = generator.getAttachmentLabel();
                }
                bp = this.processData(bp, output, filename);
            } else {
                bp = this.createErrorOutput(bp, replies, filename);
            }
        }
        catch (IOException e) {
            throw new MimeMessageBuilderException(DlsI18NCode.MSG_DS_OUTPUT_NOT_AVALABLE, e);
        }
        catch (MessagingException e) {
            throw new MimeMessageBuilderException(DlsI18NCode.MSG_DS_OUTPUT_NOT_AVALABLE, e);
        }
        return bp;
    }

    private String buildLinkLabel(SearchPathSingleObject searchPath) {
        String label;
        block2: {
            label = "";
            try {
                QueryReply[] repliesArray = this.getBaseObjects(searchPath);
                QueryRepliesHandler replies = new QueryRepliesHandler(repliesArray);
                LabelGenerator generator = new LabelGenerator(this.m_eod);
                generator.generateAgentLabel((BaseAgentDefinition)replies.getBase(), (Output)replies.getOutput());
                label = generator.getLinkLabel();
            }
            catch (MimeMessageBuilderException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.INFO, DlsI18NCode.MSG_DS_GENERATING_LABEL_ERROR_WILL_CONTINUE);
                if (!SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).isLoggingAt(SDSLevel.DEBUG)) break block2;
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)((Object)e));
            }
        }
        return label;
    }

    @Override
    protected QueryRequest[] createObjectQueryRequests(String searchPath) {
        PropEnum[] agentProp = new PropEnum[]{PropEnum.defaultName, PropEnum.storeID, PropEnum.objectClass};
        QueryRequest baseRequest = new QueryRequest();
        baseRequest.setSearch(searchPath);
        baseRequest.setProperties(agentProp);
        PropEnum[] agentOutputProp = new PropEnum[]{PropEnum.defaultName, PropEnum.format, PropEnum.locale, PropEnum.searchPath, PropEnum.storeID, PropEnum.objectClass};
        QueryRequest outputRequest = new QueryRequest();
        outputRequest.setSearch(ObjectModelUtil.changeAgentpathsToAgentOutputPaths((String)searchPath, (String)"HTML"));
        outputRequest.setProperties(agentOutputProp);
        return new QueryRequest[]{baseRequest, outputRequest};
    }

    protected String getBuiltSearchPath(SearchPathSingleObject searchPath) {
        String searchPathString = "";
        if (null != searchPath && null != searchPath.get_value()) {
            searchPathString = searchPath.get_value();
        }
        return this.encodeURLText(searchPathString);
    }
}

