/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.AddressSMTP;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionAddressSMTPArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionSearchPathMultipleObjectArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionString;
import com.cognos.developer.schemas.bibus._3.DocumentContent;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartAgentObject;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.MemoPartObjectLinks;
import com.cognos.developer.schemas.bibus._3.MemoPartString;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.SmtpContentDispositionEnum;
import com.cognos.developer.schemas.bibus._3.SmtpContentTypeEnum;
import com.cognos.developer.schemas.bibus._3.StringArrayProp;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.DeliveryOptionsBuilderException;
import com.cognos.dls.NotificationList;
import com.cognos.dls.api.DeliveryServiceHandler;
import com.cognos.dls.api.DeliveryServiceHandlerException;
import com.cognos.dls.smtp.Cache;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.MimeMessageBuilderException;
import com.cognos.dls.smtp.MimeTextEncoder;
import com.cognos.dls.smtp.ProcessedLinks;
import com.cognos.dls.smtp.QueryRepliesHandler;
import com.cognos.dls.util.AttachmentsProcessorFactory;
import com.cognos.dls.util.CMEmailRetriever;
import com.cognos.dls.util.EmailRetrieverFactory;
import com.cognos.dls.util.IAttachmentsProcessor;
import com.cognos.dls.util.IEmailRetriever;
import com.cognos.dls.util.ILinksProcessor;
import com.cognos.dls.util.LinksProcessorFactory;
import com.cognos.dls.util.attachmentcheck.strategy.AttachmentCheckStrategy;
import com.cognos.dls.util.attachmentcheck.strategy.AttachmentCheckStrategyFactory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Message;

public class CMObjectPreprocessor {
    private EmailOptionsDeliverable m_eod;
    private String m_emailEncoding;
    private MimeTextEncoder m_MimeTextEncoder;
    private String subject;
    private List m_toAddresses = null;
    private List m_ccAddresses = null;
    private List m_bccAddresses = null;
    private AttachmentCheckStrategy attachmentCheckStrategy;
    private static Cache m_outputCache = new Cache();

    CMObjectPreprocessor(EmailOptionsDeliverable eod, String emailEncoding) {
        this.m_eod = eod;
        this.m_emailEncoding = emailEncoding;
        this.m_MimeTextEncoder = new MimeTextEncoder(emailEncoding);
    }

    public void retrieve(Option[] options, BiBusHeader header) throws DeliveryOptionsBuilderException {
        DeliveryOption notificationListOption;
        DeliveryOption bccOption;
        DeliveryOption ccOption;
        DeliveryOption toOption;
        DeliveryOption charSetEncodingOption = (DeliveryOption)OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.characterSetEncoding);
        if (charSetEncodingOption != null) {
            this.m_MimeTextEncoder.setEncodingOption(charSetEncodingOption);
        }
        if ((toOption = (DeliveryOption)OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.to)) != null) {
            this.setAddresses(header, Message.RecipientType.TO, toOption);
        }
        if ((ccOption = (DeliveryOption)OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.cc)) != null) {
            this.setAddresses(header, Message.RecipientType.CC, ccOption);
        }
        if ((bccOption = (DeliveryOption)OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.bcc)) != null) {
            this.setAddresses(header, Message.RecipientType.BCC, bccOption);
        }
        DeliveryOption toAddressOption = (DeliveryOption)OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.toAddress);
        DeliveryOption ccAddressOption = (DeliveryOption)OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.ccAddress);
        DeliveryOption bccAddressOption = (DeliveryOption)OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.bccAddress);
        this.m_toAddresses = this.mergeRecipients(toOption, toAddressOption);
        this.m_ccAddresses = this.mergeRecipients(ccOption, ccAddressOption);
        this.m_bccAddresses = this.mergeRecipients(bccOption, bccAddressOption);
        DeliveryOptionString subjectOption = (DeliveryOptionString)OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.subject);
        this.subject = subjectOption == null ? null : subjectOption.getValue();
        DeliveryOption memoPartOption = (DeliveryOption)OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.memoPart);
        if (memoPartOption != null) {
            this.setMessageParts(header, memoPartOption);
        }
        if ((notificationListOption = (DeliveryOption)OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)DeliveryOptionEnum.notificationList)) != null) {
            this.setNotificationListAddresses(header, notificationListOption);
        }
    }

    private AttachmentCheckStrategy getAttachmentCheckStrategy() {
        if (this.attachmentCheckStrategy == null) {
            this.attachmentCheckStrategy = AttachmentCheckStrategyFactory.getStrategy(this.m_eod);
        }
        return this.attachmentCheckStrategy;
    }

    private void setAddresses(BiBusHeader header, Message.RecipientType type, DeliveryOption option) throws DeliveryOptionsBuilderException {
        if (!(option instanceof DeliveryOptionSearchPathMultipleObjectArray)) {
            this.throwIncorrectOptionTypeError(DeliveryOptionSearchPathMultipleObjectArray.class, option);
        }
        DeliveryOptionSearchPathMultipleObjectArray addressOptions = (DeliveryOptionSearchPathMultipleObjectArray)option;
        try {
            HashMap addressMap;
            List addrList;
            SearchPathMultipleObject[] addrSearchPaths = addressOptions.getValue();
            IEmailRetriever emailRetriever = EmailRetrieverFactory.getInstance();
            if (emailRetriever == null) {
                emailRetriever = new CMEmailRetriever();
                EmailRetrieverFactory.setEmailRetriever(emailRetriever);
            }
            if ((addrList = (List)(addressMap = emailRetriever.getAddresses(header, this.m_eod.getObjectPath(), addrSearchPaths)).get("emailaddresslist")).size() > 0) {
                this.m_eod.addAddresses(type, addrList);
            } else {
                String msg = "DeliveryService: A DeliveryOptionSearchPathMultipleObjectArray has no resolved email addresses. SearchPaths: ";
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(msg + addrSearchPaths);
            }
        }
        catch (EMFSecurityException e) {
            throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR, e);
        }
        catch (SDKClientException e) {
            throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR, (LocalizableException)((Object)e));
        }
    }

    private String throwIncorrectOptionTypeError(Class expected, Object actual) throws DeliveryOptionsBuilderException {
        String expectedClass = expected.getName();
        String actualClass = actual == null ? "null" : actual.getClass().getName();
        String msg = " Expected type was [" + expectedClass + "] but actual type was [" + actualClass + "]";
        throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR, new IllegalStateException(msg));
    }

    private void setMessageParts(BiBusHeader header, DeliveryOption option) throws DeliveryOptionsBuilderException {
        boolean weHaveLinks;
        if (!(option instanceof DeliveryOptionMemoPart)) {
            this.throwIncorrectOptionTypeError(DeliveryOptionMemoPart.class, option);
        }
        DeliveryOptionMemoPart memoPartOption = (DeliveryOptionMemoPart)option;
        MemoPart memoPart = memoPartOption.getValue();
        this.retrieveMemoPartsPreProcess(memoPart, header, false);
        HashMap<SearchPathSingleObject, BaseClass> attachmentsMap = new HashMap<SearchPathSingleObject, BaseClass>();
        Map<SearchPathSingleObject, QueryRepliesHandler> queryReplies = this.m_eod.getMemoPartObjectAttachments();
        Set<SearchPathSingleObject> keys = queryReplies.keySet();
        for (SearchPathSingleObject key : keys) {
            QueryRepliesHandler replyHandler = queryReplies.get(key);
            BaseClass bc = this.getAttachmentContent(replyHandler);
            if (bc == null) continue;
            attachmentsMap.put(key, bc);
        }
        MemoPartObject attachmentPart = this.getFirstMHTAttachment(memoPart, attachmentsMap, this.m_eod.getIsMemoPartStringEmpty());
        AttachmentCheckStrategy attachmentStrategy = this.getAttachmentCheckStrategy();
        attachmentStrategy.checkAllAttachments(memoPart, attachmentPart, attachmentsMap, this.m_eod.getMemoPartMIMEAttachments());
        if (attachmentPart != null && attachmentPart.getContentDisposition().equals((Object)SmtpContentDispositionEnum.inline)) {
            boolean inlineMHT = true;
            try {
                MemoPartComposite mhtMemoPart;
                SearchPathSingleObject searchPath = attachmentPart.getSearchPath();
                QueryRepliesHandler replies = this.m_eod.getMemoPartObjectAttachments(searchPath);
                if (inlineMHT && (mhtMemoPart = AttachmentsProcessorFactory.getInstance().unPackMHT(replies)) != null) {
                    this.m_eod.setInlineMemoPartObject(searchPath, (MemoPart)mhtMemoPart);
                }
            }
            catch (MimeMessageBuilderException e) {
                throw new DeliveryOptionsBuilderException(e.getI18NCode(), e.getParams(), e);
            }
        }
        boolean bl = weHaveLinks = this.m_eod.getHtmlURL().length() > 0 || this.m_eod.getTextURL().length() > 0;
        if (!weHaveLinks && this.m_eod.getIsMemoPartStringEmpty()) {
            memoPart = this.rebuildMemoParts(memoPart);
        }
        memoPartOption.setValue(memoPart);
    }

    private MemoPartObject getFirstMHTAttachment(MemoPart memoPart, Map attachmentReplies, boolean willBeInline) {
        MemoPartObject ret_value = null;
        if (memoPart instanceof MemoPartObject) {
            SearchPathSingleObject searchPath = ((MemoPartObject)memoPart).getSearchPath();
            BaseClass bc = (BaseClass)attachmentReplies.get(searchPath);
            if (this.isFormatMHT(bc)) {
                MemoPartObject mpobj = (MemoPartObject)memoPart;
                if (willBeInline) {
                    mpobj.setContentDisposition(SmtpContentDispositionEnum.inline);
                }
                ret_value = mpobj;
            }
        } else if (memoPart instanceof MemoPartComposite) {
            MemoPartComposite memoPartComposite = (MemoPartComposite)memoPart;
            MemoPart[] compositeParts = memoPartComposite.getParts();
            for (int i = 0; i < compositeParts.length && ret_value == null; ++i) {
                MemoPart partI = compositeParts[i];
                ret_value = this.getFirstMHTAttachment(partI, attachmentReplies, willBeInline);
            }
        }
        return ret_value;
    }

    private boolean isFormatMHT(BaseClass bc) {
        IAttachmentsProcessor ap = AttachmentsProcessorFactory.getInstance();
        if (bc instanceof Output) {
            return ap.isMHT(((Output)bc).getFormat());
        }
        if (bc instanceof DocumentContent) {
            return ap.isMHT(((DocumentContent)bc).getFormat());
        }
        return false;
    }

    private BaseClass getAttachmentContent(QueryRepliesHandler replyHandler) {
        BaseClass bc = replyHandler.getBase();
        if (bc instanceof Output || bc instanceof DocumentContent) {
            return bc;
        }
        if (replyHandler.getOutput() != null) {
            return replyHandler.getOutput();
        }
        return replyHandler.getEventOutput();
    }

    private MemoPart rebuildMemoParts(MemoPart memoPart) throws DeliveryOptionsBuilderException {
        MemoPart newMemo = null;
        if (memoPart instanceof MemoPartObjectLinks) {
            newMemo = memoPart;
        } else if (memoPart instanceof MemoPartObject) {
            String memoObjectPath = ((MemoPartObject)memoPart).getSearchPath().get_value();
            String searchPath = this.m_eod.getInlineMemoPartObjectPath();
            if (searchPath == null || !searchPath.equals(memoObjectPath)) {
                newMemo = memoPart;
            }
        } else if (memoPart instanceof MemoPartString) {
            newMemo = memoPart;
        } else if (memoPart instanceof MemoPartMIMEAttachment) {
            SmtpContentDispositionEnum contentEnum = memoPart.getContentDisposition();
            if (contentEnum != null && contentEnum.equals((Object)SmtpContentDispositionEnum.inline) && this.m_eod.getInlineMemoPartObject() != null) {
                memoPart = this.m_eod.getInlineMemoPartObject();
            }
            newMemo = memoPart;
        } else if (memoPart instanceof MemoPartComposite) {
            ArrayList<MemoPart> memoList = new ArrayList<MemoPart>();
            MemoPartComposite memoPartComposite = (MemoPartComposite)memoPart;
            MemoPart[] compositeParts = memoPartComposite.getParts();
            for (int i = 0; i < compositeParts.length; ++i) {
                MemoPart memo = this.rebuildMemoParts(compositeParts[i]);
                if (memo == null) continue;
                memoList.add(memo);
            }
            MemoPartComposite mpc = new MemoPartComposite();
            mpc.setContentDisposition(memoPartComposite.getContentDisposition());
            mpc.setContentType(memoPartComposite.getContentType());
            mpc.setName(memoPartComposite.getName());
            mpc.setParts(memoList.toArray(new MemoPart[0]));
            newMemo = mpc;
        }
        return newMemo;
    }

    private MemoPart[] retrieveMemoPartsPreProcess(MemoPart memoPart, BiBusHeader header, boolean isRelated) throws DeliveryOptionsBuilderException {
        MemoPart[] ret_value = new MemoPart[]{memoPart};
        if (memoPart instanceof MemoPartObjectLinks) {
            this.retrieveMemoPartObjectLinks((MemoPartObjectLinks)memoPart);
        } else if (memoPart instanceof MemoPartObject) {
            this.retrieveMemoPartObjectAttachments((MemoPartObject)memoPart);
        } else if (memoPart instanceof MemoPartString) {
            this.m_eod.setHasMemoPartString();
            MemoPartString mps = (MemoPartString)memoPart;
            boolean hascontent = null != mps && null != mps.getText() && mps.getText().length() > 0;
            this.m_eod.setIsMemoPartStringEmpty(!hascontent);
        } else if (memoPart instanceof MemoPartMIMEAttachment) {
            SmtpContentDispositionEnum contentEnum;
            MemoPartMIMEAttachment mpma = (MemoPartMIMEAttachment)memoPart;
            if (!isRelated) {
                this.getAttachmentCheckStrategy().checkAttachment(mpma);
            }
            if ((contentEnum = mpma.getContentDisposition()) != null && contentEnum.equals((Object)SmtpContentDispositionEnum.inline)) {
                this.m_eod.setHasMemoPartMIMEAttachment();
            }
            if (!isRelated) {
                this.m_eod.addMemoPartMIMEAttachment((MemoPartMIMEAttachment)memoPart);
            }
            ret_value = new MemoPart[]{memoPart};
        } else if (memoPart instanceof MemoPartComposite) {
            MemoPartComposite memoPartComposite = (MemoPartComposite)memoPart;
            MemoPart[] compositeParts = memoPartComposite.getParts();
            boolean isCompRelated = false;
            SmtpContentTypeEnum contentType = memoPartComposite.getContentType();
            if (contentType != null && contentType.equals((Object)SmtpContentTypeEnum.related)) {
                isCompRelated = true;
            }
            ArrayList<Object> newCompositeParts = new ArrayList<Object>();
            for (int i = 0; i < compositeParts.length; ++i) {
                MemoPart partI = compositeParts[i];
                MemoPart[] retrievedMemoParts = this.retrieveMemoPartsPreProcess(partI, header, isCompRelated);
                newCompositeParts.addAll(Arrays.asList(retrievedMemoParts));
            }
            if (isCompRelated) {
                MemoPartMIMEAttachment mpma;
                boolean inLine;
                String filename = memoPartComposite.getName();
                SmtpContentDispositionEnum contentDisposition = memoPartComposite.getContentDisposition();
                boolean bl = inLine = contentDisposition != null && contentDisposition.equals((Object)SmtpContentDispositionEnum.inline);
                if (inLine && filename == null) {
                    filename = this.m_MimeTextEncoder.encodeMimeText(this.subject) + ".mht";
                }
                if ((mpma = this.getAttachmentCheckStrategy().checkRelatedAttachments(newCompositeParts, filename, inLine)) != null) {
                    if (inLine && !"application/x-zip-compressed".equals(mpma.getDataType())) {
                        mpma.setDataType("text/html; charset=utf-8");
                    } else {
                        ret_value = new MemoPart[]{mpma};
                    }
                    newCompositeParts.clear();
                    newCompositeParts.add(mpma);
                    this.m_eod.addMemoPartMIMEAttachment(mpma);
                } else {
                    for (Object e : newCompositeParts) {
                        if (!(e instanceof MemoPartMIMEAttachment)) continue;
                        this.m_eod.addMemoPartMIMEAttachment((MemoPartMIMEAttachment)e);
                    }
                }
            }
            if (!(memoPart instanceof MemoPartMIMEAttachment)) {
                memoPartComposite.setParts(newCompositeParts.toArray(new MemoPart[0]));
            }
        } else if (memoPart instanceof MemoPartAgentObject) {
            MemoPartAgentObject memoPartAgentObject = (MemoPartAgentObject)memoPart;
            BaseClass[] selectedOutputs = this.selectOutputs(memoPartAgentObject, header);
            if (selectedOutputs.length == 0) {
                MemoPartObject memoPartObject = new MemoPartObject();
                memoPartObject.setName(memoPartAgentObject.getName());
                memoPartObject.setSearchPath(memoPartAgentObject.getSearchPath());
                memoPartObject.setContentDisposition(memoPartAgentObject.getContentDisposition());
                this.retrieveMemoPartObjectAttachments(memoPartObject);
                ret_value = new MemoPart[]{memoPartObject};
            } else {
                MemoPart[] convertedMemoParts = new MemoPart[selectedOutputs.length];
                for (int i = 0; i < selectedOutputs.length; ++i) {
                    Output output = (Output)selectedOutputs[i];
                    MemoPartObject memoPartObject = new MemoPartObject();
                    convertedMemoParts[i] = memoPartObject;
                    if (output.getBurstKey() != null && output.getBurstKey().getValue() != null) {
                        String memoPartAgentObjectName = memoPartAgentObject.getName();
                        int fileExtensionPosition = memoPartAgentObjectName.lastIndexOf(46);
                        if (fileExtensionPosition > -1) {
                            String leftSubString = memoPartAgentObjectName.substring(0, fileExtensionPosition);
                            String rightSubString = memoPartAgentObjectName.substring(fileExtensionPosition, memoPartAgentObjectName.length());
                            memoPartAgentObjectName = leftSubString + '_' + output.getBurstKey().getValue() + rightSubString;
                        } else {
                            memoPartAgentObjectName = memoPartAgentObjectName + '_' + output.getBurstKey().getValue();
                        }
                        memoPartObject.setName(memoPartAgentObjectName);
                    } else {
                        memoPartObject.setName(memoPartAgentObject.getName());
                    }
                    SearchPathSingleObject searchPathSingleObject = new SearchPathSingleObject();
                    searchPathSingleObject.set_value("storeID(\"" + output.getStoreID().getValue() + "\")");
                    memoPartObject.setSearchPath(searchPathSingleObject);
                    memoPartObject.setContentDisposition(memoPartAgentObject.getContentDisposition());
                    this.retrieveMemoPartObjectAttachments(memoPartObject);
                }
                ret_value = convertedMemoParts;
            }
        }
        return ret_value;
    }

    private void retrieveMemoPartObjectAttachments(MemoPartObject mpo) throws DeliveryOptionsBuilderException {
        try {
            mpo.setName(this.expandParameter(mpo.getName()));
            mpo.getSearchPath().set_value(this.expandParameter(mpo.getSearchPath().get_value()));
            IAttachmentsProcessor processor = AttachmentsProcessorFactory.getInstance();
            processor.retrieveAttachment(mpo, this.m_eod);
        }
        catch (MimeMessageBuilderException e) {
            throw new DeliveryOptionsBuilderException(e.getI18NCode(), e.getParams(), e);
        }
    }

    private void retrieveMemoPartObjectLinks(MemoPartObjectLinks mpol) throws DeliveryOptionsBuilderException {
        try {
            ILinksProcessor processor = LinksProcessorFactory.getInstance();
            ProcessedLinks processed = processor.processLinks(mpol, this.m_emailEncoding, this.m_eod, this.m_MimeTextEncoder);
            this.m_eod.getHtmlURL().append(processed.getHtmlUrl());
            this.m_eod.getTextURL().append(processed.getTextUrl());
        }
        catch (MimeMessageBuilderException e) {
            throw new DeliveryOptionsBuilderException(e.getI18NCode(), e.getParams(), e);
        }
    }

    private String expandParameter(String value) {
        if (value != null && value.length() > 2 && value.charAt(0) == '?' && value.charAt(value.length() - 1) == '?') {
            String name = value.substring(1, value.length() - 1);
            ParameterValue param = ObjectModelUtil.findParameter((ParameterValue[])this.m_eod.getParameterValue(), (String)name);
            if (param != null && param.getValue() != null && param.getValue().length == 1) {
                ParmValueItem parmValue = param.getValue()[0];
                if (parmValue != null && parmValue instanceof SimpleParmValueItem) {
                    value = ((SimpleParmValueItem)parmValue).getUse();
                }
            } else {
                value = null;
            }
        }
        return value;
    }

    private void setNotificationListAddresses(BiBusHeader header, DeliveryOption option) throws DeliveryOptionsBuilderException {
        if (option instanceof DeliveryOptionSearchPathSingleObject) {
            SearchPathSingleObject spso = ((DeliveryOptionSearchPathSingleObject)option).getValue();
            if (spso != null) {
                try {
                    DeliveryServiceHandler handler = new DeliveryServiceHandler(header);
                    NotificationList notifList = new NotificationList(handler.getNotificationObject(spso));
                    List addresses = notifList.getAddresses(new JobBiBusHeaders(header));
                    this.m_eod.addAddresses(Message.RecipientType.BCC, addresses);
                }
                catch (DeliveryServiceHandlerException ex) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
                    SDSLogger.getLogger((SDSCategory)DLSCategory.AUDIT).debug("[DeliveryServiceHandlerException] Error retrieving notification recipients for object at :" + spso.get_value());
                    throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR, (LocalizableException)((Object)ex));
                }
            }
        } else {
            this.throwIncorrectOptionTypeError(DeliveryOptionSearchPathSingleObject.class, option);
        }
    }

    private Object getSingleRecipientCandidate(boolean emailRecipientConsistency) {
        Object obj = null;
        if (this.m_toAddresses.size() == 1) {
            obj = this.m_toAddresses.get(0);
        } else if (emailRecipientConsistency) {
            if (this.m_ccAddresses.size() == 1 && this.m_toAddresses.size() == 0 && this.m_bccAddresses.size() == 0) {
                obj = this.m_ccAddresses.get(0);
            } else if (this.m_bccAddresses.size() == 1 && this.m_toAddresses.size() == 0 && this.m_ccAddresses.size() == 0) {
                obj = this.m_bccAddresses.get(0);
            }
        }
        return obj;
    }

    private BaseClass[] selectOutputs(MemoPartAgentObject memoPartAgentObject, BiBusHeader header) throws DeliveryOptionsBuilderException {
        boolean emailRecipientConsistency;
        Object obj;
        BiBusHeader headerToUse = header;
        String searchPathValue = this.expandParameter(memoPartAgentObject.getSearchPath().get_value());
        if (searchPathValue == null) {
            return new BaseClass[0];
        }
        BaseClass[] outputs = m_outputCache.get(searchPathValue, header);
        boolean burstOutputs = this.isBurstOutputs(outputs);
        String formatHint = memoPartAgentObject.getFormat();
        String localeHint = memoPartAgentObject.getLocale();
        String recipientHint = null;
        String accountFact = null;
        boolean respectBurstSecurity = CRNProperties.getInstance().getBoolAdvancedPropertyValue("dls.respect.burst.security", true);
        if (respectBurstSecurity && burstOutputs && (obj = this.getSingleRecipientCandidate(emailRecipientConsistency = CRNProperties.getInstance().getBoolAdvancedPropertyValue("dls.burst.recipient.consistency", false))) != null) {
            if (obj instanceof AddressSMTP) {
                recipientHint = ((AddressSMTP)obj).get_value();
            } else if (obj instanceof SearchPathMultipleObject) {
                accountFact = ((SearchPathMultipleObject)obj).get_value();
            }
        }
        boolean useCache = true;
        if (accountFact != null) {
            String credentialPath = accountFact + "/credential";
            BiBusHeader headerCopy = BiBusUtilities.getDeepCopy((BiBusHeader)header);
            CAM cam = new CAM();
            cam.setCAMCredentialPath(credentialPath);
            cam.setAction("logonAs");
            headerCopy.setCAM(cam);
            JobBiBusHeaders newHeaders = new JobBiBusHeaders(headerCopy);
            try {
                AuthenticatorFactory.getInstance().logon(newHeaders);
            }
            catch (EMFSecurityException e) {
                throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR, e);
            }
            catch (SDKClientException e) {
                throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR, (LocalizableException)((Object)e));
            }
            headerToUse = newHeaders.getBiBusHeader();
            useCache = false;
        }
        BaseClass[] ret_value = this.selectOutputs(searchPathValue, formatHint, localeHint, recipientHint, headerToUse, useCache);
        if (accountFact != null) {
            try {
                AuthenticatorFactory.getInstance().logoff(headerToUse);
            }
            catch (EMFSecurityException e) {
                throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR, e);
            }
        }
        return ret_value;
    }

    private BaseClass[] selectOutputs(String searchPath, String formatHint, String localeHint, String recipientEmailHint, BiBusHeader header, boolean useCache) throws DeliveryOptionsBuilderException {
        BaseClass[] outputs = null;
        outputs = useCache ? m_outputCache.get(searchPath, header) : m_outputCache.getOutputs(searchPath, header, false);
        BaseClass[] ret_value = this.matchOutputs(outputs, formatHint, localeHint, recipientEmailHint);
        return ret_value;
    }

    private boolean isBurstOutputs(BaseClass[] outputs) {
        boolean ret_value = false;
        if (outputs != null && outputs.length > 0) {
            ret_value = true;
            for (int i = 0; i < outputs.length && ret_value; ++i) {
                Output output = (Output)outputs[i];
                if (output.getBurstKey() != null && output.getBurstKey().getValue() != null) continue;
                ret_value = false;
            }
        }
        return ret_value;
    }

    private BaseClass[] matchOutputs(BaseClass[] outputs, String formatHint, String localeHint, String recipientEmailHint) {
        ArrayList<Output> ret_value = new ArrayList<Output>();
        if (outputs != null) {
            Output output = null;
            for (int i = 0; i < outputs.length; ++i) {
                boolean recipientMatches;
                output = (Output)outputs[i];
                if (output.getDataType() != null && output.getDataType().getValue() != null && output.getDataType().getValue().toLowerCase().contains("message/rfc822".toLowerCase()) && output.getFormat().getValue().equals("XHTML")) {
                    output.getFormat().setValue("MHT");
                }
                boolean formatMatches = formatHint != null && formatHint.length() > 0 ? output.getFormat().getValue().equals(formatHint) : true;
                boolean localeMatches = localeHint != null && localeHint.length() > 0 ? output.getLocale().getValue().equals(localeHint) : true;
                boolean bl = recipientMatches = recipientEmailHint != null && recipientEmailHint.length() > 0 ? this.recipientIncluded(output.getRecipientsEMail(), recipientEmailHint) : true;
                if (!formatMatches || !localeMatches || !recipientMatches) continue;
                ret_value.add(output);
            }
        }
        return ret_value.toArray(new BaseClass[0]);
    }

    private List mergeRecipients(DeliveryOption cmAddresses, DeliveryOption smtpAddresses) {
        DeliveryOptionAddressSMTPArray deliveryOptionAddressSMTPArray;
        AddressSMTP[] addressSMTPArray;
        int i;
        DeliveryOptionSearchPathMultipleObjectArray deliveryOptionSearchPathArray;
        SearchPathMultipleObject[] searchPathMultipleObjectArray;
        ArrayList<Object> ret_value = new ArrayList<Object>();
        if (cmAddresses != null && (searchPathMultipleObjectArray = (deliveryOptionSearchPathArray = (DeliveryOptionSearchPathMultipleObjectArray)cmAddresses).getValue()) != null && searchPathMultipleObjectArray.length > 0) {
            for (i = 0; i < searchPathMultipleObjectArray.length; ++i) {
                SearchPathMultipleObject searchPathMultipleObject = searchPathMultipleObjectArray[i];
                ret_value.add(searchPathMultipleObject);
            }
        }
        if (smtpAddresses != null && (addressSMTPArray = (deliveryOptionAddressSMTPArray = (DeliveryOptionAddressSMTPArray)smtpAddresses).getValue()) != null && addressSMTPArray.length > 0) {
            for (i = 0; i < addressSMTPArray.length; ++i) {
                AddressSMTP addressSMTP = addressSMTPArray[i];
                ret_value.add(addressSMTP);
            }
        }
        return ret_value;
    }

    private boolean recipientIncluded(StringArrayProp stringArrayProp, String string) {
        String[] stringArray;
        boolean ret_value = false;
        if (stringArrayProp != null && string != null && string.trim().length() > 0 && (stringArray = stringArrayProp.getValue()) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].trim().length() <= 0 || !stringArray[i].trim().equals(string.trim())) continue;
                ret_value = true;
                break;
            }
        }
        return ret_value;
    }
}

