/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.dls.DeliveryOptionsBuilderException;
import com.cognos.dls.smtp.CacheLock;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import java.util.Hashtable;
import java.util.LinkedList;

class Cache {
    private static Hashtable<String, BaseClass[]> m_cache = new Hashtable();
    private static LinkedList<String> m_mostRecentlyUsed = new LinkedList();
    private static int MAX_RETAINED = 50;

    Cache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseClass[] get(String searchPath, BiBusHeader header) throws DeliveryOptionsBuilderException {
        CacheLock searchPathLock = CacheLock.getLock(searchPath);
        searchPathLock.lock();
        BaseClass[] outputs = null;
        outputs = m_cache.get(searchPath);
        if (outputs != null) {
            LinkedList<String> linkedList = m_mostRecentlyUsed;
            synchronized (linkedList) {
                if (m_mostRecentlyUsed.remove(searchPath)) {
                    m_mostRecentlyUsed.addFirst(searchPath);
                }
            }
        }
        outputs = this.getOutputs(searchPath, header, true);
        LinkedList<String> linkedList = m_mostRecentlyUsed;
        synchronized (linkedList) {
            if (m_cache.size() == MAX_RETAINED) {
                m_cache.remove(m_mostRecentlyUsed.removeLast());
            }
            m_cache.put(searchPath, outputs);
            m_mostRecentlyUsed.addFirst(searchPath);
        }
        searchPathLock.unlock();
        return outputs;
    }

    public BaseClass[] getOutputs(String searchPath, BiBusHeader header, boolean trustedRequest) throws DeliveryOptionsBuilderException {
        PropEnum[] props = new PropEnum[]{PropEnum.searchPath, PropEnum.storeID, PropEnum.format, PropEnum.locale, PropEnum.burstKey, PropEnum.recipientsEMail, PropEnum.dataType};
        ContentManagerServiceClientPort cmPort = null;
        BaseClass[] outputs = null;
        try {
            cmPort = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
            if (trustedRequest) {
                cmPort.signNextRequest("DLS");
            }
            outputs = cmPort.query(new SearchPathMultipleObject(searchPath + "/output"), props, null, null);
        }
        catch (EMFSecurityException e) {
            throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR, e);
        }
        catch (SDKClientException e) {
            throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR, (LocalizableException)((Object)e));
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return outputs;
    }
}

