/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.GenericOptionString;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.OptionsRunnable;
import com.cognos.dls.OptionsValidator;
import com.cognos.dls.api.DeliveryServiceImpl;
import com.cognos.dls.notification.HTSConnector;
import com.cognos.dls.smtp.DeliveryOptionsValidator;
import com.cognos.dls.smtp.SMTPDeliveryService;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.axis.AxisFault;

public class DeliveryOptionsRunnable
extends OptionsRunnable {
    private AsynchOptionStringArray[] m_context;

    public DeliveryOptionsRunnable(OptionsValidator validator, SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options, BiBusHeader header) throws LocalizableException {
        super(validator, objectPath, parameterValues, options);
        List<Option> listOptions = Arrays.asList(OptionUtils.findOptionsByType((Option[])this.getOptions(), AsynchOptionStringArray.class));
        this.m_context = listOptions.toArray(new AsynchOptionStringArray[listOptions.size()]);
        this.setHeaders(header);
    }

    public DeliveryOptionsRunnable(DeliveryOptionsValidator validator, GuidProp objectPath, ParameterValue[] parameterValues, Option[] options) throws LocalizableException {
        super((OptionsValidator)validator, objectPath, parameterValues, options);
    }

    public DeliveryOption[] getDeliveryOptions() {
        List<Option> listOptions = Arrays.asList(OptionUtils.findOptionsByType((Option[])this.getOptions(), DeliveryOption.class));
        return listOptions.toArray(new DeliveryOption[listOptions.size()]);
    }

    public Option getPushNotificationOption() {
        Option result = null;
        try {
            Option[] genericOptionPushMsg = OptionUtils.findOptionsByType((Option[])this.getOptions(), GenericOptionString.class);
            if (null != genericOptionPushMsg && genericOptionPushMsg.length > 0 && null != genericOptionPushMsg[0]) {
                return genericOptionPushMsg[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void run() throws AxisFault, LocalizableException {
        BiBusHeader header = this.getHeaders();
        DeliveryOption[] options = this.getDeliveryOptions();
        Option pushoption = null;
        boolean pushNotificationEnabled = CRNProperties.getInstance().getBoolAdvancedPropertyValue("emf.mail.pushnotification.enabled", true);
        if (pushNotificationEnabled) {
            pushoption = this.getPushNotificationOption();
        }
        if (DeliveryServiceImpl.isEmailDelivery((Option[])options)) {
            SMTPDeliveryService deliveryService = SMTPDeliveryService.getInstance();
            deliveryService.emailDelivery(header, options, pushoption, LocaleUtil.getRequestProductLocale((BiBusHeader)header), this.getObjectPath(), this.getParameterValues(), (Option[])this.m_context);
        }
        if (DeliveryServiceImpl.isHTSNotification((Option[])options)) {
            HTSConnector htsConnector = new HTSConnector(header, (Option[])options);
            htsConnector.notifyHTS();
        }
    }
}

