/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AddressSMTP;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionAddressSMTPArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionSearchPathMultipleObjectArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionString;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.MemoPartObjectLinks;
import com.cognos.developer.schemas.bibus._3.MemoPartString;
import com.cognos.developer.schemas.bibus._3.SmtpContentDispositionEnum;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.HistoryTopicsProcessor;
import com.cognos.dls.cpns.message.CPNSMessage;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.IMimeMessageBuilder;
import com.cognos.dls.smtp.MimeMessageBuilderException;
import com.cognos.dls.smtp.MimeTextEncoder;
import com.cognos.dls.smtp.RecipientsHolder;
import com.cognos.dls.smtp.rest.CogConfigRestCache;
import com.cognos.dls.smtp.transport.TransportException;
import com.cognos.dls.util.AttachmentsProcessorFactory;
import com.cognos.dls.util.DLSFileNameUtil;
import com.cognos.dls.util.IAttachmentsProcessor;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.datasource.DataSourceFactory;
import com.cognos.jsmcommon.util.datasource.NCDataSource;
import com.cognos.spec.smtpRules.castor.FailMail;
import com.cognos.spec.smtpRules.castor.Recipient;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.commons.io.IOUtils;

public final class DeliveryOptionsToMimeMessageBuilder
implements IMimeMessageBuilder {
    private static final String HTML_BODY_IDENTIFIER = "<html>";
    private static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    private static final String BASE64 = "base64";
    static final String CONTENT_ID_PREFIX = "cid:";
    static final String HTML_PREFIX = "html:";
    Session m_session;
    MimeTextEncoder m_MimeTextEncoder;
    EmailOptionsDeliverable m_eod;
    StringBuffer m_textURL = new StringBuffer();
    StringBuffer m_htmlURL = new StringBuffer();
    boolean m_memoPartString = false;
    boolean m_memoPartMIMEAttachment = false;
    boolean m_rawFormat = false;
    boolean m_inline = false;
    boolean m_completedBCC = false;
    HistoryTopicsProcessor m_historyTopicProcessor = null;
    private MimeMessage m_cachedMimeMessage;
    private RecipientsHolder m_recipientsHolder;
    String m_emailEncoding = "UTF-8";

    public DeliveryOptionsToMimeMessageBuilder(Session session, EmailOptionsDeliverable eod) {
        this.m_session = session;
        String emailEncoding = session.getProperty("email.encoding");
        this.m_MimeTextEncoder = new MimeTextEncoder(emailEncoding);
        this.m_emailEncoding = emailEncoding;
        this.m_eod = eod;
        this.m_historyTopicProcessor = new HistoryTopicsProcessor(eod.getParameterValue());
        this.m_recipientsHolder = new RecipientsHolder();
    }

    @Override
    public void setRawFormat() {
        this.m_rawFormat = true;
    }

    @Override
    public CPNSMessage[] getCPNSMessage() throws MimeMessageBuilderException {
        CPNSMessage[] result = null;
        String gcmPayload = this.m_eod.getCPNSPayload();
        if (gcmPayload != null && gcmPayload.length() > 0) {
            CPNSMessage m_CPNSMessage = new CPNSMessage();
            m_CPNSMessage.setGcmPayload(gcmPayload);
            m_CPNSMessage.setTargetDeviceIds(this.m_eod.getDeviceId());
            result = new CPNSMessage[]{m_CPNSMessage};
        }
        return result;
    }

    @Override
    public MimeMessage[] getMimeMessages() throws MimeMessageBuilderException {
        DeliveryOptionEnum xenum;
        int i;
        DeliveryOption[] options = this.m_eod.getDeliveryOptions();
        MimeMessage mimeMessage = new MimeMessage(this.m_session);
        try {
            mimeMessage.setText("");
        }
        catch (MessagingException e) {
            throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
        }
        InternetAddress senderAddr = this.getSender();
        if (senderAddr != null) {
            try {
                mimeMessage.setFrom((Address)senderAddr);
                mimeMessage.setSender((Address)senderAddr);
            }
            catch (MessagingException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{e.getMessage()});
            }
        }
        for (i = 0; i < options.length; ++i) {
            xenum = options[i].getName();
            if (!xenum.getValue().equalsIgnoreCase("characterSetEncoding")) continue;
            this.m_MimeTextEncoder.setEncodingOption(options[i]);
        }
        for (i = 0; i < options.length; ++i) {
            xenum = options[i].getName();
            if (xenum.getValue().equalsIgnoreCase("characterSetEncoding")) continue;
            if (xenum.getValue().equalsIgnoreCase("to")) {
                this.setAddresses(mimeMessage, Message.RecipientType.TO, options[i]);
                continue;
            }
            if (xenum.getValue().equalsIgnoreCase("cc")) {
                this.setAddresses(mimeMessage, Message.RecipientType.CC, options[i]);
                continue;
            }
            if (xenum.getValue().equalsIgnoreCase("bcc")) {
                this.setAddresses(mimeMessage, Message.RecipientType.BCC, options[i]);
                continue;
            }
            if (xenum.getValue().equalsIgnoreCase("toAddress")) {
                this.setSMTPAddresses(mimeMessage, Message.RecipientType.TO, options[i]);
                continue;
            }
            if (xenum.getValue().equalsIgnoreCase("ccAddress")) {
                this.setSMTPAddresses(mimeMessage, Message.RecipientType.CC, options[i]);
                continue;
            }
            if (xenum.getValue().equalsIgnoreCase("bccAddress")) {
                this.setSMTPAddresses(mimeMessage, Message.RecipientType.BCC, options[i]);
                continue;
            }
            if (xenum.getValue().equalsIgnoreCase("subject")) {
                this.setSubject(mimeMessage, options[i]);
                continue;
            }
            if (xenum.getValue().equalsIgnoreCase("memoPart")) {
                this.setMessageParts(mimeMessage, options[i]);
                continue;
            }
            if (!xenum.getValue().equalsIgnoreCase("notificationList")) continue;
            this.setAddresses(mimeMessage, Message.RecipientType.BCC, options[i]);
        }
        try {
            this.m_recipientsHolder.setRecipients(mimeMessage);
        }
        catch (MessagingException ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{ex.getMessage()});
        }
        this.m_cachedMimeMessage = mimeMessage;
        return new MimeMessage[]{mimeMessage};
    }

    @Override
    public MimeMessage getFailMimeMessage(TransportException te) throws MimeMessageBuilderException {
        MimeMessage[] mimeMessages;
        if (this.m_cachedMimeMessage == null && (mimeMessages = this.getMimeMessages()) != null && mimeMessages.length > 0) {
            this.m_cachedMimeMessage = mimeMessages[0];
        }
        FailMail failMail = te.getAction() != null && te.getAction().getBehaviour() != null ? te.getAction().getBehaviour().getFailMail() : null;
        try {
            Locale locale = this.m_eod.getLocale();
            String subject = null;
            subject = failMail != null && failMail.getSubject() != null ? failMail.getSubject() : I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_SEND_FAILED_SUBJECT_TEXT, (Object[])new Object[]{this.m_cachedMimeMessage.getSubject()}, (Locale)locale);
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, MMM d, yyyy hh:mm:ss z", locale);
            String date = sdf.format(new Date());
            int iSize = this.m_cachedMimeMessage.getSize();
            this.m_cachedMimeMessage.setSubject(subject);
            StringBuffer body_buffer = new StringBuffer();
            body_buffer.append(I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_SEND_FAILED_BODY_TEXT, (Locale)locale));
            body_buffer.append("\n");
            body_buffer.append(I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_SEND_FAILED_BODY_SUBJECT, (Object[])new Object[]{this.m_cachedMimeMessage.getSubject()}, (Locale)locale));
            body_buffer.append("\n");
            body_buffer.append(I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_SEND_FAILED_BODY_DATE, (Object[])new Object[]{date}, (Locale)locale));
            if (iSize != -1) {
                body_buffer.append("\n");
                body_buffer.append(I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_SEND_FAILED_BODY_SIZE, (Object[])new Object[]{String.valueOf(iSize)}, (Locale)locale));
            }
            body_buffer.append("\n");
            body_buffer.append(I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_SENT_FAILURE_ERROR, (Object[])new Object[]{te.getLocalizedMessage()}, (Locale)locale));
            MimeMultipart mmp = new MimeMultipart();
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setText(body_buffer.toString());
            mmp.addBodyPart((BodyPart)mbp);
            this.m_cachedMimeMessage.setContent((Multipart)mmp);
            this.m_cachedMimeMessage.setSentDate(new Date());
            if (failMail != null && failMail.getRecipients() != null) {
                if (!failMail.getRecipients().getSendToCurrentRecipients()) {
                    this.m_cachedMimeMessage.setRecipients(Message.RecipientType.BCC, new Address[0]);
                    this.m_cachedMimeMessage.setRecipients(Message.RecipientType.CC, new Address[0]);
                    this.m_cachedMimeMessage.setRecipients(Message.RecipientType.TO, new Address[0]);
                }
                if (failMail.getRecipients().getOwner() && this.m_eod.getUserAccountInfo().getUserAccount().getEmail() != null) {
                    String ownerEmail = this.m_eod.getUserAccountInfo().getUserAccount().getEmail().getValue();
                    InternetAddress owner = null;
                    if (ownerEmail != null && !"".equals(ownerEmail)) {
                        owner = new InternetAddress(ownerEmail);
                        this.m_cachedMimeMessage.addRecipient(Message.RecipientType.TO, (Address)owner);
                    }
                }
                Enumeration enuma = failMail.getRecipients().enumerateRecipient();
                while (enuma.hasMoreElements()) {
                    String email = ((Recipient)enuma.nextElement()).getAddress();
                    InternetAddress recip = new InternetAddress(email);
                    this.m_cachedMimeMessage.addRecipient(Message.RecipientType.TO, (Address)recip);
                }
            }
            if (this.m_cachedMimeMessage.getAllRecipients() == null || this.m_cachedMimeMessage.getAllRecipients().length == 0) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_EMPTY_NOTIFICATION, new Object[0]);
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("no recipient found for fail mail");
                return null;
            }
            this.m_cachedMimeMessage.saveChanges();
        }
        catch (MessagingException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{e.getMessage()});
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
        }
        return this.m_cachedMimeMessage;
    }

    private InternetAddress getDefaultSender() {
        String defaultSender = this.m_session.getProperty("default.sender");
        InternetAddress defaultSenderIA = null;
        if (defaultSender != null) {
            try {
                defaultSenderIA = new InternetAddress(defaultSender);
            }
            catch (AddressException e1) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_INVALID_ADDRESS, new Object[]{e1.getMessage()});
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_INVALID_ADDRESS, new Object[]{defaultSender});
            }
        }
        return defaultSenderIA;
    }

    private InternetAddress getSender() {
        InternetAddress address = null;
        try {
            if (!this.m_rawFormat && !this.isAlwaysUseDefaultSender()) {
                Account account = this.m_eod.getUserAccountInfo().getUserAccount();
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DeliveryOptionsToMimeMessageBuilder getUserAccountInfo " + account);
                if (account != null) {
                    String email = account.getEmail() != null ? account.getEmail().getValue() : null;
                    String userSurName = account.getSurname().getValue();
                    String userGivenName = account.getGivenName().getValue();
                    String userName = userGivenName + " " + userSurName;
                    if ((userName = userName.trim()).length() < 1) {
                        userName = account.getUserName().getValue();
                    }
                    SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DeliveryOptionsToMimeMessageBuilder getUserAccountInfo inetaddress issue " + email + " user" + userName);
                    boolean useSenderName = CRNProperties.getProperty((String)"useSenderName", (boolean)false);
                    if (email != null && userName != null) {
                        try {
                            address = useSenderName ? new InternetAddress(email, userName) : new InternetAddress(email);
                            return address;
                        }
                        catch (UnsupportedEncodingException e) {
                            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DeliveryOptionsToMimeMessageBuilder getUserAccountInfo inetaddress issue " + e.getMessage());
                        }
                    }
                    SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DeliveryOptionsToMimeMessageBuilder getUserAccountInfo email " + email);
                    email = CogConfigRestCache.getinstance().getDefaultSenderOfTenant(this.m_eod.getHeader(), email);
                    SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DeliveryOptionsToMimeMessageBuilder cogConfigRestClient.getDefaultSenderOfTenant email " + email);
                    if (email != null && !"".equals(email)) {
                        address = new InternetAddress(email);
                    } else {
                        CogConfigRestCache.getinstance();
                        String globalEmailId = CogConfigRestCache.getGlobalDefaultSenderID(this.m_eod.getHeader(), email);
                        SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DeliveryOptionsToMimeMessageBuilder cogConfigRestClient.getGlobalDefaultSenderID email " + globalEmailId);
                        if (globalEmailId != null && !"".equals(globalEmailId)) {
                            address = new InternetAddress(globalEmailId);
                        }
                    }
                }
            }
        }
        catch (AddressException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("[AddressException] Email address for sender in Content Manager is not in RFC822 format; will use default value.");
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug((Throwable)e);
        }
        if (address == null) {
            address = this.getDefaultSender();
        }
        return address;
    }

    private void setSMTPAddresses(MimeMessage mimeMessage, Message.RecipientType type, DeliveryOption option) throws MimeMessageBuilderException {
        if (!(option instanceof DeliveryOptionAddressSMTPArray)) {
            this.throwIncorrectOptionTypeError(DeliveryOptionAddressSMTPArray.class, option);
        }
        DeliveryOptionAddressSMTPArray stringArray = (DeliveryOptionAddressSMTPArray)option;
        AddressSMTP[] addresses = stringArray.getValue();
        for (int i = 0; i < addresses.length; ++i) {
            try {
                if (addresses[i].get_value() != null) {
                    this.m_recipientsHolder.addRecipient(type, addresses[i].get_value(), this.m_eod.getHeader());
                    continue;
                }
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_INVALID_ADDRESS, new Object[]{""});
                continue;
            }
            catch (AddressException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_INVALID_ADDRESS, new Object[]{addresses[i].get_value()});
            }
        }
    }

    private void setAddresses(MimeMessage mimeMessage, Message.RecipientType type, DeliveryOption option) throws MimeMessageBuilderException {
        List addrList;
        if (this.m_rawFormat) {
            return;
        }
        if (Message.RecipientType.BCC.equals(type) && this.m_completedBCC) {
            return;
        }
        if (!(option instanceof DeliveryOptionSearchPathMultipleObjectArray) && (DeliveryOptionEnum.to.equals((Object)option.getName()) || DeliveryOptionEnum.cc.equals((Object)option.getName()) || DeliveryOptionEnum.bcc.equals((Object)option.getName()))) {
            this.throwIncorrectOptionTypeError(DeliveryOptionSearchPathMultipleObjectArray.class, option);
        }
        if (!(option instanceof DeliveryOptionSearchPathSingleObject) && DeliveryOptionEnum.notificationList.equals((Object)option.getName())) {
            this.throwIncorrectOptionTypeError(DeliveryOptionSearchPathSingleObject.class, option);
        }
        if ((addrList = this.m_eod.getAddresses(type)) != null) {
            for (String oneStr : addrList) {
                try {
                    this.m_recipientsHolder.addRecipient(type, oneStr, this.m_eod.getHeader());
                }
                catch (AddressException e) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_INVALID_ADDRESS, new Object[]{oneStr});
                }
            }
        }
        this.m_completedBCC = this.m_completedBCC || Message.RecipientType.BCC.equals(type);
    }

    private void setSubject(MimeMessage mimeMessage, DeliveryOption option) throws MimeMessageBuilderException {
        if (!(option instanceof DeliveryOptionString)) {
            this.throwIncorrectOptionTypeError(DeliveryOptionString.class, option);
        }
        DeliveryOptionString sOption = (DeliveryOptionString)option;
        try {
            String subjectStr = sOption.getValue();
            if (this.m_historyTopicProcessor.hasTopics()) {
                subjectStr = this.m_historyTopicProcessor.replace(subjectStr);
            }
            subjectStr = this.m_MimeTextEncoder.encodeMimeSubject(subjectStr);
            mimeMessage.setSubject(subjectStr, this.m_emailEncoding);
        }
        catch (MessagingException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{e.getMessage()});
        }
    }

    private String securityCheckRemoveBCChack(String subjectStr) {
        int j = subjectStr.toLowerCase().indexOf("bcc:");
        while (j > -1) {
            String subjectStr1 = subjectStr.substring(0, j);
            String subjectStr2 = subjectStr.substring(j + 4);
            subjectStr = subjectStr1 + "b c c :" + subjectStr2;
            j = subjectStr.toLowerCase().indexOf("bcc:");
        }
        return subjectStr;
    }

    private void setMessageParts(MimeMessage mimeMessage, DeliveryOption option) throws MimeMessageBuilderException {
        if (!(option instanceof DeliveryOptionMemoPart)) {
            this.throwIncorrectOptionTypeError(DeliveryOptionMemoPart.class, option);
        }
        DeliveryOptionMemoPart memoPartOption = (DeliveryOptionMemoPart)option;
        MemoPart memoPart = memoPartOption.getValue();
        this.buildMemoPartPreProcess(memoPart);
        if (memoPart instanceof MemoPartComposite) {
            MemoPartComposite memoPartComposite = (MemoPartComposite)memoPart;
            MemoPart[] compositeParts = memoPartComposite.getParts();
            String subType = null;
            if (memoPartComposite.getContentType() != null) {
                subType = memoPartComposite.getContentType().getValue();
            }
            MimeMultipart mp = null;
            mp = subType != null ? new MimeMultipart(subType) : new MimeMultipart();
            try {
                MimeBodyPart bp;
                for (int i = 0; i < compositeParts.length; ++i) {
                    bp = new MimeBodyPart();
                    this.setBodyPart((MimePart)bp, compositeParts[i], "attachment");
                    boolean hasContent = false;
                    if (!(compositeParts[i] instanceof MemoPartObjectLinks)) {
                        try {
                            hasContent = bp.getContent() != null;
                        }
                        catch (Exception ex) {
                            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_ATTACHMENT_PROCESSING_ERROR);
                            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)ex);
                        }
                        try {
                            hasContent = bp.getDataHandler().getContent() != null;
                        }
                        catch (Exception ex) {
                            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_ATTACHMENT_PROCESSING_ERROR);
                            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)ex);
                        }
                    } else {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.INFO, DlsI18NCode.MSG_DS_NO_CONTENT_FOR_MEMOPARTOBJECTLINKS);
                    }
                    if (!hasContent) continue;
                    this.addBodyPart((Multipart)mp, bp);
                }
                if (!this.m_inline) {
                    MimeMultipart parts = new MimeMultipart("alternative");
                    bp = new MimeBodyPart();
                    bp.setText(this.m_textURL + "\n", this.m_MimeTextEncoder.getEncoding());
                    bp.setDisposition("inline");
                    parts.addBodyPart((BodyPart)bp);
                    bp = new MimeBodyPart();
                    String text = "<html><body>";
                    text = text + this.m_htmlURL;
                    text = text + "</body></html>";
                    bp.setContent((Object)text, "text/html;charset=\"" + this.m_MimeTextEncoder.getEncoding() + "\"");
                    bp.setDisposition("inline");
                    parts.addBodyPart((BodyPart)bp);
                    bp = new MimeBodyPart();
                    bp.setContent((Multipart)parts);
                    mp.addBodyPart((BodyPart)bp);
                }
                mimeMessage.setContent((Multipart)mp);
            }
            catch (MessagingException e) {
                throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
            }
        }
        this.setMessagePart(mimeMessage, memoPart);
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException e) {
            throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
        }
    }

    private void buildMemoPartPreProcess(MemoPart memoPart) throws MimeMessageBuilderException {
        this.m_memoPartString = this.m_eod.getHasMemoPartString();
        this.m_memoPartMIMEAttachment = this.m_eod.getHasMemoPartMIMEAttachment();
        this.m_htmlURL = this.m_eod.getHtmlURL();
        this.m_textURL = this.m_eod.getTextURL();
    }

    private void setMessagePart(MimeMessage mimeMessage, MemoPart part) throws MimeMessageBuilderException {
        if (part instanceof MemoPartMIMEAttachment) {
            this.addMemoPartMIMEAttachment((MimePart)mimeMessage, (MemoPartMIMEAttachment)part);
        } else if (part instanceof MemoPartObject) {
            this.addMemoPartObject((MimePart)mimeMessage, (MemoPartObject)part);
        } else if (part instanceof MemoPartObjectLinks) {
            this.addMemoPartObjectLinks((MimePart)mimeMessage);
        } else if (part instanceof MemoPartString) {
            MemoPartString partString = (MemoPartString)part;
            try {
                String text = partString.getText();
                if (this.m_historyTopicProcessor.hasTopics()) {
                    text = this.m_historyTopicProcessor.replace(text);
                }
                mimeMessage.setText(text, this.m_MimeTextEncoder.getEncoding());
            }
            catch (MessagingException e) {
                throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setBodyPart(MimePart bp, MemoPart part, String disposition) throws MimeMessageBuilderException {
        String startOfMsgText;
        if (!"inline".equals(disposition) && part.getContentDisposition() != null) {
            disposition = part.getContentDisposition().getValue();
        }
        try {
            bp.setDisposition(disposition);
        }
        catch (MessagingException e) {
            throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
        }
        if (part instanceof MemoPartComposite) {
            MemoPartComposite partComposite = (MemoPartComposite)part;
            MemoPart[] parts = partComposite.getParts();
            String subType = null;
            if (partComposite.getContentType() != null) {
                subType = partComposite.getContentType().getValue();
            }
            String filename = partComposite.getName();
            filename = DLSFileNameUtil.addExtraParamToFilename(filename);
            boolean isMHT = false;
            if (filename != null) {
                isMHT = filename.endsWith(".mht");
            }
            if (subType != null && subType.equals("related") && isMHT) {
                MimeMultipart mp = new MimeMultipart(subType);
                try {
                    for (int i = 0; i < parts.length; ++i) {
                        MimeBodyPart childbp = new MimeBodyPart();
                        this.setBodyPart((MimePart)childbp, parts[i], disposition);
                        this.addBodyPart((Multipart)mp, childbp);
                    }
                    if (filename != null) {
                        bp.setFileName(filename);
                    }
                    MimeMessage mimeMessage = new MimeMessage(this.m_session);
                    mimeMessage.setContent((Multipart)mp);
                    mimeMessage.saveChanges();
                    byte[] bytes = IOUtils.toByteArray((InputStream)mimeMessage.getInputStream());
                    byte[] prefix = ("MIME-Version: 1.0\nContent-Type: " + mp.getContentType() + "\n\n").getBytes();
                    byte[] total = new byte[prefix.length + bytes.length];
                    System.arraycopy(prefix, 0, total, 0, prefix.length);
                    System.arraycopy(bytes, 0, total, prefix.length, bytes.length);
                    NCDataSource ds = DataSourceFactory.getPreZippedDataSource((byte[])total, (String)"text/html", (String)filename);
                    bp.setDataHandler(new DataHandler((DataSource)ds));
                    if (filename == null) return;
                    bp.setFileName(this.encodeMimeText(filename));
                    return;
                }
                catch (MessagingException e) {
                    throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
                }
                catch (IOException e) {
                    throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
                }
            } else {
                MimeMultipart mp = null;
                mp = subType != null ? new MimeMultipart(subType) : new MimeMultipart();
                try {
                    for (int i = 0; i < parts.length; ++i) {
                        MimeBodyPart childbp = new MimeBodyPart();
                        this.setBodyPart((MimePart)childbp, parts[i], disposition);
                        this.addBodyPart((Multipart)mp, childbp);
                    }
                    bp.setContent((Multipart)mp);
                    return;
                }
                catch (MessagingException e) {
                    throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
                }
            }
        }
        if (part instanceof MemoPartMIMEAttachment) {
            this.addMemoPartMIMEAttachment(bp, (MemoPartMIMEAttachment)part);
            return;
        }
        if (part instanceof MemoPartObject) {
            this.addMemoPartObject(bp, (MemoPartObject)part);
            return;
        }
        if (!(part instanceof MemoPartString)) return;
        MemoPartString partString = (MemoPartString)part;
        String text = partString.getText();
        if (this.m_historyTopicProcessor.hasTopics()) {
            text = this.m_historyTopicProcessor.replace(text);
        }
        text = text + " \r\n" + this.m_textURL.toString();
        this.m_textURL = new StringBuffer();
        try {
            ((MimeBodyPart)bp).setText(text, this.m_MimeTextEncoder.getEncoding());
        }
        catch (MessagingException e) {
            throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
        }
        if (text == null || text.trim().length() <= HTML_BODY_IDENTIFIER.length() || !(startOfMsgText = text.trim().substring(0, HTML_BODY_IDENTIFIER.length()).toLowerCase()).startsWith(HTML_BODY_IDENTIFIER)) return;
        try {
            bp.setHeader("Content-Type", "text/html;charset=" + this.m_MimeTextEncoder.getEncoding());
            return;
        }
        catch (MessagingException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{e.getMessage()});
        }
    }

    void addBodyPart(Multipart mp, MimeBodyPart part) throws MessagingException {
        mp.addBodyPart((BodyPart)part);
        if (part.getDisposition() != null && part.getDisposition().equals("inline")) {
            this.m_inline = true;
        }
    }

    private void addMemoPartObjectLinks(MimePart bp) {
        if (!this.m_memoPartString && !this.m_memoPartMIMEAttachment) {
            try {
                bp.setText(this.m_textURL.toString(), this.m_MimeTextEncoder.getEncoding());
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
    }

    private void addMemoPartMIMEAttachment(MimePart bp, MemoPartMIMEAttachment mpma) throws MimeMessageBuilderException {
        try {
            String contentID;
            String contentLocation;
            String name = mpma.getName();
            String encodedName = name = DLSFileNameUtil.addExtraParamToFilename(name);
            if (name != null && name.trim().length() > 0) {
                encodedName = this.encodeMimeText(name);
                bp.setFileName(encodedName);
            }
            if ((contentLocation = mpma.getContentLocation()) != null && !contentLocation.equals("")) {
                bp.setHeader("Content-Location", contentLocation);
            }
            if ((contentID = mpma.getContentID()) != null && !contentID.equals("")) {
                if (!contentID.trim().startsWith("<") || !contentID.trim().endsWith(">")) {
                    contentID = "<" + contentID + ">";
                }
                bp.setHeader("Content-ID", contentID);
            }
            String dataType = mpma.getDataType() != null ? mpma.getDataType() : null;
            boolean isHTML = false;
            if (dataType != null && dataType.indexOf("text/html") != -1) {
                isHTML = true;
            }
            SmtpContentDispositionEnum contentEnum = mpma.getContentDisposition();
            if (isHTML && (this.m_htmlURL.length() != 0 || this.m_historyTopicProcessor.hasTopics()) && SmtpContentDispositionEnum.inline.equals((Object)contentEnum)) {
                String htmlBody = new String(mpma.getData(), this.m_MimeTextEncoder.getEncodingOption());
                if (this.m_historyTopicProcessor.hasTopics()) {
                    htmlBody = this.m_historyTopicProcessor.replace(htmlBody);
                }
                StringBuffer html = new StringBuffer(htmlBody);
                String linkHtml = "<br/>" + this.m_htmlURL.toString();
                String s = htmlBody.toLowerCase();
                if (this.m_htmlURL.length() != 0) {
                    int i = s.indexOf("<body");
                    if (i != -1) {
                        if ((i = s.indexOf("</body>", i)) != -1) {
                            html.insert(i, linkHtml);
                        } else if ((i = s.indexOf("/>", i)) != -1) {
                            html.replace(i, i + 2, ">" + linkHtml + "</body>");
                        }
                    } else {
                        i = s.length() - 1;
                        html.insert(i, linkHtml);
                    }
                    if (i != -1) {
                        this.m_htmlURL = new StringBuffer();
                    }
                }
                bp.setContent((Object)html.toString(), "text/html;charset=\"" + this.m_MimeTextEncoder.getEncoding() + "\"");
            } else {
                if (isHTML && dataType.indexOf("charset") == -1 && SmtpContentDispositionEnum.inline.equals((Object)contentEnum)) {
                    dataType = "text/html;charset=\"" + this.m_MimeTextEncoder.getEncoding() + "\"";
                    String htmlBody = new String(mpma.getData(), this.m_MimeTextEncoder.getEncodingOption());
                    mpma.setData(htmlBody.getBytes(this.m_MimeTextEncoder.getEncoding()));
                }
                NCDataSource ds = null;
                if (bp.getFileName() != null) {
                    ds = DataSourceFactory.getPreZippedDataSource((byte[])mpma.getData(), (String)dataType, (String)name);
                    encodedName = this.encodeMimeText(name);
                    bp.setFileName(encodedName);
                } else {
                    ds = DataSourceFactory.getSimpleDataSource((byte[])mpma.getData(), (String)dataType);
                }
                bp.setDataHandler(new DataHandler((DataSource)ds));
                if (SmtpContentDispositionEnum.attachment.equals((Object)contentEnum)) {
                    bp.setHeader(CONTENT_TRANSFER_ENCODING, BASE64);
                }
            }
        }
        catch (MessagingException e) {
            throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
        }
        catch (IOException e) {
            throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
        }
    }

    private void addMemoPartObject(MimePart bp, MemoPartObject mpo) throws MimeMessageBuilderException {
        if (!this.m_rawFormat) {
            IAttachmentsProcessor processor = AttachmentsProcessorFactory.getInstance();
            String emailEncoding = this.m_session.getProperty("email.encoding");
            processor.processAttachment(bp, mpo, emailEncoding, this.m_eod, this.m_MimeTextEncoder);
            if (null != mpo && null != mpo.getName() && mpo.getName().endsWith("MHT")) {
                try {
                    bp.setHeader(CONTENT_TRANSFER_ENCODING, BASE64);
                    bp.setHeader("Content-Type", "application/octet-stream; charset=UTF-8;");
                }
                catch (MessagingException e) {
                    throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
                }
            }
        }
    }

    private String encodeMimeText(String text) {
        return this.m_MimeTextEncoder.encodeMimeText(text);
    }

    private String throwIncorrectOptionTypeError(Class expected, Object actual) throws MimeMessageBuilderException {
        String expectedClass = expected.getName();
        String actualClass = actual == null ? "null" : actual.getClass().getName();
        String msg = " Expected type was [" + expectedClass + "] but actual type was [" + actualClass + "]";
        throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, new IllegalStateException(msg));
    }

    private boolean isAlwaysUseDefaultSender() {
        boolean alwaysUseDefaultSender = false;
        String alwaysUseDefaultSenderString = null;
        try {
            alwaysUseDefaultSenderString = CRNProperties.getInstance().getProperty("alwaysUseDefaultSender");
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.INFO, I18NCode.MSG_CONFIG_PROPERTY_EXCP, new Object[]{"alwaysUseDefaultSender"});
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
        }
        if (alwaysUseDefaultSenderString != null && alwaysUseDefaultSenderString.equalsIgnoreCase("true")) {
            alwaysUseDefaultSender = true;
        }
        SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DeliveryOptionsToMimeMessageBuilder alwaysUseDefaultSenderString " + alwaysUseDefaultSenderString);
        return alwaysUseDefaultSender;
    }
}

