/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.AddressSMTP;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionAddressSMTPArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionChannel;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionSearchPathMultipleObjectArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionString;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartObjectLinks;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.dls.OptionsValidator;
import com.cognos.dls.api.MemoValidationResult;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.MimeMessageBuilderException;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.util.OptionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.axis.AxisFault;

public class DeliveryOptionsValidator
extends OptionsValidator {
    private Map enumMappings = this.initDeliveryOptionMappings();
    private BiBusHeader m_header;

    public DeliveryOptionsValidator(BiBusHeader header) {
        this.m_header = header;
    }

    @Override
    public void runTimeValidate(Option[] options) throws LocalizableException {
        Option[] deliveryOptions = OptionUtils.findOptionsByType((Option[])options, DeliveryOption.class);
        this.validateOptionClasses(deliveryOptions);
    }

    @Override
    public I18NMessage[] validate(Option[] options) throws LocalizableException {
        I18NMessage[] result = new I18NMessage[]{};
        Option[] deliveryOptions = OptionUtils.findOptionsByType((Option[])options, DeliveryOption.class);
        result = this.validateEmail(deliveryOptions);
        return result;
    }

    public I18NMessage[] validateEmail(Option[] options) {
        ArrayList<I18NMessage> validations = new ArrayList<I18NMessage>();
        try {
            Map optionsMap = this.validateOptionClasses(options);
            this.validateNonEmailOptions(optionsMap);
            validations.addAll(Arrays.asList(this.validateEmail(optionsMap)));
        }
        catch (LocalizableException le) {
            validations.add(new I18NMessage(le));
        }
        catch (AxisFault ex) {
            validations.add(new I18NMessage(DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{ex.getLocalizedMessage()}, SeverityEnum.error));
        }
        return validations.toArray(new I18NMessage[validations.size()]);
    }

    private Map validateOptionClasses(Option[] options) throws LocalizableException {
        HashMap<DeliveryOptionEnum, DeliveryOption> optionMap = new HashMap<DeliveryOptionEnum, DeliveryOption>();
        for (int i = 0; i < options.length; ++i) {
            DeliveryOption adoption = (DeliveryOption)options[i];
            this.checkIsValidOption(adoption);
            optionMap.put(adoption.getName(), adoption);
        }
        return optionMap;
    }

    private I18NMessage[] validateNonEmailOptions(Map adoptionMap) throws AxisFault {
        ArrayList<I18NMessage> validations = new ArrayList<I18NMessage>();
        if (!this.checkNotificationOption((DeliveryOptionSearchPathSingleObject)adoptionMap.get(DeliveryOptionEnum.notificationList))) {
            validations.add(new I18NMessage(DlsI18NCode.MSG_DS_EMPTY_NOTIFICATION, new Object[]{""}, SeverityEnum.warn));
        }
        return validations.toArray(new I18NMessage[validations.size()]);
    }

    private I18NMessage[] validateEmail(Map adoptionMap) throws AxisFault {
        I18NMessage[] bodyMessages;
        boolean has_recipient;
        String title;
        ArrayList<I18NMessage> validations = new ArrayList<I18NMessage>();
        DeliveryOptionString titleOption = (DeliveryOptionString)adoptionMap.get(DeliveryOptionEnum.subject);
        String string = title = titleOption != null ? titleOption.getValue() : null;
        if (title == null || "".equals(title)) {
            validations.add(new I18NMessage(DlsI18NCode.MSG_DS_NO_SUBJECT, new Object[]{""}, SeverityEnum.warn));
        }
        has_recipient = (has_recipient = this.checkRecipientOption((DeliveryOptionAddressSMTPArray)adoptionMap.get(DeliveryOptionEnum.toAddress))) || this.checkRecipientOption((DeliveryOptionAddressSMTPArray)adoptionMap.get(DeliveryOptionEnum.ccAddress));
        has_recipient = has_recipient || this.checkRecipientOption((DeliveryOptionAddressSMTPArray)adoptionMap.get(DeliveryOptionEnum.bccAddress));
        has_recipient = has_recipient || this.checkRecipientOption((DeliveryOptionSearchPathMultipleObjectArray)adoptionMap.get(DeliveryOptionEnum.to));
        has_recipient = has_recipient || this.checkRecipientOption((DeliveryOptionSearchPathMultipleObjectArray)adoptionMap.get(DeliveryOptionEnum.cc));
        has_recipient = has_recipient || this.checkRecipientOption((DeliveryOptionSearchPathMultipleObjectArray)adoptionMap.get(DeliveryOptionEnum.bcc));
        has_recipient = has_recipient || this.checkRecipientDataItemOption((DeliveryOptionAddressSMTPArray)adoptionMap.get(DeliveryOptionEnum.toAddress));
        has_recipient = has_recipient || this.checkRecipientDataItemOption((DeliveryOptionAddressSMTPArray)adoptionMap.get(DeliveryOptionEnum.ccAddress));
        boolean bl = has_recipient = has_recipient || this.checkRecipientDataItemOption((DeliveryOptionAddressSMTPArray)adoptionMap.get(DeliveryOptionEnum.bccAddress));
        if (!has_recipient) {
            validations.add(new I18NMessage(DlsI18NCode.MSG_DS_NO_RECIPIENT, new Object[]{title}, SeverityEnum.error));
        }
        if ((bodyMessages = this.validateBody(adoptionMap)).length > 0) {
            validations.addAll(Arrays.asList(bodyMessages));
        }
        return validations.toArray(new I18NMessage[validations.size()]);
    }

    private I18NMessage[] validateLinks(MemoPartObjectLinks memoLinks) throws AxisFault {
        MemoValidationResult validator = new MemoValidationResult(memoLinks, this.m_header);
        return validator.validate();
    }

    private I18NMessage[] validateBody(Map adoptionMap) throws AxisFault {
        I18NMessage[] result = new I18NMessage[]{};
        DeliveryOptionMemoPart dom = (DeliveryOptionMemoPart)adoptionMap.get(DeliveryOptionEnum.memoPart);
        MemoPart memoPart = dom.getValue();
        if (memoPart instanceof MemoPartComposite) {
            MemoPartComposite composite = (MemoPartComposite)memoPart;
            MemoPart[] mps = composite.getParts();
            for (int counter = 0; counter < mps.length; ++counter) {
                if (!(mps[counter] instanceof MemoPartObjectLinks)) continue;
                result = this.validateLinks((MemoPartObjectLinks)mps[counter]);
            }
        }
        return result;
    }

    private boolean checkRecipientOption(DeliveryOptionAddressSMTPArray option) {
        AddressSMTP[] addresses = option != null && option.getValue() != null ? option.getValue() : new AddressSMTP[]{};
        boolean found_valid_address = false;
        for (int i = 0; i < addresses.length && !found_valid_address; ++i) {
            if (addresses[i].get_value() == null) continue;
            try {
                new InternetAddress(addresses[i].get_value());
                found_valid_address = true;
                continue;
            }
            catch (AddressException addressException) {
                // empty catch block
            }
        }
        return found_valid_address;
    }

    private boolean checkRecipientDataItemOption(DeliveryOptionAddressSMTPArray option) {
        AddressSMTP[] addresses = option != null && option.getValue() != null ? option.getValue() : new AddressSMTP[]{};
        boolean found_valid_address = false;
        for (int i = 0; i < addresses.length && !found_valid_address; ++i) {
            if (addresses[i].get_value() == null) continue;
            try {
                String addrData = addresses[i].get_value();
                if (null == addrData || addrData.length() <= 2 || !addrData.startsWith("[") || !addrData.endsWith("]")) continue;
                found_valid_address = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return found_valid_address;
    }

    private boolean checkRecipientOption(DeliveryOptionSearchPathMultipleObjectArray option) {
        boolean found_valid_address = false;
        SearchPathMultipleObject[] sps = option != null && option.getValue() != null ? option.getValue() : new SearchPathMultipleObject[]{};
        for (int i = 0; i < sps.length && !found_valid_address; ++i) {
            if (sps[i].get_value() == null) continue;
            found_valid_address = true;
        }
        return found_valid_address;
    }

    private boolean checkNotificationOption(DeliveryOptionSearchPathSingleObject option) {
        boolean validSearchPath = true;
        if (option != null) {
            SearchPathSingleObject sps;
            SearchPathSingleObject searchPathSingleObject = sps = option.getValue() != null ? option.getValue() : new SearchPathSingleObject();
            if (sps.get_value() == null) {
                validSearchPath = false;
            }
        }
        return validSearchPath;
    }

    private Map initDeliveryOptionMappings() {
        HashMap enumMappings = new HashMap();
        ArrayList<Class> acceptableClasses = new ArrayList<Class>();
        acceptableClasses.add(DeliveryOptionString.class);
        enumMappings.put(DeliveryOptionEnum.characterSetEncoding, acceptableClasses);
        acceptableClasses = new ArrayList();
        acceptableClasses.add(DeliveryOptionSearchPathMultipleObjectArray.class);
        acceptableClasses.add(DeliveryOptionSearchPathSingleObject.class);
        enumMappings.put(DeliveryOptionEnum.to, acceptableClasses);
        enumMappings.put(DeliveryOptionEnum.cc, acceptableClasses);
        enumMappings.put(DeliveryOptionEnum.bcc, acceptableClasses);
        acceptableClasses = new ArrayList();
        acceptableClasses.add(DeliveryOptionAddressSMTPArray.class);
        enumMappings.put(DeliveryOptionEnum.toAddress, acceptableClasses);
        enumMappings.put(DeliveryOptionEnum.ccAddress, acceptableClasses);
        enumMappings.put(DeliveryOptionEnum.bccAddress, acceptableClasses);
        acceptableClasses = new ArrayList();
        acceptableClasses.add(DeliveryOptionString.class);
        enumMappings.put(DeliveryOptionEnum.subject, acceptableClasses);
        acceptableClasses = new ArrayList();
        acceptableClasses.add(DeliveryOptionChannel.class);
        enumMappings.put(DeliveryOptionEnum.channel, acceptableClasses);
        acceptableClasses = new ArrayList();
        acceptableClasses.add(DeliveryOptionMemoPart.class);
        enumMappings.put(DeliveryOptionEnum.memoPart, acceptableClasses);
        acceptableClasses = new ArrayList();
        acceptableClasses.add(DeliveryOptionSearchPathSingleObject.class);
        enumMappings.put(DeliveryOptionEnum.notificationList, acceptableClasses);
        return enumMappings;
    }

    private void checkIsValidOption(DeliveryOption option) throws MimeMessageBuilderException {
        List validClasses = (List)this.enumMappings.get(option.getName());
        if (!validClasses.contains(option.getClass())) {
            String optionNameValue = option.getName().getValue();
            String validClassesString = this.enumMappings.get(option.getName()).toString();
            throw new MimeMessageBuilderException(DlsI18NCode.MSG_DS_INVALID_DELIVERY_OPTION_ENUM, new Object[]{optionNameValue, validClassesString});
        }
    }
}

