/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.AncestorInfoArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DocumentContent;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.Periodical;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.AbstractMemoObjectbuilder;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.LabelGenerator;
import com.cognos.dls.smtp.MimeMessageBuilderException;
import com.cognos.dls.smtp.MimeTextEncoder;
import com.cognos.dls.smtp.ProcessedLinks;
import com.cognos.dls.smtp.QueryRepliesHandler;
import com.cognos.dls.util.DLSFileNameUtil;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimePart;

public class DocumentContentMemoObjectBuilder
extends AbstractMemoObjectbuilder {
    public DocumentContentMemoObjectBuilder(String emailEncoding, EmailOptionsDeliverable eod, MimeTextEncoder mimeTextEncoder) throws MimeMessageBuilderException {
        super(emailEncoding, eod, mimeTextEncoder);
    }

    @Override
    public ProcessedLinks buildLink(ObjectLink link) throws MimeMessageBuilderException {
        String label = link.getLabel();
        SearchPathSingleObject searchPath = link.getSearchPath();
        String urlID = this.getBuiltSearchPath(searchPath);
        if (null == label || label.length() <= 0) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_LABEL_NOT_AVAILABLE_GENERATING_ONE);
            label = this.buildLinkLabel(searchPath);
        }
        if (label.equals("MHT")) {
            return null;
        }
        ProcessedLinks processedLink = new ProcessedLinks();
        if (urlID.length() > 0) {
            processedLink.appendHtmlUrl("<A href=\"" + this.m_gateway);
            processedLink.appendHtmlUrl("?b_action=cognosViewer&ui.action=view&ui.object=");
            processedLink.appendHtmlUrl(urlID);
            processedLink.appendHtmlUrl(this.m_postfix);
            processedLink.appendHtmlUrl("\">");
            processedLink.appendHtmlUrl(label);
            processedLink.appendHtmlUrl("</A>");
            processedLink.appendHtmlUrl("<br>");
            processedLink.appendTextUrl(label);
            processedLink.appendTextUrl("\n<");
            processedLink.appendTextUrl(this.m_gateway);
            processedLink.appendTextUrl("?b_action=cognosViewer&ui.action=view&ui.object=");
            processedLink.appendTextUrl(urlID);
            processedLink.appendTextUrl(this.m_postfix);
            processedLink.appendTextUrl(">");
            processedLink.appendTextUrl("\n");
        } else {
            processedLink = super.createErrorLinks(link);
        }
        return processedLink;
    }

    @Override
    public MimePart buildAttachment(MimePart bp, MemoPartObject mpo, QueryRepliesHandler replies) throws MimeMessageBuilderException {
        try {
            BaseClass base = replies.getBase();
            DocumentContent documentContent = (DocumentContent)base;
            String filename = mpo.getName();
            if (null != documentContent) {
                byte[] bytes = documentContent.getData().getValue();
                String dataType = documentContent.getDataType().getValue();
                if (filename == null || filename.equals("")) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_LABEL_NOT_AVAILABLE_GENERATING_ONE);
                    LabelGenerator generator = new LabelGenerator(this.m_eod);
                    generator.generateDocumentContentLabel((BaseClass)documentContent, replies.getPeriodical());
                    filename = generator.getAttachmentLabel();
                }
                filename = DLSFileNameUtil.addExtraParamToFilename(filename);
                bp = this.processBytes(bp, bytes, dataType, filename);
                bytes = null;
                documentContent.setData(null);
            } else {
                filename = DLSFileNameUtil.addExtraParamToFilename(filename);
                bp = this.createErrorOutput(bp, replies, filename);
            }
        }
        catch (IOException e) {
            throw new MimeMessageBuilderException(DlsI18NCode.MSG_DS_OUTPUT_ATTACHMENT_ERROR, e);
        }
        catch (ClassCastException e) {
            throw new MimeMessageBuilderException(DlsI18NCode.MSG_DS_OUTPUT_ATTACHMENT_ERROR, e);
        }
        catch (MessagingException e) {
            throw new MimeMessageBuilderException(DlsI18NCode.MSG_DS_OUTPUT_ATTACHMENT_ERROR, e);
        }
        return bp;
    }

    private String buildLinkLabel(SearchPathSingleObject searchPath) {
        String label;
        block3: {
            label = "";
            try {
                BaseClass[] baseClassArray;
                BaseClass documentContentBaseClass = null;
                BaseClass periodicalProducerBaseClass = null;
                QueryReply[] repliesArray = this.getBaseObjects(searchPath);
                Guid periodicalStoreID = null;
                if (repliesArray != null && repliesArray.length == 1 && repliesArray[0] != null && (baseClassArray = repliesArray[0].getQueryResult()) != null && baseClassArray.length == 1) {
                    documentContentBaseClass = baseClassArray[0];
                    periodicalStoreID = DocumentContentMemoObjectBuilder.getPeriodicalGuid(documentContentBaseClass);
                }
                periodicalProducerBaseClass = DocumentContentMemoObjectBuilder.getPeriodicalProducer(this.m_eod.getHeader(), periodicalStoreID);
                LabelGenerator generator = new LabelGenerator(this.m_eod);
                generator.generateDocumentContentLabel(documentContentBaseClass, periodicalProducerBaseClass);
                label = generator.getLinkLabel();
            }
            catch (MimeMessageBuilderException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.INFO, DlsI18NCode.MSG_DS_GENERATING_LABEL_ERROR_WILL_CONTINUE);
                if (!SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).isLoggingAt(SDSLevel.DEBUG)) break block3;
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)((Object)e));
            }
        }
        return label;
    }

    @Override
    protected QueryRequest[] createObjectQueryRequests(String searchPath) {
        PropEnum[] properties = new PropEnum[]{PropEnum.defaultName, PropEnum.burstKey, PropEnum.format, PropEnum.locale, PropEnum.searchPath, PropEnum.ancestors, PropEnum.storeID, PropEnum.objectClass};
        QueryRequest baseRequest = new QueryRequest();
        baseRequest.setSearch(searchPath);
        baseRequest.setProperties(properties);
        return new QueryRequest[]{baseRequest};
    }

    protected String getBuiltSearchPath(SearchPathSingleObject searchPath) {
        String searchPathString = "";
        if (null != searchPath && null != searchPath.get_value()) {
            searchPathString = searchPath.get_value();
        }
        return this.encodeURLText(searchPathString);
    }

    public static Guid getPeriodicalGuid(BaseClass documentContentBaseClass) {
        AncestorInfo[] ancestorInfoArray;
        AncestorInfoArrayProp ancestorInfoArrayProp;
        Guid periodicalStoreID = null;
        if (documentContentBaseClass != null && (ancestorInfoArrayProp = documentContentBaseClass.getAncestors()) != null && (ancestorInfoArray = ancestorInfoArrayProp.getValue()) != null) {
            for (int i = 0; i < ancestorInfoArray.length && periodicalStoreID == null; ++i) {
                AncestorInfo ancestorInfo = ancestorInfoArray[i];
                if (ancestorInfo == null || !ancestorInfo.getObjectClass().getValue().equals("periodical")) continue;
                periodicalStoreID = ancestorInfo.getStoreID();
            }
        }
        return periodicalStoreID;
    }

    public static BaseClass getPeriodicalProducer(BiBusHeader header, Guid periodicalStoreID) throws MimeMessageBuilderException {
        BaseClass[] producerBaseClassArray;
        BaseClassArrayProp baseClassArrayProp;
        BaseClass baseClass;
        BaseClass[] baseClassArray;
        BaseClass periodicalProducerBaseClass = null;
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
        QueryReply[] replies = null;
        QueryOptions options = new QueryOptions();
        RefProp producerRefProps = new RefProp();
        producerRefProps.setRefPropName(PropEnum.producer);
        producerRefProps.setProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.storeID, PropEnum.defaultName, PropEnum.name});
        options.setRefProps(new RefProp[]{producerRefProps});
        QueryRequest request = new QueryRequest();
        request.setProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.storeID, PropEnum.producer});
        request.setSearch("storeID(\"" + periodicalStoreID.get_value() + "\")");
        request.setOptions(options);
        try {
            replies = cmPort.queryMultiple(new QueryRequest[]{request});
        }
        catch (SDKClientException e) {
            throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
        }
        catch (EMFSecurityException e) {
            throw new MimeMessageBuilderException(I18NCode.MSG_CREATE_ERROR, e);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        if (replies != null && replies.length == 1 && replies[0] != null && (baseClassArray = replies[0].getQueryResult()) != null && baseClassArray.length == 1 && (baseClass = baseClassArray[0]) != null && (baseClassArrayProp = ((Periodical)baseClass).getProducer()) != null && (producerBaseClassArray = baseClassArrayProp.getValue()) != null && producerBaseClassArray.length == 1) {
            periodicalProducerBaseClass = producerBaseClassArray[0];
        }
        return periodicalProducerBaseClass;
    }
}

