/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.smtp.DeliveryOptionsToMimeMessageBuilder;
import com.cognos.dls.smtp.IMimeMessageBuilder;
import com.cognos.dls.smtp.ISMTPDeliverable;
import com.cognos.dls.smtp.QueryRepliesHandler;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.UserAccountUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.Message;
import javax.mail.Session;

public class EmailOptionsDeliverable
implements ISMTPDeliverable {
    private BiBusHeader m_header;
    private DeliveryOption[] m_deliveryOptions;
    private Locale m_locale;
    private SearchPathSingleObject m_objectPath;
    private ParameterValue[] m_params;
    private Option[] m_options;
    private Map m_cmEmailAddresses = new HashMap();
    private List<String> m_cmDeviceIds = new ArrayList<String>();
    private String m_cpnsPayload;
    private boolean m_hascpnsPayload;
    private Map<SearchPathSingleObject, QueryRepliesHandler> m_cmMemoPartObjectAttachments = new HashMap<SearchPathSingleObject, QueryRepliesHandler>();
    private MHTHolder m_mthInlineMemoPartObject;
    private StringBuffer m_textURL = new StringBuffer();
    private StringBuffer m_htmlURL = new StringBuffer();
    private boolean m_memoPartString = false;
    private boolean m_emptyBody = false;
    private boolean m_memoPartMIMEAttachment = false;
    private UserAccountUtil m_userAccountUtil;
    private transient IMimeMessageBuilder m_builder;
    private List<MemoPartMIMEAttachment> m_MemoPartMIMEAttachmentList = new ArrayList<MemoPartMIMEAttachment>();

    public EmailOptionsDeliverable() {
    }

    public EmailOptionsDeliverable(BiBusHeader header, DeliveryOption[] deliveryOptions, Option pushoption, Locale locale, SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) {
        this.m_deliveryOptions = deliveryOptions;
        this.m_header = header;
        this.m_locale = locale;
        this.m_objectPath = objectPath;
        this.m_params = parameterValues;
        this.m_options = options;
        UserAccountUtil uau = new UserAccountUtil(new JobBiBusHeaders(header));
        this.setUserAccountInfo(uau);
    }

    public void wasSent(boolean wasSent) {
    }

    public DeliveryOption[] getDeliveryOptions() {
        return this.m_deliveryOptions;
    }

    public BiBusHeader getHeader() {
        return this.m_header;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public SearchPathSingleObject getObjectPath() {
        return this.m_objectPath;
    }

    public ParameterValue[] getParameterValue() {
        return this.m_params;
    }

    public Option[] getOptions() {
        return this.m_options;
    }

    @Override
    public synchronized IMimeMessageBuilder getMimeMessageBuilder(Session session) {
        if (this.m_builder == null) {
            this.m_builder = new DeliveryOptionsToMimeMessageBuilder(session, this);
        }
        return this.m_builder;
    }

    public void addAddresses(Message.RecipientType type, List addresses) {
        List existingAddresses = (List)this.m_cmEmailAddresses.get(type);
        if (existingAddresses != null) {
            existingAddresses.addAll(addresses);
        } else {
            this.m_cmEmailAddresses.put(type, addresses);
        }
    }

    public List getAddresses(Message.RecipientType type) {
        return (List)this.m_cmEmailAddresses.get(type);
    }

    public List<String> getDeviceId() {
        return this.m_cmDeviceIds;
    }

    public void addDeviceIds(List<String> deviceIds) {
        this.m_cmDeviceIds = deviceIds;
    }

    public String getCPNSPayload() {
        return this.m_cpnsPayload;
    }

    public void setCPNSPayload(String payloadJSON) {
        this.m_cpnsPayload = payloadJSON;
        this.m_hascpnsPayload = true;
    }

    public boolean hascpnsPayload() {
        return this.m_hascpnsPayload;
    }

    public void addMemoPartMIMEAttachment(MemoPartMIMEAttachment memoPart) {
        this.m_MemoPartMIMEAttachmentList.add(memoPart);
    }

    public void removeMemoPartMIMEAttachment(MemoPartMIMEAttachment memoPart) {
        this.m_MemoPartMIMEAttachmentList.remove(memoPart);
    }

    public List<MemoPartMIMEAttachment> getMemoPartMIMEAttachments() {
        return this.m_MemoPartMIMEAttachmentList;
    }

    public void addMemoPartObjectAttachments(SearchPathSingleObject searchPath, QueryRepliesHandler replies) {
        this.m_cmMemoPartObjectAttachments.put(searchPath, replies);
    }

    public QueryRepliesHandler getMemoPartObjectAttachments(SearchPathSingleObject searchPath) {
        return this.m_cmMemoPartObjectAttachments.get(searchPath);
    }

    public Map<SearchPathSingleObject, QueryRepliesHandler> getMemoPartObjectAttachments() {
        return this.m_cmMemoPartObjectAttachments;
    }

    public void setInlineMemoPartObject(SearchPathSingleObject searchPath, MemoPart memoPart) {
        this.m_mthInlineMemoPartObject = new MHTHolder(searchPath.get_value(), memoPart);
    }

    public MemoPart getInlineMemoPartObject() {
        return this.m_mthInlineMemoPartObject != null ? this.m_mthInlineMemoPartObject.getMemoPart() : null;
    }

    public String getInlineMemoPartObjectPath() {
        return this.m_mthInlineMemoPartObject != null ? this.m_mthInlineMemoPartObject.getSearchPath() : null;
    }

    public boolean getHasMemoPartString() {
        return this.m_memoPartString;
    }

    public void setHasMemoPartString() {
        this.m_memoPartString = true;
    }

    public boolean getIsMemoPartStringEmpty() {
        return this.m_emptyBody;
    }

    public void setIsMemoPartStringEmpty(boolean isEmpty) {
        this.m_emptyBody = isEmpty;
    }

    public boolean getHasMemoPartMIMEAttachment() {
        return this.m_memoPartMIMEAttachment;
    }

    public void setHasMemoPartMIMEAttachment() {
        this.m_memoPartMIMEAttachment = true;
    }

    public StringBuffer getTextURL() {
        return this.m_textURL;
    }

    public void setTextURL(StringBuffer texturl) {
        this.m_textURL = texturl;
    }

    public StringBuffer getHtmlURL() {
        return this.m_htmlURL;
    }

    public void setHtmlURL(StringBuffer htmlurl) {
        this.m_htmlURL = htmlurl;
    }

    public UserAccountUtil getUserAccountInfo() {
        return this.m_userAccountUtil;
    }

    public void setUserAccountInfo(UserAccountUtil accountInfo) {
        this.m_userAccountUtil = accountInfo;
    }

    public String getNameSpaceId() {
        String result = "";
        if (this.m_userAccountUtil != null) {
            result = this.m_userAccountUtil.getNameSpaceId();
        }
        return result;
    }

    private class MHTHolder
    implements Serializable {
        private String m_searchPath;
        private MemoPart m_memoPart;

        public MHTHolder(String searchPath, MemoPart memoPart) {
            this.m_searchPath = searchPath;
            this.m_memoPart = memoPart;
        }

        public MemoPart getMemoPart() {
            return this.m_memoPart;
        }

        public String getSearchPath() {
            return this.m_searchPath;
        }
    }
}

