/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.AgentState;
import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.AncestorInfoArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BasePowerPlay8Report;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.Document;
import com.cognos.developer.schemas.bibus._3.DocumentContent;
import com.cognos.developer.schemas.bibus._3.LanguageProp;
import com.cognos.developer.schemas.bibus._3.NmtokenArrayProp;
import com.cognos.developer.schemas.bibus._3.NmtokenProp;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PowerPlay8OutputFormatEnumArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.URL;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.QueryRepliesHandler;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelClassEnum;

public class LabelGenerator {
    private EmailOptionsDeliverable m_eod;
    private StringBuffer m_linkLabel = new StringBuffer();
    private StringBuffer m_attachmentLabel = new StringBuffer();

    public LabelGenerator(EmailOptionsDeliverable eod) {
        this.m_eod = eod;
    }

    public String getLinkLabel() {
        return this.m_linkLabel.toString();
    }

    public String getAttachmentLabel() {
        return this.m_attachmentLabel.toString();
    }

    public void generateBaseReportLabel(QueryRepliesHandler handler) {
        BaseClass baseObject = handler.getBase();
        Output output = (Output)handler.getOutput();
        if (null != baseObject) {
            String reportName = this.getBaseReportName(baseObject.getDefaultName());
            UserPreferenceVar[] preferences = this.m_eod.getHeader().getUserPreferenceVars();
            String locale = "";
            String format = "";
            for (int i = 0; i < preferences.length; ++i) {
                String prefName = preferences[i].getName();
                if (null == prefName) continue;
                if (prefName.equals("contentLocale")) {
                    locale = preferences[i].getValue();
                    continue;
                }
                if (!prefName.equals("format")) continue;
                format = preferences[i].getValue() + " ";
            }
            format = this.getDefaultOutputFormat(baseObject) + " ";
            if (null != output) {
                String outputLocale;
                String outputFormat = this.getFormat(output.getFormat());
                if (!outputFormat.equals(format)) {
                    format = outputFormat;
                }
                if (!(outputLocale = this.getLocale(output.getLocale())).equals(locale)) {
                    locale = outputLocale;
                }
            }
            this.m_linkLabel.append(reportName);
            this.m_linkLabel.append(format);
            this.m_linkLabel.append(locale);
            this.m_attachmentLabel.append(reportName);
            this.m_attachmentLabel.append(locale);
            if (format.length() > 0) {
                this.m_attachmentLabel.replace(0, this.m_attachmentLabel.length(), this.m_attachmentLabel.toString().trim());
                this.m_attachmentLabel.append(".");
                this.m_attachmentLabel.append(format.trim());
            }
        }
    }

    public void generateAgentLabel(BaseAgentDefinition agent, Output output) {
        String actualName = "";
        String format = "";
        String locale = "";
        if (null != agent) {
            actualName = this.getBaseReportName(agent.getDefaultName());
        }
        if (null != output) {
            format = this.getFormat(output.getFormat());
            locale = this.getLocale(output.getLocale());
        }
        this.m_linkLabel.append(actualName);
        this.m_linkLabel.append(format);
        this.m_linkLabel.append(locale);
        this.m_attachmentLabel.append(actualName);
        this.m_attachmentLabel.append(locale);
        if (format.length() > 0) {
            this.m_attachmentLabel.replace(0, this.m_attachmentLabel.length(), this.m_attachmentLabel.toString().trim());
            this.m_attachmentLabel.append(".");
            this.m_attachmentLabel.append(format.trim());
        }
    }

    public void generateURLLabel(BaseClass base) {
        if (null != base && base instanceof URL) {
            URL url = (URL)base;
            TokenProp nameProp = url.getDefaultName();
            String name = this.getBaseReportName(nameProp);
            this.m_linkLabel.append(name);
            this.m_attachmentLabel.append(name);
        } else if (null != base && base instanceof Document) {
            Document doc = (Document)base;
            TokenProp nameProp = doc.getDefaultName();
            String name = this.getBaseReportName(nameProp);
            this.m_linkLabel.append(name);
            this.m_attachmentLabel.append(name);
        }
    }

    public void generateOutputLabel(BaseClass output) {
        if (null != output) {
            String actualName = this.getOutputName(output.getAncestors());
            String burst = this.getBurstKey(((Output)output).getBurstKey());
            String format = this.getFormat(((Output)output).getFormat());
            String locale = this.getLocale(((Output)output).getLocale());
            this.m_linkLabel.append(actualName);
            this.m_linkLabel.append(burst);
            this.m_linkLabel.append(format);
            this.m_linkLabel.append(locale);
            this.m_attachmentLabel.append(actualName);
            this.m_attachmentLabel.append(burst);
            this.m_attachmentLabel.append(locale);
            if (format.length() > 0) {
                this.m_attachmentLabel.replace(0, this.m_attachmentLabel.length(), this.m_attachmentLabel.toString().trim());
                this.m_attachmentLabel.append(".");
                this.m_attachmentLabel.append(format.trim());
            }
        }
    }

    public void generateDocumentContentLabel(BaseClass documentContent, BaseClass periodicalProducer) {
        if (null != documentContent && null != periodicalProducer) {
            String actualName = this.getBaseReportName(periodicalProducer.getDefaultName());
            String burst = this.getBurstKey(((DocumentContent)documentContent).getBurstKey());
            String format = this.getFormat(((DocumentContent)documentContent).getFormat());
            String locale = this.getLocale(((DocumentContent)documentContent).getLocale());
            this.m_linkLabel.append(actualName);
            this.m_linkLabel.append(burst);
            this.m_linkLabel.append(format);
            this.m_linkLabel.append(locale);
            this.m_attachmentLabel.append(actualName);
            this.m_attachmentLabel.append(burst);
            this.m_attachmentLabel.append(locale);
            if (format.length() > 0) {
                this.m_attachmentLabel.replace(0, this.m_attachmentLabel.length(), this.m_attachmentLabel.toString().trim());
                this.m_attachmentLabel.append(".");
                this.m_attachmentLabel.append(format.trim());
            }
        }
    }

    private String getDefaultOutputFormat(BaseClass baseObject) {
        BasePowerPlay8Report basePPReport;
        PowerPlay8OutputFormatEnumArrayProp defaultOutputFormat;
        String format = null;
        if (baseObject instanceof BaseReport) {
            BaseReport baseReport = (BaseReport)baseObject;
            NmtokenArrayProp defaultOutputFormat2 = baseReport.getDefaultOutputFormat();
            if (defaultOutputFormat2 != null && defaultOutputFormat2.getValue() != null && defaultOutputFormat2.getValue().length > 0) {
                format = defaultOutputFormat2.getValue()[0];
            }
        } else if (baseObject instanceof BasePowerPlay8Report && (defaultOutputFormat = (basePPReport = (BasePowerPlay8Report)baseObject).getDefaultOutputFormat()) != null && defaultOutputFormat.getValue() != null && defaultOutputFormat.getValue().length > 0) {
            format = defaultOutputFormat.getValue()[0].getValue();
        }
        return format;
    }

    private String getBaseReportName(TokenProp defaultName) {
        String reportName = "";
        if (null != defaultName) {
            reportName = defaultName.getValue() + " ";
        }
        return reportName;
    }

    private String getOutputName(AncestorInfoArrayProp infoProp) {
        String name = "";
        if (null != infoProp) {
            AncestorInfo[] info = infoProp.getValue();
            InfoProcessor infoProcessor = new InfoProcessor(info);
            name = infoProcessor.getName() + " ";
        }
        return name;
    }

    private String getLocale(LanguageProp localeProp) {
        String locale = "";
        if (null != localeProp && null != localeProp.getValue() && localeProp.getValue().length() > 0) {
            locale = localeProp.getValue();
        }
        return locale;
    }

    private String getFormat(NmtokenProp formatToken) {
        String format = "";
        if (null != formatToken && null != formatToken.getValue() && formatToken.getValue().length() > 0) {
            format = formatToken.getValue() + " ";
        }
        return format;
    }

    private String getBurstKey(StringProp burstKey) {
        String value = "";
        if (null != burstKey && null != burstKey.getValue() && burstKey.getValue().length() > 0) {
            value = burstKey.getValue() + " ";
        }
        return value;
    }

    private class InfoProcessor {
        private AncestorInfo[] m_info;
        private AncestorInfo m_thirdAncestor;
        private AncestorInfo m_secondAncestor;
        private ClassEnum m_thirdAncestorType;
        private ClassEnum m_secondAncestorType;

        public InfoProcessor(AncestorInfo[] info) {
            this.m_info = info;
            this.m_thirdAncestor = this.m_info[this.m_info.length - 3];
            this.m_secondAncestor = this.m_info[this.m_info.length - 2];
            this.m_thirdAncestorType = this.m_thirdAncestor.getObjectClass();
            this.m_secondAncestorType = this.m_secondAncestor.getObjectClass();
        }

        private boolean isSession() {
            return ObjectModelClassEnum.SESSION.equals((Object)this.m_thirdAncestorType);
        }

        private boolean isAgentState() {
            return ObjectModelClassEnum.AGENT_STATE.equals((Object)this.m_secondAncestorType);
        }

        private boolean isBaseReport() {
            return ObjectModelClassEnum.REPORT.equals((Object)this.m_secondAncestorType) || ObjectModelClassEnum.REPORT_VIEW.equals((Object)this.m_secondAncestorType) || ObjectModelClassEnum.QUERY.equals((Object)this.m_secondAncestorType) || ObjectModelClassEnum.ANALYSIS.equals((Object)this.m_secondAncestorType);
        }

        private String getSecondAncestorSearchPath() {
            return this.m_secondAncestor.getSearchPath();
        }

        public String getName() {
            String name = "";
            if (this.isSession()) {
                name = this.getSessionBasedName();
            } else if (this.isAgentState()) {
                name = this.getAgentStateBasedName();
            } else if (this.isBaseReport()) {
                name = this.m_secondAncestor.getTitle();
            }
            return name;
        }

        private String getSessionBasedName() {
            String name = "";
            String viewPath = this.getSecondAncestorSearchPath();
            BaseClass baseClass = this.getBaseClass(viewPath, new PropEnum[]{PropEnum.base});
            if (baseClass instanceof ReportView) {
                ReportView view = (ReportView)baseClass;
                BaseClassArrayProp baseProp = view.getBase();
                name = this.getBaseClassName(baseProp);
            }
            return name;
        }

        private String getAgentStateBasedName() {
            String name = "";
            String agentStatePath = this.getSecondAncestorSearchPath();
            BaseClass baseClass = this.getBaseClass(agentStatePath, new PropEnum[]{PropEnum.definition});
            if (baseClass instanceof AgentState) {
                AgentState state = (AgentState)baseClass;
                BaseClassArrayProp baseProp = state.getDefinition();
                name = this.getBaseClassName(baseProp);
            }
            return name;
        }

        private String getBaseClassName(BaseClassArrayProp baseProp) {
            String basePath;
            BaseClass base;
            BaseClass baseClass;
            StringProp stringProp;
            String name = "";
            if (null != baseProp && null != baseProp.getValue() && baseProp.getValue().length == 1 && null != (stringProp = (baseClass = baseProp.getValue()[0]).getSearchPath()) && null != stringProp.getValue() && null != (base = this.getBaseClass(basePath = stringProp.getValue(), new PropEnum[]{PropEnum.defaultName})) && null != base.getDefaultName() && null != base.getDefaultName().getValue()) {
                TokenProp tokenName = base.getDefaultName();
                name = tokenName.getValue();
            }
            return name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BaseClass getBaseClass(String searchPath, PropEnum[] props) {
            BaseClass base = null;
            ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(LabelGenerator.this.m_eod.getHeader()));
            try {
                BaseClass[] baseClasses = cmPort.query(searchPath, props, new Sort[0], new QueryOptions());
                if (baseClasses != null && baseClasses.length == 1) {
                    base = baseClasses[0];
                }
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_GENERATING_LABEL_ERROR_WILL_CONTINUE);
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_GENERATING_LABEL_ERROR_WILL_CONTINUE);
            }
            finally {
                if (cmPort != null) {
                    cmPort.close();
                }
            }
            return base;
        }
    }
}

