/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionString;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import java.io.UnsupportedEncodingException;
import javax.mail.internet.MimeUtility;

public final class MimeTextEncoder {
    private String m_encoding;
    private String m_encodingOption = "UTF-8";

    public MimeTextEncoder(String encoding) {
        this(encoding, null);
    }

    MimeTextEncoder(String encoding, String encodingOption) {
        this.setEncoding(encoding);
        this.setEncodingOption(encodingOption);
    }

    void setEncoding(String encoding) {
        if (encoding != null && encoding.trim().length() > 0) {
            this.m_encoding = encoding;
        }
    }

    String getEncoding() {
        return this.m_encoding;
    }

    void setEncodingOption(String encodingOption) {
        this.m_encodingOption = encodingOption != null && encodingOption.trim().length() > 0 ? encodingOption : "UTF-8";
    }

    String getEncodingOption() {
        return this.m_encodingOption;
    }

    void setEncodingOption(DeliveryOption option) {
        DeliveryOptionString optionString = (DeliveryOptionString)option;
        String value = optionString.getValue();
        this.setEncodingOption(value);
    }

    public String encodeMimeText(String text) {
        if (text == null) {
            return null;
        }
        String encodedText = text;
        if (this.m_encoding != null) {
            try {
                encodedText = MimeUtility.encodeText((String)text, (String)this.m_encoding, null);
            }
            catch (UnsupportedEncodingException ex) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{this.m_encoding});
                encodedText = text;
            }
        } else {
            encodedText = text;
        }
        return encodedText;
    }

    public String encodeMimeSubject(String text) {
        if (text == null) {
            return null;
        }
        String encodedText = text;
        if (this.m_encoding != null) {
            try {
                encodedText = MimeUtility.encodeText((String)text, (String)this.m_encoding, null);
            }
            catch (UnsupportedEncodingException ex) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.WARN, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{this.m_encoding});
                encodedText = text;
            }
        } else {
            encodedText = text;
        }
        return encodedText;
    }
}

