/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.AbstractMemoObjectbuilder;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.LabelGenerator;
import com.cognos.dls.smtp.MimeMessageBuilderException;
import com.cognos.dls.smtp.MimeTextEncoder;
import com.cognos.dls.smtp.ProcessedLinks;
import com.cognos.dls.smtp.QueryRepliesHandler;
import com.cognos.dls.util.DLSFileNameUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimePart;

public class OutputMemoObjectBuilder
extends AbstractMemoObjectbuilder {
    public OutputMemoObjectBuilder(String emailEncoding, EmailOptionsDeliverable eod, MimeTextEncoder mimeTextEncoder) throws MimeMessageBuilderException {
        super(emailEncoding, eod, mimeTextEncoder);
    }

    @Override
    public ProcessedLinks buildLink(ObjectLink link) throws MimeMessageBuilderException {
        if (this.isPowerPlayReport(link.getSearchPath())) {
            return this.buildLinkForOldViewer(link);
        }
        return this.buildLinkForNewViewer(link);
    }

    public ProcessedLinks buildLinkForNewViewer(ObjectLink link) throws MimeMessageBuilderException {
        String label = link.getLabel();
        if (null == label || label.length() <= 0) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_LABEL_NOT_AVAILABLE_GENERATING_ONE);
            label = this.buildLinkLabel(link.getSearchPath());
        }
        if (label.equals("MHT") || label.equals("layoutDataXML")) {
            return null;
        }
        ProcessedLinks processedLink = new ProcessedLinks();
        String outputStoreId = this.getOutputStoreID(link.getSearchPath());
        String reportStoreId = this.getReportStoreID(link.getSearchPath());
        if (!outputStoreId.isEmpty()) {
            processedLink.appendHtmlUrl("<A href=\"" + this.m_gateway);
            processedLink.appendHtmlUrl("?objRef=");
            processedLink.appendHtmlUrl(outputStoreId);
            if (!reportStoreId.isEmpty()) {
                processedLink.appendHtmlUrl("&reportId=");
                processedLink.appendHtmlUrl(reportStoreId);
            }
            processedLink.appendHtmlUrl("\">");
            processedLink.appendHtmlUrl(label);
            processedLink.appendHtmlUrl("</A>");
            processedLink.appendHtmlUrl("<br>");
            processedLink.appendTextUrl(label);
            processedLink.appendTextUrl("\n<");
            processedLink.appendTextUrl(this.m_gateway);
            processedLink.appendTextUrl("?objRef=");
            processedLink.appendTextUrl(outputStoreId);
            if (!reportStoreId.isEmpty()) {
                processedLink.appendTextUrl("&reportId=");
                processedLink.appendTextUrl(reportStoreId);
            }
            processedLink.appendTextUrl(">");
            processedLink.appendTextUrl("\n");
        } else {
            processedLink = super.createErrorLinks(link);
        }
        return processedLink;
    }

    @Override
    public MimePart buildAttachment(MimePart bp, MemoPartObject mpo, QueryRepliesHandler replies) throws MimeMessageBuilderException {
        try {
            BaseClass base = replies.getBase();
            Output output = (Output)base;
            String filename = mpo.getName();
            if (null != output) {
                if (filename == null || filename.equals("")) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_LABEL_NOT_AVAILABLE_GENERATING_ONE);
                    LabelGenerator generator = new LabelGenerator(this.m_eod);
                    generator.generateOutputLabel((BaseClass)output);
                    filename = generator.getAttachmentLabel();
                }
                filename = DLSFileNameUtil.addExtraParamToFilename(filename);
                bp = this.processData(bp, output, filename);
            } else {
                filename = DLSFileNameUtil.addExtraParamToFilename(filename);
                bp = this.createErrorOutput(bp, replies, filename);
            }
        }
        catch (IOException e) {
            throw new MimeMessageBuilderException(DlsI18NCode.MSG_DS_OUTPUT_ATTACHMENT_ERROR, e);
        }
        catch (ClassCastException e) {
            throw new MimeMessageBuilderException(DlsI18NCode.MSG_DS_OUTPUT_ATTACHMENT_ERROR, e);
        }
        catch (MessagingException e) {
            throw new MimeMessageBuilderException(DlsI18NCode.MSG_DS_OUTPUT_ATTACHMENT_ERROR, e);
        }
        return bp;
    }

    private String buildLinkLabel(SearchPathSingleObject searchPath) {
        String label;
        block2: {
            label = "";
            try {
                QueryReply[] repliesArray = this.getBaseObjects(searchPath);
                QueryRepliesHandler replies = new QueryRepliesHandler(repliesArray);
                LabelGenerator generator = new LabelGenerator(this.m_eod);
                generator.generateOutputLabel((BaseClass)((Output)replies.getBase()));
                label = generator.getLinkLabel();
            }
            catch (MimeMessageBuilderException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.INFO, DlsI18NCode.MSG_DS_GENERATING_LABEL_ERROR_WILL_CONTINUE);
                if (!SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).isLoggingAt(SDSLevel.DEBUG)) break block2;
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)((Object)e));
            }
        }
        return label;
    }

    @Override
    protected QueryRequest[] createObjectQueryRequests(String searchPath) {
        PropEnum[] properties = new PropEnum[]{PropEnum.defaultName, PropEnum.burstKey, PropEnum.format, PropEnum.locale, PropEnum.searchPath, PropEnum.ancestors, PropEnum.storeID, PropEnum.objectClass};
        QueryRequest baseRequest = new QueryRequest();
        baseRequest.setSearch(searchPath);
        baseRequest.setProperties(properties);
        return new QueryRequest[]{baseRequest};
    }

    public ProcessedLinks buildLinkForOldViewer(ObjectLink link) throws MimeMessageBuilderException {
        String label = link.getLabel();
        SearchPathSingleObject searchPath = link.getSearchPath();
        String urlID = this.getBuiltSearchPath(searchPath);
        if (null == label || label.length() <= 0) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_LABEL_NOT_AVAILABLE_GENERATING_ONE);
            label = this.buildLinkLabel(searchPath);
        }
        if (label.equals("MHT")) {
            return null;
        }
        ProcessedLinks processedLink = new ProcessedLinks();
        if (urlID.length() > 0) {
            processedLink.appendHtmlUrl("<A href=\"" + this.m_gateway);
            processedLink.appendHtmlUrl("?b_action=cognosViewer&ui.action=view&ui.object=");
            processedLink.appendHtmlUrl(urlID);
            processedLink.appendHtmlUrl(this.m_postfix);
            processedLink.appendHtmlUrl("\">");
            processedLink.appendHtmlUrl(label);
            processedLink.appendHtmlUrl("</A>");
            processedLink.appendHtmlUrl("<br>");
            processedLink.appendTextUrl(label);
            processedLink.appendTextUrl("\n<");
            processedLink.appendTextUrl(this.m_gateway);
            processedLink.appendTextUrl("?b_action=cognosViewer&ui.action=view&ui.object=");
            processedLink.appendTextUrl(urlID);
            processedLink.appendTextUrl(this.m_postfix);
            processedLink.appendTextUrl(">");
            processedLink.appendTextUrl("\n");
        } else {
            processedLink = super.createErrorLinks(link);
        }
        return processedLink;
    }

    protected String getBuiltSearchPath(SearchPathSingleObject searchPath) {
        String searchPathString = "";
        if (null != searchPath && null != searchPath.get_value()) {
            searchPathString = searchPath.get_value();
        }
        return this.encodeURLText(searchPathString);
    }
}

