/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.dls.smtp.WhiteListAddressChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public final class RecipientsHolder {
    private HashMap<Message.RecipientType, ArrayList> m_recipients = new HashMap();

    public RecipientsHolder() {
        ArrayList toArray = new ArrayList();
        ArrayList ccArray = new ArrayList();
        ArrayList bccArray = new ArrayList();
        this.m_recipients.put(Message.RecipientType.TO, toArray);
        this.m_recipients.put(Message.RecipientType.CC, ccArray);
        this.m_recipients.put(Message.RecipientType.BCC, bccArray);
    }

    public void addRecipient(Message.RecipientType type, InternetAddress address) {
        if (type != null && address != null) {
            ArrayList addressList = this.m_recipients.get(type);
            addressList.add(address);
        }
    }

    public void addRecipientArray(Message.RecipientType type, InternetAddress[] address) {
        if (type != null && address != null) {
            ArrayList addressList = this.m_recipients.get(type);
            Collections.addAll(addressList, address);
        }
    }

    public boolean addRecipient(Message.RecipientType type, String address, BiBusHeader bibusHeader) throws AddressException {
        boolean result = false;
        if (type != null && address != null) {
            if (WhiteListAddressChecker.getInstance(bibusHeader).isWhitelistConfigured()) {
                if (WhiteListAddressChecker.getInstance(bibusHeader).hasAllowedDomain(address)) {
                    InternetAddress[] addressArray = InternetAddress.parse((String)address, (boolean)false);
                    this.addRecipientArray(type, addressArray);
                    result = true;
                } else {
                    result = false;
                }
            } else {
                InternetAddress[] addressArray = InternetAddress.parse((String)address, (boolean)false);
                this.addRecipientArray(type, addressArray);
                result = true;
            }
        }
        return result;
    }

    public void setRecipientTypes(MimeMessage mimeMessage, Message.RecipientType type, InternetAddress[] addressArray) throws MessagingException {
        if (addressArray != null && addressArray.length > 0) {
            mimeMessage.addRecipients(type, (Address[])addressArray);
        }
    }

    public void setRecipients(MimeMessage mimeMessage) throws MessagingException {
        ArrayList toList = this.m_recipients.get(Message.RecipientType.TO);
        this.setRecipientTypes(mimeMessage, Message.RecipientType.TO, toList.toArray(new InternetAddress[toList.size()]));
        ArrayList ccList = this.m_recipients.get(Message.RecipientType.CC);
        this.setRecipientTypes(mimeMessage, Message.RecipientType.CC, ccList.toArray(new InternetAddress[ccList.size()]));
        ArrayList bccList = this.m_recipients.get(Message.RecipientType.BCC);
        this.setRecipientTypes(mimeMessage, Message.RecipientType.BCC, bccList.toArray(new InternetAddress[bccList.size()]));
    }

    public String toString() {
        StringBuffer result = new StringBuffer("RecipientsHolder:");
        result.append(this.m_recipients.toString());
        return result.toString();
    }
}

