/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.dls.DLSCategory;
import com.cognos.dls.cpns.MobilePushConnector;
import com.cognos.dls.cpns.message.CPNSMessage;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.IMimeMessageBuilder;
import com.cognos.dls.smtp.ISMTPDeliverable;
import com.cognos.dls.smtp.MailPacket;
import com.cognos.dls.smtp.SMTPDispatcher;
import com.cognos.dls.smtp.SMTPPropertiesFactory;
import com.cognos.dls.smtp.transport.ConnectionPoolFactory;
import com.cognos.dls.smtp.transport.IConnectionPool;
import com.cognos.dls.smtp.transport.TransportConnectionFactory;
import com.cognos.dls.smtp.transport.TransportException;
import com.cognos.dls.smtp.transport.TransportSendNoMessagesException;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jms.AbstractDeliveryChannel;
import com.cognos.jsmcommon.jms.ChannelStatus;
import com.cognos.jsmcommon.jms.ChannelType;
import com.cognos.jsmcommon.jms.IDeliverable;
import com.cognos.jsmcommon.jms.event.DeliverEventType;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.mailUtils.MailUtil;
import com.cognos.jsmcommon.property.CRNProperties;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;

public final class SMTPDeliveryChannel
extends AbstractDeliveryChannel
implements TransportConnectionFactory {
    static Properties m_properties;
    private SMTPDispatcher m_dispatcher;
    private IConnectionPool m_transportPool;

    public SMTPDeliveryChannel(SMTPDispatcher dispatcher) {
        this.m_dispatcher = dispatcher;
        this.m_transportPool = ConnectionPoolFactory.createConnectionPool(this);
    }

    public ChannelType getType() {
        return ChannelType.EMAIL_DELIVERY_CHANNEL;
    }

    public void dispatch(IDeliverable deliverable) throws LocalizableException {
        this.dispatch(deliverable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(IDeliverable deliverable, boolean isResend) throws LocalizableException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)DLSCategory.PERF).start(this.getClass(), SDSLevel.ERROR, "CALL", "asynchronous dispatch");
        Transport transport = null;
        try {
            MimeMessage[] mimeMessages = this.getMimeMessages(deliverable, this.getSession());
            CPNSMessage[] cpnsMessages = this.getCPNSMessages(deliverable, this.getSession());
            if (null != cpnsMessages && cpnsMessages.length > 0) {
                CPNSMessage message = cpnsMessages[0];
                if (message.getTargetDeviceIds().size() > 0) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("CPNSMessage is found so calling push connector.");
                    MobilePushConnector mpc = new MobilePushConnector();
                    mpc.sendRequest(message);
                } else {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("No target device ids were found to send push notifications");
                }
            } else {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("No CPNSMessage found so not calling push connector.");
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPDeliveryChannel.dispatch EMail Message.");
                if (mimeMessages != null) {
                    transport = this.m_transportPool.getTransport();
                    MailPacket mp = new MailPacket(deliverable, this.getSession(), this.getListener(), mimeMessages);
                    this.m_dispatcher.dispatch(mp, transport);
                } else {
                    throw new TransportSendNoMessagesException(DlsI18NCode.MSG_DS_GENERAL_ERROR, new String[]{"SMTPDeliveryChannel.dispatchFailMessage() No messages to send"});
                }
            }
            this.m_transportPool.returnTransport(transport);
        }
        catch (Throwable throwable) {
            this.m_transportPool.returnTransport(transport);
            perf.stop();
            throw throwable;
        }
        perf.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchFailMessage(IDeliverable deliverable, TransportException te) throws LocalizableException {
        block4: {
            PerfLog perf = SDSLogger.getLogger((SDSCategory)DLSCategory.PERF).start(this.getClass(), SDSLevel.ERROR, "CALL", "asynchronous dispatch");
            Transport transport = null;
            try {
                transport = this.m_transportPool.getTransport();
                MimeMessage mimeMessage = this.getFailMimeMessages(deliverable, te, this.getSession());
                if (mimeMessage != null) {
                    MailPacket mp = new MailPacket(deliverable, this.getSession(), this.getListener(), new MimeMessage[]{mimeMessage});
                    this.m_dispatcher.dispatch(mp, transport);
                    break block4;
                }
                throw new TransportSendNoMessagesException(DlsI18NCode.MSG_DS_GENERAL_ERROR, new String[]{"SMTPDeliveryChannel.dispatchFailMessage() No messages to send"});
            }
            finally {
                this.m_transportPool.returnTransport(transport);
                perf.stop();
            }
        }
    }

    private CPNSMessage[] getCPNSMessages(IDeliverable deliverable, Session session) {
        boolean pushNotificationEnabled = CRNProperties.getInstance().getBoolAdvancedPropertyValue("emf.mail.pushnotification.enabled", true);
        if (!pushNotificationEnabled) {
            return null;
        }
        IMimeMessageBuilder builder = ((ISMTPDeliverable)deliverable).getMimeMessageBuilder(session);
        CPNSMessage[] cpnsMessages = null;
        try {
            cpnsMessages = builder.getCPNSMessage();
        }
        catch (Throwable e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(e);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
            this.fireChannelEvent(DeliverEventType.MESSAGE_CORRUPTED, deliverable);
        }
        return cpnsMessages;
    }

    private MimeMessage[] getMimeMessages(IDeliverable deliverable, Session session) {
        IMimeMessageBuilder builder = ((ISMTPDeliverable)deliverable).getMimeMessageBuilder(session);
        MimeMessage[] mimeMessages = null;
        try {
            mimeMessages = builder.getMimeMessages();
        }
        catch (Throwable e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(e);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
            this.fireChannelEvent(DeliverEventType.MESSAGE_CORRUPTED, deliverable);
        }
        return mimeMessages;
    }

    private MimeMessage getFailMimeMessages(IDeliverable deliverable, TransportException te, Session session) {
        IMimeMessageBuilder builder = ((ISMTPDeliverable)deliverable).getMimeMessageBuilder(session);
        MimeMessage mimeMessage = null;
        try {
            mimeMessage = builder.getFailMimeMessage(te);
        }
        catch (Throwable e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(e);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
            this.fireChannelEvent(DeliverEventType.MESSAGE_CORRUPTED, deliverable);
        }
        return mimeMessage;
    }

    public static void resetProperties() {
        m_properties = null;
    }

    public synchronized Session getSession() {
        Session mailSession = null;
        final String userName = this.getProperties().getProperty("mail.smtp.user");
        final String userPassword = this.getProperties().getProperty("mail.smtp.password");
        if (null != userName && null != userPassword) {
            Authenticator auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(userName, userPassword);
                }
            };
            mailSession = Session.getInstance((Properties)this.getProperties(), (Authenticator)auth);
        } else {
            mailSession = Session.getDefaultInstance((Properties)this.getProperties());
        }
        return mailSession;
    }

    public ChannelStatus isChannelAvailable() {
        ChannelStatus cs = new ChannelStatus();
        try {
            Transport transport = this.m_transportPool.getTransport();
            if (transport != null && transport.isConnected()) {
                this.m_transportPool.returnTransport(transport);
                cs.setStatus(true);
                return cs;
            }
        }
        catch (LocalizableException e) {
            cs.setException((Exception)((Object)e));
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
        }
        return cs;
    }

    @Override
    public Transport getTransport() throws NoSuchProviderException {
        int port = Integer.parseInt(this.getProperties().getProperty("mail.smtp.port"));
        String userName = this.getProperties().getProperty("mail.smtp.user");
        String pwd = this.getProperties().getProperty("mail.smtp.password");
        if (userName != null) {
            String string = userName = userName.length() == 0 ? null : userName;
        }
        if (pwd != null) {
            pwd = pwd.length() == 0 ? null : pwd;
        }
        return this.getSession().getTransport(new URLName(MailUtil.getMailProtocol(), this.getProperties().getProperty("mail.smtp.host"), port, null, userName, pwd));
    }

    private Properties getProperties() {
        if (m_properties == null) {
            m_properties = SMTPPropertiesFactory.getProperties();
        }
        return m_properties;
    }
}

