/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.GenericOptionString;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.DLSVersionInfo;
import com.cognos.dls.api.DeliveryServiceHandlerException;
import com.cognos.dls.smtp.CMObjectPreprocessor;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.SMTPPropertiesFactory;
import com.cognos.dls.util.CPNSDeviceInfoQuery;
import com.cognos.dls.util.PinboardClient;
import com.cognos.jsmcommon.audit.CommonServiceLogUtil;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jms.IDeliverable;
import com.cognos.jsmcommon.jms.client.BiBusMonitorUtil;
import com.cognos.jsmcommon.jms.client.JMSConnection;
import com.cognos.jsmcommon.jms.resource.JMSProperties;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.CredentialUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import com.ibm.cognos.jsmcommon.jms.ObjectMessage;
import com.ibm.cognos.jsmcommon.jms.Queue;
import com.ibm.cognos.jsmcommon.jms.QueueSender;
import com.ibm.cognos.jsmcommon.jms.QueueSession;
import com.ibm.json.java.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.naming.NamingException;

public class SMTPDeliveryService {
    private static SMTPDeliveryService m_instance = new SMTPDeliveryService();
    private CommonServiceLogUtil mCommonServiceLogUtil = null;
    private static final String PUSH_NOTIFICATION_ADDITIONAL_DATA = "pushNotificationAdditionalData";
    private String category = "Audit.RTUsage.DLS";
    private JMSConnection m_connection;
    private QueueSender m_sender;
    private QueueSession m_session;
    private Queue m_queue;
    private int m_counter = 1;

    private SMTPDeliveryService() {
        try {
            this.m_connection = new JMSConnection();
            this.m_session = this.m_connection.getConnection().createQueueSession(false, 2);
            this.m_queue = this.m_session.createQueue(JMSProperties.getInstance().getProperty(JMSProperties.EMAIL_QUEUE_NAME));
            this.m_sender = this.m_session.createSender(this.m_queue);
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(e.getMessage());
        }
        catch (NamingException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(e.getMessage());
        }
        catch (JMSException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(e.getMessage());
        }
    }

    public static SMTPDeliveryService getInstance() {
        return m_instance;
    }

    private void addAddressesForPushPayload(BiBusHeader header, EmailOptionsDeliverable eod, String payloadJSON) throws Exception {
        JSONObject payload = JSONObject.parse((String)payloadJSON);
        String pinboardId = (String)payload.get((Object)"pinboardId");
        ArrayList<String> mobileDeviceSearchPaths = PinboardClient.getMobileDeviceSearchPathForSubscribers(header, pinboardId);
        CPNSDeviceInfoQuery cpnsDeviceInfoQuery = new CPNSDeviceInfoQuery();
        List<String> cpnsDeviceIdList = cpnsDeviceInfoQuery.makeCMQueryForDeviceInfo(header, mobileDeviceSearchPaths);
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("CMEmailRetriever from CM got cpnsDeviceIdList size is:" + cpnsDeviceIdList.size() + ", and list contains:" + cpnsDeviceIdList);
        eod.addDeviceIds(cpnsDeviceIdList);
    }

    public void emailDelivery(BiBusHeader header, DeliveryOption[] deliveryOption, Option pushoption, Locale locale, SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) throws LocalizableException {
        EmailOptionsDeliverable eod;
        block5: {
            eod = new EmailOptionsDeliverable(header, deliveryOption, pushoption, locale, objectPath, parameterValues, options);
            String emailEncoding = SMTPPropertiesFactory.getProperties().getProperty("email.encoding");
            if (pushoption != null) {
                try {
                    GenericOptionString gos = (GenericOptionString)pushoption;
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("CMObjectPreprocessor looking for GenericOptionString:pushNotificationAdditionalData");
                    String optionName = gos.getName();
                    if (null == optionName || !optionName.equals(PUSH_NOTIFICATION_ADDITIONAL_DATA)) break block5;
                    String payloadJSON = gos.getValue();
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("CMObjectPreprocessor: found pushNotificationAdditionalData value:" + payloadJSON);
                    if (null != payloadJSON && payloadJSON.length() > 0) {
                        eod.setCPNSPayload(payloadJSON);
                        this.addAddressesForPushPayload(header, eod, payloadJSON);
                    }
                }
                catch (Exception ex) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPDeliveryService: found pushNotificationAdditionalData read error " + ex.getMessage());
                }
            } else {
                CMObjectPreprocessor cmOpp = new CMObjectPreprocessor(eod, emailEncoding);
                cmOpp.retrieve((Option[])deliveryOption, header);
            }
        }
        this.queueDeliverable(eod);
    }

    public void emailDelivery(BiBusHeader header, String obj, DeliveryOption[] options) {
    }

    private void queueDeliverable(IDeliverable message) throws DeliveryServiceHandlerException {
        String messageId = null;
        try {
            EmailOptionsDeliverable email_opt = (EmailOptionsDeliverable)message;
            ParameterValue[] m_params = email_opt.getParameterValue();
            Option[] m_options = email_opt.getOptions();
            BiBusHeader m_header = email_opt.getHeader();
            String eventID = OptionUtils.extractEventIDfromOptions((Option[])m_options);
            if (eventID != null) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPDeliveryService.queueDeliverable with EventId: " + eventID);
            } else {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPDeliveryService.queueDeliverable - without runContext option");
            }
            messageId = this.m_queue.getQueueName() + "_options_" + this.m_counter++;
            if (this.m_counter >= Integer.MAX_VALUE) {
                this.m_counter = 0;
            }
            ObjectMessage om = this.m_session.createObjectMessage();
            om.setObject((Serializable)message);
            om.setJMSMessageID(messageId);
            if (m_header != null && eventID != null) {
                JobBiBusHeaders headers = new JobBiBusHeaders(m_header);
                String credentials = headers.getCamCredential();
                String locale = headers.getUserPreferenceProductLocale();
                if (credentials == null) {
                    credentials = CredentialUtil.getUserCredentialPath((BiBusHeader)m_header);
                }
                if (credentials == null) {
                    credentials = "";
                }
                String passport = headers.getPassport();
                om.setStringProperty("eventID", eventID);
                om.setStringProperty("credentialPath", credentials);
                om.setStringProperty("passport", passport);
                om.setStringProperty("productLocale", locale);
                int eventID_index = BiBusMonitorUtil.callMonitorServiceAddDependentMsg((BiBusHeader)m_header, (String)locale, (I18NCode)I18NCode.MSG_WAITING_ON_EMAIL, (String)eventID);
                om.setIntProperty("eventID_index_for_future_use", eventID_index);
            } else if (m_header == null) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPDeliveryService.queueDeliverable: header is null");
            }
            this.m_sender.send((Message)om);
            this.commonServiceLogUtil(message).logMessageSubmit(m_params, m_options, "");
        }
        catch (JMSException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{e.getMessage()});
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_UNABLE_QUEUE_MESSAGE, (Object[])new String[]{messageId});
            throw new DeliveryServiceHandlerException(I18NCode.MSG_UNABLE_QUEUE_MESSAGE);
        }
    }

    protected CommonServiceLogUtil commonServiceLogUtil(IDeliverable message) {
        EmailOptionsDeliverable email_opt = (EmailOptionsDeliverable)message;
        BiBusHeader m_headers = email_opt.getHeader();
        SearchPathSingleObject m_objectPath = email_opt.getObjectPath();
        if (null == this.mCommonServiceLogUtil) {
            this.mCommonServiceLogUtil = CommonServiceLogUtil.getLogUtil((String)this.category, (Integer)DLSVersionInfo.getBuild());
        }
        this.mCommonServiceLogUtil.setTrackingInfo(m_headers);
        this.mCommonServiceLogUtil.setUserName(email_opt.getUserAccountInfo().getUserName());
        this.mCommonServiceLogUtil.setObjectPath(m_objectPath == null ? "null" : m_objectPath.get_value());
        return this.mCommonServiceLogUtil;
    }
}

