/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.AddressSMTP;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionAddressSMTPArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.DLSVersionInfo;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.MailPacket;
import com.cognos.dls.smtp.MalformedAddressException;
import com.cognos.dls.smtp.transport.TransportSendException;
import com.cognos.dls.smtp.transport.TransportSendNoMessagesException;
import com.cognos.dls.smtp.transport.TransportSendNoRecipientsException;
import com.cognos.jsmcommon.audit.CommonServiceLogUtil;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jms.IDeliveryChannel;
import com.cognos.jsmcommon.jms.client.BiBusMonitorUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.OptionUtils;
import com.sun.mail.smtp.SMTPMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import org.apache.commons.io.output.CountingOutputStream;

public class SMTPDispatcher {
    CommonServiceLogUtil mCommonServiceLogUtil;
    final String category = "Audit.RTUsage.DLS";
    final int DEFAULT_EMAIL_LIMIT = 500;
    IDeliveryChannel channel;
    static final ConcurrentHashMap<String, Integer> emailSenderMap = new ConcurrentHashMap();

    public SMTPDispatcher() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleAtFixedRate(new ResetTask(emailSenderMap), 0L, 120L, TimeUnit.SECONDS);
    }

    public void dispatch(MailPacket mp, Transport transport) throws LocalizableException {
        this.send(mp, transport);
    }

    public void setChannel(IDeliveryChannel c) {
        this.channel = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void send(MailPacket packet, Transport transport) throws LocalizableException {
        block39: {
            session_count = this.channel.getSessionCount();
            senderAddress = "";
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.DEBUG, I18NCode.MSG_SMTP_SERVER_SESSION_STARTED, new Object[]{new Integer(session_count), packet.session.getProperties().getProperty("mail.smtp.host"), packet.session});
            if (packet.mimeMessages == null || packet.mimeMessages.length == 0) {
                throw new TransportSendNoMessagesException(DlsI18NCode.MSG_DS_GENERAL_ERROR, new String[]{"SMTPDispatcher.send() No messages to send"});
            }
            if (packet.mimeMessages.length > 1) {
                throw new IllegalStateException("SMTPDispatcher.send() only supports delivery on one mimeMessage, but requested to send " + packet.mimeMessages.length);
            }
            eventID = OptionUtils.extractEventIDfromOptions((Option[])packet.options);
            locale = ((EmailOptionsDeliverable)packet.deliverable).getLocale();
            limitPerEmailSender = CRNProperties.getInstance().getProperty("limit.per.email.sender");
            limitEmail = 500;
            if (limitPerEmailSender != null) {
                limitEmail = Integer.valueOf(limitPerEmailSender);
            }
            if (!SMTPDispatcher.emailSenderMap.containsKey(senderAddress = packet.mimeMessages[0].getSender().toString())) ** GOTO lbl29
            value = SMTPDispatcher.emailSenderMap.get(senderAddress);
            if (value < limitEmail) {
                SMTPDispatcher.emailSenderMap.put(senderAddress, value + 1);
                break block39;
            }
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("The sender[" + senderAddress + "] reaches limit[" + limitEmail + "].");
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.DEBUG, I18NCode.MSG_SMTP_SERVER_SESSION_COMPLETED, (Object[])new String[]{String.valueOf(session_count)});
            return;
        }
        try {
            block40: {
                break block40;
lbl29:
                // 1 sources

                SMTPDispatcher.emailSenderMap.putIfAbsent(senderAddress, 1);
                {
                    catch (MessagingException e) {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{e.getMessage()});
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
                        break block40;
                    }
                    catch (Exception e) {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)e);
                    }
                }
            }
            recips = null;
            try {
                recips = packet.mimeMessages[0].getAllRecipients();
            }
            catch (MessagingException mse) {
                detail = "";
                if (mse instanceof AddressException) {
                    detail = ((AddressException)mse).getRef();
                } else {
                    cause = mse.getCause();
                    if (cause != null) {
                        detail = cause.getMessage();
                    }
                }
                detailedMessage = mse.getLocalizedMessage();
                if (detail.length() > 0) {
                    detailedMessage = detailedMessage + " - '" + detail + "'";
                }
                this.logError(I18NCode.MSG_SMTP_MSG_ADDRESS_INVALID, new String[]{detailedMessage}, eventID);
                throw new MalformedAddressException(I18NCode.MSG_SMTP_MSG_ADDRESS_INVALID, new String[]{detailedMessage});
            }
            if (recips == null || recips.length == 0) {
                this.logError(I18NCode.MSG_NO_VALID_RECIPIENTS, null, eventID);
                this.commonServiceLogUtil(packet).logDLSError(I18NUtil.getMessage((I18NCode)I18NCode.MSG_NO_VALID_RECIPIENTS, (Locale)locale));
                throw new TransportSendNoRecipientsException(I18NCode.MSG_NO_VALID_RECIPIENTS);
            }
            try {
                smtpMsg = new SMTPMessage(packet.mimeMessages[0]);
                smtpMsg.setSendPartial(true);
                smtpMsg.saveChanges();
                messageId = smtpMsg.getMessageID();
                ipfLogEmailRecipientToOnly = this.getProperty("dls.ipf.log.email.recipient.to.only", false);
                if (!ipfLogEmailRecipientToOnly) {
                    try {
                        doasa = null;
                        if (recips != null && recips.length > 0) {
                            doasa = new DeliveryOptionAddressSMTPArray();
                            doasa.setName(DeliveryOptionEnum.toAddress);
                            a1 = null;
                            arrayList = new ArrayList<AddressSMTP>();
                            for (recipientCnt = 0; recipientCnt < recips.length; ++recipientCnt) {
                                a1 = new AddressSMTP(recips[recipientCnt].toString());
                                arrayList.add(a1);
                            }
                            doasa.setValue(arrayList.toArray(new AddressSMTP[arrayList.size()]));
                        }
                        this.commonServiceLogUtil(packet).logMessageSubmit(packet.params, OptionUtils.mergeOptions((Option[])OptionUtils.mergeOptions((Option[])packet.options, (Option[])packet.deliveryOptions), (Option[])new DeliveryOptionAddressSMTPArray[]{doasa}), messageId);
                    }
                    catch (Exception ex) {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("ERROR logging email delivery details to the IPF tables: " + ex.toString());
                    }
                } else {
                    this.commonServiceLogUtil(packet).logMessageSubmit(packet.params, OptionUtils.mergeOptions((Option[])packet.options, (Option[])packet.deliveryOptions), messageId);
                }
                try {
                    smtpMsg.setSentDate(new Date());
                    transport.sendMessage((Message)smtpMsg, smtpMsg.getAllRecipients());
                }
                catch (Error e1) {
                    transport.sendMessage((Message)smtpMsg, smtpMsg.getAllRecipients());
                }
                recipients = Integer.toString(smtpMsg.getAllRecipients().length);
                msg = I18NUtil.getMessage((I18NCode)I18NCode.MSG_EMAIL_DELIVERED, (Object[])new Object[]{recipients}, (Locale)locale);
                BiBusMonitorUtil.callMonitorServiceAddInfoMsg((String)msg, (String)eventID);
            }
            catch (SendFailedException sfe) {
                os = new ByteArrayOutputStream();
                ctr = new CountingOutputStream((OutputStream)os);
                try {
                    packet.mimeMessages[0].writeTo((OutputStream)ctr);
                }
                catch (IOException recipients) {
                }
                catch (MessagingException recipients) {
                    // empty catch block
                }
                theMessageSize = this.getMessageSize(ctr.getByteCount());
                valids = sfe.getValidSentAddresses();
                if (valids != null) {
                    recipients = Integer.toString(valids.length);
                    msg = I18NUtil.getMessage((I18NCode)I18NCode.MSG_EMAIL_DELIVERED, (Object[])new Object[]{recipients}, (Locale)locale);
                    BiBusMonitorUtil.callMonitorServiceAddInfoMsg((String)msg, (String)eventID);
                }
                msg = I18NUtil.getMessage((I18NCode)I18NCode.MSG_EMAIL_NOT_DELIVERED, (Object[])new Object[]{theMessageSize, sfe.getLocalizedMessage()}, (Locale)locale);
                BiBusMonitorUtil.callMonitorServiceAddErrorMsg((String)msg, (String)eventID);
                invalids = sfe.getInvalidAddresses();
                if (invalids != null && invalids.length > 0) {
                    msgs = new String[invalids.length];
                    for (k = 0; k < invalids.length; ++k) {
                        msgs[k] = I18NUtil.getMessage((I18NCode)I18NCode.MSG_UNABLE_TO_SEND_MESSAGE_TO_EMAILADDRESS, (Object[])new String[]{invalids[k].toString()}, (Locale)locale);
                    }
                    BiBusMonitorUtil.callMonitorServiceAddErrorMsgs((String[])msgs, (String)eventID);
                    throw new TransportSendNoRecipientsException(I18NCode.MSG_GENERAL_SEND_SMTP_FAIL, (Object[])new String[]{sfe.getLocalizedMessage()}, sfe);
                }
                this.processException(packet, (Exception)sfe, eventID);
                throw new TransportSendException(I18NCode.MSG_GENERAL_SEND_SMTP_FAIL, (Object[])new String[]{sfe.getLocalizedMessage()}, sfe);
            }
            catch (MessagingException e) {
                os = new ByteArrayOutputStream();
                ctr = new CountingOutputStream((OutputStream)os);
                try {
                    packet.mimeMessages[0].writeTo((OutputStream)ctr);
                }
                catch (IOException theMessageSize) {
                }
                catch (MessagingException theMessageSize) {
                    // empty catch block
                }
                theMessageSize = this.getMessageSize(ctr.getByteCount());
                msg = I18NUtil.getMessage((I18NCode)I18NCode.MSG_EMAIL_NOT_DELIVERED, (Object[])new Object[]{theMessageSize, e.getLocalizedMessage()}, (Locale)locale);
                BiBusMonitorUtil.callMonitorServiceAddErrorMsg((String)msg, (String)eventID);
                this.processException(packet, (Exception)e, eventID);
                this.debugLogStackTrace(e);
                if (e.getNextException() != null) {
                    this.debugLogStackTrace(e.getNextException());
                }
                throw new TransportSendException(I18NCode.MSG_GENERAL_SEND_SMTP_FAIL, (Object[])new String[]{e.getLocalizedMessage()}, e);
            }
        }
        catch (Throwable var17_38) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.DEBUG, I18NCode.MSG_SMTP_SERVER_SESSION_COMPLETED, (Object[])new String[]{String.valueOf(session_count)});
            throw var17_38;
        }
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.DEBUG, I18NCode.MSG_SMTP_SERVER_SESSION_COMPLETED, (Object[])new String[]{String.valueOf(session_count)});
    }

    private boolean getProperty(String propName, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            String property = CRNProperties.getInstance().getProperty(propName);
            if (property != null) {
                result = Boolean.valueOf(property);
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.WARN, (LocalizableException)((Object)ex));
        }
        catch (Throwable t) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.WARN, t);
        }
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPDispatcher " + propName + "=" + result);
        return result;
    }

    private void debugLogStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        pw.close();
        String trace1 = sw.toString();
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPDispatcher Exception[" + e.getClass().getName() + "] " + trace1);
    }

    protected CommonServiceLogUtil commonServiceLogUtil(MailPacket packet) {
        if (null == this.mCommonServiceLogUtil) {
            this.mCommonServiceLogUtil = CommonServiceLogUtil.getLogUtil((String)"Audit.RTUsage.DLS", (Integer)DLSVersionInfo.getBuild());
        }
        try {
            this.mCommonServiceLogUtil.setObjectPath(this.getSearchPath(packet));
            this.mCommonServiceLogUtil.setTrackingInfo(packet.headers);
            EmailOptionsDeliverable eod = (EmailOptionsDeliverable)packet.deliverable;
            this.mCommonServiceLogUtil.setUserName(eod.getUserAccountInfo().getUserName());
        }
        catch (NullPointerException e) {
            this.mCommonServiceLogUtil.logDLSDebug("headers are null in SMTP dispatcher");
        }
        return this.mCommonServiceLogUtil;
    }

    private String getSearchPath(MailPacket packet) {
        return packet.objectPath == null ? null : packet.objectPath.get_value();
    }

    private void processException(MailPacket packet, Exception e, String eventID) {
        while (e != null) {
            if (e instanceof AuthenticationFailedException) {
                this.logError(I18NCode.MSG_AUTHENTICATION_ERROR_IN_THE_MAIL_DISPATCHER, null, eventID);
                this.commonServiceLogUtil(packet).logDLSError(I18NUtil.getMessage((I18NCode)I18NCode.MSG_AUTHENTICATION_ERROR_IN_THE_MAIL_DISPATCHER, (Locale)SDSLogger.getLocale()));
            } else if (e instanceof UnknownHostException) {
                this.logError(I18NCode.MSG_UNKNOWN_MAIL_SERVER_HOST, new String[]{packet.session.getProperties().getProperty("mail.smtp.host")}, eventID);
                this.commonServiceLogUtil(packet).logDLSError(I18NUtil.getMessage((I18NCode)I18NCode.MSG_UNKNOWN_MAIL_SERVER_HOST, (Object[])new String[]{packet.session.getProperties().getProperty("mail.smtp.host")}, (Locale)SDSLogger.getLocale()));
            } else if (e instanceof ConnectException) {
                String host = packet.session.getProperties().getProperty("mail.smtp.host");
                String port = packet.session.getProperties().getProperty("mail.smtp.port");
                this.logError(I18NCode.MSG_COULD_NOT_CONNECT_TO_MAIL_SERVER, new String[]{host, port}, eventID);
                this.commonServiceLogUtil(packet).logDLSError(I18NUtil.getMessage((I18NCode)I18NCode.MSG_COULD_NOT_CONNECT_TO_MAIL_SERVER, (Object[])new String[]{host, port}, (Locale)SDSLogger.getLocale()));
            } else {
                this.logError(I18NCode.MSG_GENERAL_SEND_SMTP_FAIL, new String[]{e.getMessage() + ""}, eventID);
                this.commonServiceLogUtil(packet).logDLSError(I18NUtil.getMessage((I18NCode)I18NCode.MSG_GENERAL_SEND_SMTP_FAIL, (Object[])new String[]{e.getMessage() + ""}, (Locale)SDSLogger.getLocale()));
            }
            if (e instanceof MessagingException) {
                e = ((MessagingException)((Object)e)).getNextException();
                continue;
            }
            e = null;
        }
    }

    void logError(I18NCode code, String[] params) {
        this.logError(code, params, null);
    }

    void logError(I18NCode code, String[] params, String eventID) {
        String msg = null;
        Locale locale = SDSLogger.getLocale();
        if (params == null) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, code);
            msg = I18NUtil.getMessage((I18NCode)code, (Locale)locale);
        } else {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, code, (Object[])params);
            msg = I18NUtil.getMessage((I18NCode)code, (Object[])params, (Locale)locale);
        }
        if (eventID != null) {
            try {
                BiBusMonitorUtil.callMonitorServiceAddErrorMsg((String)msg, (String)eventID);
            }
            catch (TaskPersistLayerException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
            }
        }
    }

    private String getMessageSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        long tmp = Math.round((double)size / 1024.0);
        if (tmp < 1024L) {
            return tmp + " KB";
        }
        tmp = Math.round((double)tmp / 1024.0);
        return tmp + " MB";
    }

    class ResetTask
    implements Runnable {
        ConcurrentHashMap<String, Integer> senderMap;

        public ResetTask(ConcurrentHashMap<String, Integer> map) {
            this.senderMap = map;
        }

        @Override
        public void run() {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Reset the emailSender HashMap");
            this.senderMap.clear();
        }
    }
}

