/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.dls.DLSCategory;
import com.cognos.dls.smtp.SMTPProperties;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.AuditStatus;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.mailUtils.MailUtil;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import java.util.Map;
import java.util.Properties;

public class SMTPPropertiesFactory
implements SMTPProperties {
    public static final String DEFAULT_PORT = "25";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_SENDER_VALUE = "default@cognos.ibm.com";

    private SMTPPropertiesFactory() {
    }

    public static Properties getProperties() {
        CRNProperties theProperties = CRNProperties.getInstance();
        return SMTPPropertiesFactory.getProperties(theProperties);
    }

    static Properties getProperties(CRNProperties theProperties) {
        AuditProperties ap;
        AuditProperties ap2;
        String host = null;
        String port = DEFAULT_PORT;
        String user = null;
        String password = null;
        String emailEncoding = null;
        String defaultSender = null;
        String SSLencryptionEnabled = "false";
        String mailServer = null;
        try {
            mailServer = SMTPPropertiesFactory.getProp("smtpMailServer", theProperties);
        }
        catch (PropertiesException ex) {
            ap2 = AuditPropUtil.doProps(SMTPPropertiesFactory.class, (String)"Failure");
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES, (Map)ap2);
        }
        host = mailServer;
        if (mailServer.length() > 0 && mailServer.lastIndexOf(":") != -1) {
            host = mailServer.substring(0, mailServer.lastIndexOf(":"));
            port = mailServer.substring(mailServer.lastIndexOf(":") + 1, mailServer.length());
        }
        if (port != null && port.length() > 0) {
            try {
                port = Integer.parseInt(port) < 0 ? DEFAULT_PORT : port;
            }
            catch (NumberFormatException nfe) {
                ap2 = AuditPropUtil.doProps(SMTPPropertiesFactory.class, (String)"Failure");
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.FATAL, I18NCode.MSG_SMTP_PORT_WRONG_FORMAT, (Object[])new String[]{nfe.getMessage() + ""}, (Map)ap2);
            }
        }
        if (host == null) {
            ap = AuditPropUtil.doProps(SMTPPropertiesFactory.class, (String)"Warning");
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_NO_SMTP_SERVER_IS_DEFINED, (Map)ap);
        } else {
            ap = AuditPropUtil.doProps(SMTPPropertiesFactory.class, (String)AuditStatus.BLANK);
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.INFO, I18NCode.MSG_SMTP_SERVER_DEFINED, (Object[])new String[]{host, port}, (Map)ap);
        }
        try {
            user = SMTPPropertiesFactory.getProp("username", theProperties);
        }
        catch (PropertiesException ex) {
            ap2 = AuditPropUtil.doProps(SMTPPropertiesFactory.class, (String)"Failure");
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES, (Map)ap2);
        }
        try {
            password = SMTPPropertiesFactory.getProp("password", theProperties);
        }
        catch (PropertiesException ex) {
            ap2 = AuditPropUtil.doProps(SMTPPropertiesFactory.class, (String)"Failure");
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES, (Map)ap2);
        }
        try {
            emailEncoding = SMTPPropertiesFactory.getProp("emailEncoding", theProperties);
        }
        catch (PropertiesException ex) {
            ap2 = AuditPropUtil.doProps(SMTPPropertiesFactory.class, (String)"Failure");
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES, (Map)ap2);
        }
        if (emailEncoding.length() < 1) {
            emailEncoding = DEFAULT_ENCODING;
        }
        try {
            defaultSender = SMTPPropertiesFactory.getProp("defaultSender", theProperties);
        }
        catch (PropertiesException ex) {
            ap2 = AuditPropUtil.doProps(SMTPPropertiesFactory.class, (String)"Failure");
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES, (Map)ap2);
        }
        if (defaultSender.equals("")) {
            defaultSender = DEFAULT_SENDER_VALUE;
        }
        String authenticate = "false";
        if (user.trim().length() > 0 && password.length() > 0) {
            authenticate = "true";
        }
        try {
            SSLencryptionEnabled = SMTPPropertiesFactory.getProp("SSLencryptionEnabled", theProperties).trim();
        }
        catch (PropertiesException ex) {
            AuditProperties ap3 = AuditPropUtil.doProps(SMTPPropertiesFactory.class, (String)"Failure");
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES, (Map)ap3);
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", port);
        props.put("mail.smtp.user", user);
        props.put("mail.smtp.password", password);
        props.put("email.encoding", emailEncoding);
        props.put("default.sender", defaultSender);
        props.put("mail.smtp.auth", authenticate);
        props.put("mail.mime.address.strict", "true");
        props.put("mail.mime.encodeparameters", "false");
        props.put("mail.mime.encodefilename", "true");
        props.put("mail.ssl.encryption.enabled", "" + MailUtil.isSmtpsEncryptionEnabled());
        if (MailUtil.isTlsEnabled()) {
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.starttls.required", "true");
            if (MailUtil.getSMTP_SSL_Protocols() != null && MailUtil.getSMTP_SSL_Protocols().length() > 0) {
                props.put("mail.smtp.ssl.protocols", MailUtil.getSMTP_SSL_Protocols());
            } else {
                props.put("mail.smtp.ssl.protocols", "SSLv3 TLSv1 TLSv1.1 TLSv1.2");
            }
        }
        try {
            String smtpWriteTimeout;
            String smtpReadTimeout;
            String smtpConnTimeout = SMTPPropertiesFactory.getProp("emf.mail.smtp.connectiontimeout", theProperties);
            if (smtpConnTimeout.length() > 0) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug(SMTPPropertiesFactory.class, "MAIL_SMTP_CONNECTION_TIMEOUT:" + smtpConnTimeout);
                props.put("mail.smtp.connectiontimeout", smtpConnTimeout);
            }
            if ((smtpReadTimeout = SMTPPropertiesFactory.getProp("emf.mail.smtp.timeout", theProperties)).length() > 0) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug(SMTPPropertiesFactory.class, "MAIL_SMTP_READ_TIMEOUT:" + smtpReadTimeout);
                props.put("mail.smtp.timeout", smtpReadTimeout);
            }
            if ((smtpWriteTimeout = SMTPPropertiesFactory.getProp("emf.mail.smtp.writetimeout", theProperties)).length() > 0) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug(SMTPPropertiesFactory.class, "MAIL_SMTP_WRITE_TIMEOUT:" + smtpWriteTimeout);
                props.put("mail.smtp.writetimeout", smtpConnTimeout);
            }
        }
        catch (PropertiesException e) {
            AuditProperties ap4 = AuditPropUtil.doProps(SMTPPropertiesFactory.class, (String)"Failure");
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_TO_READ_PROPERTIES, (Map)ap4);
        }
        System.setProperty("mail.mime.encodeparameters", "false");
        System.setProperty("mail.mime.encodefilename", "true");
        return props;
    }

    private static String getProp(String key, CRNProperties theProperties) throws PropertiesException {
        String value = theProperties.getProperty(key);
        if (value == null) {
            value = "";
        }
        return value;
    }
}

