/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.AnyURIProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Document;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.URL;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.AbstractMemoObjectbuilder;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.LabelGenerator;
import com.cognos.dls.smtp.MimeMessageBuilderException;
import com.cognos.dls.smtp.MimeTextEncoder;
import com.cognos.dls.smtp.ProcessedLinks;
import com.cognos.dls.smtp.QueryRepliesHandler;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import java.util.Locale;
import javax.mail.internet.MimePart;

public class URLMemoObjectbuilder
extends AbstractMemoObjectbuilder {
    public URLMemoObjectbuilder(String emailEncoding, EmailOptionsDeliverable eod, MimeTextEncoder mimeTextEncoder) throws MimeMessageBuilderException {
        super(emailEncoding, eod, mimeTextEncoder);
    }

    @Override
    public ProcessedLinks buildLink(ObjectLink link) throws MimeMessageBuilderException {
        String label = link.getLabel();
        SearchPathSingleObject searchPath = link.getSearchPath();
        QueryRepliesHandler replies = this.getReplies(searchPath);
        if (null == label || label.length() <= 0) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.DEBUG, DlsI18NCode.MSG_DS_LABEL_NOT_AVAILABLE_GENERATING_ONE);
            label = this.getLabel(replies);
        }
        BaseClass base = replies.getBase();
        String url = null;
        if (null != base && base instanceof URL) {
            url = this.getUri(replies);
        } else if (null != base && base instanceof Document) {
            url = this.getBuiltSearchPath(searchPath);
            url = this.m_gateway + "?b_action=xts.run&m=portal/download.xts&format=application%2fvnd.coc-xl&m_download_obj=" + url + "/documentVersion[last()]/documentContent[last()]";
            url = url + "&m_name=" + this.encodeURLText(base.getDefaultName().getValue());
        }
        ProcessedLinks processedLink = new ProcessedLinks();
        if (url.length() > 0) {
            processedLink.appendHtmlUrl("<A href=\"");
            processedLink.appendHtmlUrl(url);
            processedLink.appendHtmlUrl("\">");
            processedLink.appendHtmlUrl(label);
            processedLink.appendHtmlUrl("</A>");
            processedLink.appendHtmlUrl("<br>");
            processedLink.appendTextUrl(label);
            processedLink.appendTextUrl("\n<");
            processedLink.appendTextUrl(url);
            processedLink.appendTextUrl(">");
            processedLink.appendTextUrl("\n");
        } else {
            String strMsg = label;
            if (null == label || label.length() <= 0) {
                strMsg = searchPath.get_value();
            }
            String msg = I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_URL_LINK_NOT_AVAILABLE, (Object)strMsg, (Locale)this.m_eod.getLocale());
            processedLink.appendHtmlUrl(msg);
            processedLink.appendTextUrl(msg);
        }
        return processedLink;
    }

    @Override
    public MimePart buildAttachment(MimePart bp, MemoPartObject mpo, QueryRepliesHandler replies) throws MimeMessageBuilderException {
        return null;
    }

    private QueryRepliesHandler getReplies(SearchPathSingleObject searchPath) {
        QueryRepliesHandler replies;
        block2: {
            replies = null;
            try {
                QueryReply[] repliesArray = this.getBaseObjects(searchPath);
                replies = new QueryRepliesHandler(repliesArray);
            }
            catch (MimeMessageBuilderException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).log(SDSLevel.INFO, DlsI18NCode.MSG_DS_GENERATING_LABEL_ERROR_WILL_CONTINUE);
                if (!SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).isLoggingAt(SDSLevel.DEBUG)) break block2;
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug((Throwable)((Object)e));
            }
        }
        return replies;
    }

    private String getLabel(QueryRepliesHandler replies) {
        String label = "";
        if (null != replies) {
            LabelGenerator generator = new LabelGenerator(this.m_eod);
            generator.generateURLLabel(replies.getBase());
            label = generator.getLinkLabel();
        }
        return label;
    }

    private String getUri(QueryRepliesHandler replies) {
        URL url;
        AnyURIProp uriProp;
        BaseClass base;
        String uri = "";
        if (null != replies && null != (base = replies.getBase()) && base instanceof URL && null != (uriProp = (url = (URL)base).getUri())) {
            uri = uriProp.getValue();
        }
        return uri;
    }

    protected String getBuiltSearchPath(SearchPathSingleObject searchPath) {
        String searchPathString = "";
        if (null != searchPath && null != searchPath.get_value()) {
            searchPathString = searchPath.get_value();
        }
        return this.encodeURLText(searchPathString);
    }

    @Override
    protected QueryRequest[] createObjectQueryRequests(String searchPath) {
        PropEnum[] properties = new PropEnum[]{PropEnum.defaultName, PropEnum.uri, PropEnum.storeID, PropEnum.objectClass};
        QueryRequest baseRequest = new QueryRequest();
        baseRequest.setSearch(searchPath);
        baseRequest.setProperties(properties);
        return new QueryRequest[]{baseRequest};
    }
}

