/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.smtp.rest.CogConfigRestClient;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.mail.internet.InternetAddress;

public class WhiteListAddressChecker {
    private static final String NOTIFICATION_SERVICE_WHITELISTDOMAINS = "NotificationService.whitelistdomains";
    static BiBusHeader m_bibusHeader = null;
    static WhiteListAddressChecker m_instance = new WhiteListAddressChecker();
    ArrayList<String> domainList = new ArrayList();
    static boolean whiteListPropSet;
    static String m_whitelistDomains;
    static boolean reset;

    public static WhiteListAddressChecker getInstance(BiBusHeader bibusHeader) {
        m_bibusHeader = bibusHeader;
        return m_instance;
    }

    public static WhiteListAddressChecker getInstance() {
        return m_instance;
    }

    public WhiteListAddressChecker() {
        String whitelistDomains = WhiteListAddressChecker.getEMAILWhitelistDomains();
        this.loadProperty(whitelistDomains);
    }

    public boolean loadProperty(String whitelistDomains) {
        if (null != whitelistDomains && whitelistDomains.length() > 1) {
            this.addDomainListStringAsListItems(whitelistDomains);
            whiteListPropSet = true;
        } else {
            whiteListPropSet = false;
        }
        return whiteListPropSet;
    }

    public void addDomainListStringAsListItems(String propertyValue) {
        StringTokenizer stk = new StringTokenizer(propertyValue, ",");
        this.domainList = null;
        this.domainList = new ArrayList();
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            this.domainList.add(token);
        }
    }

    private static String getEMAILWhitelistDomains() {
        String whitelistDomainsList = null;
        try {
            whitelistDomainsList = CRNProperties.getInstance().getProperty("emf.dls.whitelistdomains");
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("WhiteListAddressChecker : getEMAILWhitelistDomains from old config:emf.dls.whitelistdomains property value " + whitelistDomainsList);
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("WhiteListAddressChecker : getEMAILWhitelistDomains : error getting emf.dls.whitelistdomains property value");
        }
        return whitelistDomainsList;
    }

    public boolean isWhitelistConfigured() {
        return true;
    }

    private static String getGlobalEMAILWhitelistDomains() {
        String whitelistDomainsJson = null;
        String whiteListDomain = null;
        try {
            whitelistDomainsJson = CogConfigRestClient.callConfigRestServiceForKey(m_bibusHeader, NOTIFICATION_SERVICE_WHITELISTDOMAINS);
            JSONObject jsonObj = JSONObject.parse((String)whitelistDomainsJson);
            whiteListDomain = (String)jsonObj.get((Object)NOTIFICATION_SERVICE_WHITELISTDOMAINS);
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("WhiteListAddressChecker : getGlobalEMAILWhitelistDomains : error getting whiteListDomain");
        }
        return whiteListDomain;
    }

    public boolean hasAllowedDomain(InternetAddress internetAddress) {
        boolean result = false;
        if (null != internetAddress) {
            result = this.hasAllowedDomain(internetAddress.getAddress());
        }
        return result;
    }

    private String logicForWhitelistDomains() {
        String globalWhiteList = WhiteListAddressChecker.getGlobalEMAILWhitelistDomains();
        String whitelistOldConfigDomains = WhiteListAddressChecker.getEMAILWhitelistDomains();
        m_whitelistDomains = whitelistOldConfigDomains;
        if (m_whitelistDomains == null || m_whitelistDomains == "") {
            m_whitelistDomains = globalWhiteList;
        }
        reset = false;
        return m_whitelistDomains;
    }

    public static void reset(boolean resetFlag) {
        reset = resetFlag;
    }

    public boolean hasAllowedDomain(String internetAddress) {
        String domainOnly;
        int domainStart;
        String whitelistDomains = this.logicForWhitelistDomains();
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("WhiteListAddressChecker : list " + whitelistDomains);
        if (!this.loadProperty(whitelistDomains)) {
            return true;
        }
        boolean result = false;
        if (null != internetAddress && (domainStart = internetAddress.lastIndexOf("@")) > 2 && !(result = this.domainList.contains(domainOnly = internetAddress.substring(domainStart + 1)))) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("WhiteListAddressChecker : not in list " + domainOnly);
        }
        return result;
    }

    public void addAllowedDomain(String string) {
        this.domainList.add(string);
    }

    static {
        m_whitelistDomains = "";
        reset = true;
    }
}

