/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp.queue;

import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.dls.smtp.EmailOptionsDeliverable;
import com.cognos.dls.smtp.MalformedAddressException;
import com.cognos.dls.smtp.SMTPDeliveryChannel;
import com.cognos.dls.smtp.SMTPDispatcher;
import com.cognos.dls.smtp.queue.SMTPQueueMessageListener;
import com.cognos.dls.smtp.smtpRules.SmtpActionsManager;
import com.cognos.dls.smtp.smtpRules.SmtpRuleAction;
import com.cognos.dls.smtp.transport.TransportConnectionException;
import com.cognos.dls.smtp.transport.TransportException;
import com.cognos.dls.smtp.transport.TransportSendException;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jms.ChannelStatus;
import com.cognos.jsmcommon.jms.IDeliverable;
import com.cognos.jsmcommon.jms.IDeliveryChannel;
import com.cognos.jsmcommon.jms.client.BiBusMonitorUtil;
import com.cognos.jsmcommon.jms.client.JMSConnection;
import com.cognos.jsmcommon.jms.provider.NCJMSObjectMessage;
import com.cognos.jsmcommon.jms.resource.JMSProperties;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import com.ibm.cognos.jsmcommon.jms.MessageListener;
import com.ibm.cognos.jsmcommon.jms.ObjectMessage;
import com.ibm.cognos.jsmcommon.jms.Queue;
import com.ibm.cognos.jsmcommon.jms.QueueReceiver;
import com.ibm.cognos.jsmcommon.jms.QueueSender;
import com.ibm.cognos.jsmcommon.jms.QueueSession;
import com.ibm.cognos.jsmcommon.jms.Session;
import java.util.Locale;

public class SMTPQueueConsumerManager
implements Runnable {
    private static final String REQUEST_OPERATION = "dispatchMessage";
    private static final int DEFAULT_MAX_SESSIONS = 10;
    private static final int DEFAULT_MAIL_SERVER_RETRY_INTERVAL = 10;
    private static int DEFAULT_RESEND_COUNT = 1;
    private static SMTPQueueConsumerManager m_instance = new SMTPQueueConsumerManager();
    private int m_sessionCount = 0;
    private int m_maxSessions = 10;
    private int m_serverRetryInterval = 10;
    private JMSConnection m_connection;
    private IDeliveryChannel m_channel;
    private boolean m_started;
    private Thread m_managerThread;

    private SMTPQueueConsumerManager() {
        SMTPDispatcher dispatcher = new SMTPDispatcher();
        this.m_channel = new SMTPDeliveryChannel(dispatcher);
        dispatcher.setChannel(this.m_channel);
    }

    public static SMTPQueueConsumerManager getInstance() {
        return m_instance;
    }

    public static void reset() {
        try {
            if (!m_instance.isStopped()) {
                m_instance.stop();
                m_instance = new SMTPQueueConsumerManager();
                m_instance.start();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public synchronized void start() throws JMSException {
        if (this.isStopped()) {
            try {
                int retry;
                int val = CRNProperties.getInstance().getIntProperty("max.smtp.connections", 10);
                if (val >= 1) {
                    this.m_maxSessions = val;
                }
                if ((retry = CRNProperties.getInstance().getIntProperty("smtp.reconnection.delay", 10)) >= 1) {
                    this.m_serverRetryInterval = retry;
                }
                this.m_connection = this.createJMSConnection();
                this.m_connection.start();
                this.m_managerThread = new Thread((Runnable)this, "SMTPQueueConsumerManager");
                this.m_managerThread.setDaemon(true);
                this.m_managerThread.start();
                this.m_started = true;
            }
            catch (JMSException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, (Object[])new String[]{e.getLocalizedMessage()});
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Exception starting the SMTPQueueConsumerManager");
                throw e;
            }
        }
    }

    public synchronized void stop() throws JMSException {
        if (!this.isStopped()) {
            this.m_started = false;
            try {
                this.m_managerThread.interrupt();
                this.m_connection.close();
            }
            catch (JMSException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, (Object[])new String[]{e.getLocalizedMessage()});
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Exception stopping the SMTPQueueConsumerManager");
                throw e;
            }
            this.m_managerThread.interrupt();
            this.m_sessionCount = 0;
            this.m_connection = null;
        }
    }

    public synchronized boolean isStopped() {
        return !this.m_started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager entering run");
        while (!this.isStopped()) {
            try {
                this.checkMailServerOk();
                SMTPQueueConsumerManager sMTPQueueConsumerManager = this;
                synchronized (sMTPQueueConsumerManager) {
                    while (this.m_sessionCount < this.m_maxSessions && this.m_started) {
                        this.createListeningSession();
                        ++this.m_sessionCount;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (JMSException e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)e);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager exiting run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMailServerOk() {
        int retryTimes = -1;
        int count = 1;
        do {
            ChannelStatus cs;
            boolean channelOk;
            if (channelOk = (cs = this.m_channel.isChannelAvailable()).getStatus()) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("SMTPQueueConsumerManager: The mail server status is Ok");
                break;
            }
            Exception ex = cs.getException();
            if (null != ex && ex instanceof TransportConnectionException) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("SMTPQueueConsumerManager: Problem with mail server TransportConnectionException, " + cs);
                try {
                    TransportConnectionException tce = (TransportConnectionException)((Object)ex);
                    this.m_serverRetryInterval = tce.getAction().getBehaviour().getResends().getDelaySeconds();
                    if (this.m_serverRetryInterval < 10) {
                        this.m_serverRetryInterval = 10;
                    }
                    retryTimes = tce.getAction().getBehaviour().getResends().getNumber();
                }
                catch (Exception ex1) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("SMTPQueueConsumerManager: TransportConnectionException rules error so will apply default behaviour");
                }
                SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("SMTPQueueConsumerManager: TransportConnectionException using delayInterval " + this.m_serverRetryInterval + " seconds, retryTimes " + retryTimes);
            }
            ++count;
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("SMTPQueueConsumerManager: Problem with mail server, will test again in " + this.m_serverRetryInterval + " seconds");
            SMTPQueueConsumerManager sMTPQueueConsumerManager = this;
            synchronized (sMTPQueueConsumerManager) {
                try {
                    this.wait(this.m_serverRetryInterval * 1000);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        } while (retryTimes == -1 || count <= retryTimes);
    }

    private QueueSession createListeningSession() throws JMSException {
        QueueSession qs = this.m_connection.createQueueSession(false, 2);
        Queue queue = qs.createQueue(JMSProperties.getInstance().getProperty(JMSProperties.EMAIL_QUEUE_NAME));
        SMTPQueueMessageListener listener = new SMTPQueueMessageListener((Session)qs);
        QueueReceiver mc = qs.createReceiver(queue);
        mc.setMessageListener((MessageListener)listener);
        return qs;
    }

    private void recoverSession(SMTPQueueMessageListener listener) {
        Session session = listener.getSession();
        if (session != null) {
            try {
                session.recover();
            }
            catch (JMSException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)e);
            }
        }
    }

    protected void dispatchMessage(Message message, SMTPQueueMessageListener listener) {
        ThreadProperties.setProperty((String)"componentID", (String)"DLS");
        ThreadProperties.setProperty((String)"requestOperation", (String)REQUEST_OPERATION);
        String eventID = null;
        int eventID_index = 0;
        try {
            eventID = message.getStringProperty("eventID");
            eventID_index = message.getIntProperty("eventID_index_for_future_use");
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager.dispatchMessage with EventId: " + eventID + " Event Index: " + eventID_index);
        }
        catch (JMSException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager.dispatchMessage error extracting message props: " + e.getLocalizedMessage());
        }
        IDeliverable deliverable = this.getDeliverable(message);
        try {
            this.m_channel.dispatch(deliverable);
            this.handleAcknowledgeAction(message, listener, null);
        }
        catch (Throwable t) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, DlsI18NCode.MSG_DS_GENERAL_ERROR, new Object[]{"Error sending message [eventID=" + eventID + " eventID_index=" + eventID_index + " Exception: " + t.getLocalizedMessage()});
            SmtpRuleAction action = null;
            TransportException te = null;
            if (t instanceof TransportException) {
                te = (TransportException)((Object)t);
                action = te.getAction();
            } else if (!(t instanceof MalformedAddressException)) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(t);
                action = SmtpActionsManager.instance().getDefaultAction();
                if (t instanceof LocalizableException) {
                    LocalizableException le = (LocalizableException)t;
                    te = new TransportSendException(le.getI18NCode());
                } else {
                    String additionalErrorMessage = t.getLocalizedMessage();
                    additionalErrorMessage = additionalErrorMessage == null ? "" : additionalErrorMessage;
                    Object[] params = new String[]{additionalErrorMessage};
                    te = new TransportSendException(DlsI18NCode.MSG_DS_GENERAL_ERROR, params, t);
                }
            }
            if (action != null) {
                if (action.recover()) {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager.handleAcknowledgeAction with EventId: " + eventID + " Event Index: " + eventID_index + " error - action.recover()");
                    this.handleRecoverAction(message, listener, deliverable, te);
                } else {
                    if (action.failMail()) {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager.handleAcknowledgeAction with EventId: " + eventID + " Event Index: " + eventID_index + " error - action.failMail()");
                        this.doFailMail((EmailOptionsDeliverable)deliverable, te);
                    }
                    if (action.errorQueue()) {
                        SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager.handleAcknowledgeAction with EventId: " + eventID + " Event Index: " + eventID_index + " error - action.errorQueue()");
                        this.handleErrorQueueAction(message, listener);
                    }
                    this.handleAcknowledgeAction(message, listener, t);
                }
            }
            this.handleAcknowledgeAction(message, listener, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAcknowledgeAction(Message message, SMTPQueueMessageListener listener, Throwable t) {
        String eventID = null;
        EventStatus status = EventStatus.FAILED;
        int eventID_index = 0;
        String credentialPath = null;
        String passport = null;
        try {
            eventID = message.getStringProperty("eventID");
            eventID_index = message.getIntProperty("eventID_index_for_future_use");
            credentialPath = message.getStringProperty("credentialPath");
            passport = message.getStringProperty("passport");
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager.handleAcknowledgeAction with EventId: " + eventID + " Event Index: " + eventID_index);
        }
        catch (JMSException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager.handleAcknowledgeAction error extracting message props: " + e.getLocalizedMessage());
        }
        try {
            message.acknowledge();
            status = EventStatus.SUCCEEDED;
            if (t != null && t instanceof MalformedAddressException) {
                status = EventStatus.FAILED;
            }
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager.handleAcknowledgeAction with EventId: " + eventID + " Event Index: " + eventID_index + " message acknowledged with status " + status);
        }
        catch (JMSException jmse) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)jmse);
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager.handleAcknowledgeAction with EventId: " + eventID + " JMSException: " + (Object)((Object)jmse));
        }
        finally {
            try {
                if (eventID != null && status != null) {
                    BiBusMonitorUtil.callMonitorServiceNotify((String)passport, (String)credentialPath, (String)eventID, (int)eventID_index, (EventStatus)status);
                } else {
                    SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager.handleAcknowledgeAction with EventId null - MS.notify not required");
                }
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager.handleAcknowledgeAction with EventId: " + eventID + " Event Index: " + eventID_index + " SDKClientException: " + (Object)((Object)e));
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("SMTPQueueConsumerManager.handleAcknowledgeAction with EventId: " + eventID + " Event Index: " + eventID_index + " EMFSecurityException: " + (Object)((Object)e));
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)e);
            }
        }
    }

    private void handleRecoverAction(Message message, SMTPQueueMessageListener listener, IDeliverable deliverable, TransportException te) {
        int resend_max;
        boolean msgRedelivered = false;
        int redeliveredCount = 0;
        try {
            msgRedelivered = message.getJMSRedelivered();
            redeliveredCount = message.getIntProperty("redelivered.count");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        SmtpRuleAction action = te.getAction();
        int n = resend_max = action != null ? action.resends() : DEFAULT_RESEND_COUNT;
        if (!(resend_max != -1 && redeliveredCount >= resend_max || msgRedelivered && redeliveredCount == 0)) {
            try {
                message.setStringProperty(JMSProperties.RECOVER_DELAY_NAME.getKey(), String.valueOf(action.getBehaviour().getResends().getDelaySeconds()));
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.recoverSession(listener);
        } else {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug("Reached redeliver max, sending fail message");
            if (action != null && action.failMail()) {
                this.doFailMail((EmailOptionsDeliverable)deliverable, te);
            }
            if (action.errorQueue()) {
                this.handleErrorQueueAction(message, listener);
            }
            this.handleAcknowledgeAction(message, listener, null);
        }
    }

    private void doFailMail(EmailOptionsDeliverable eod, TransportException te) {
        try {
            Locale locale = eod.getLocale();
            String msg = I18NUtil.getMessage((I18NCode)DlsI18NCode.MSG_DS_SENT_FAILURE_NOTIFICATION, (Locale)locale);
            String eventID = OptionUtils.extractEventIDfromOptions((Option[])eod.getOptions());
            if (eventID != null) {
                BiBusMonitorUtil.callMonitorServiceAddInfoMsg((String)msg, (String)eventID);
            }
            ((SMTPDeliveryChannel)this.m_channel).dispatchFailMessage(eod, te);
        }
        catch (LocalizableException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, e);
        }
    }

    private void handleErrorQueueAction(Message message, SMTPQueueMessageListener listener) {
        try {
            QueueSession qs = this.m_connection.createQueueSession(false, 2);
            Queue queue = qs.createQueue(JMSProperties.getInstance().getProperty(JMSProperties.EMAIL_BACKUP_QUEUE_NAME));
            ObjectMessage om = qs.createObjectMessage();
            om.setObject(((ObjectMessage)message).getObject());
            QueueSender sender = qs.createSender(queue);
            sender.send((Message)om);
        }
        catch (JMSException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)e);
        }
    }

    private IDeliverable getDeliverable(Message message) {
        IDeliverable nc_message = null;
        try {
            NCJMSObjectMessage bm = (NCJMSObjectMessage)message;
            nc_message = (IDeliverable)bm.getObject();
            message.clearBody();
        }
        catch (JMSException e) {
            this.logPreDeliveryError(I18NCode.MSG_UNABLE_RECOVER_JMS_MESSAGE);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug((Throwable)e);
        }
        catch (Throwable e) {
            this.logPreDeliveryError(I18NCode.MSG_UNABLE_RECOVER_JMS_MESSAGE);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug(e);
        }
        return nc_message;
    }

    private void logPreDeliveryError(I18NCode i18Ncode) {
        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, i18Ncode);
    }

    private JMSConnection createJMSConnection() throws JMSException {
        JMSConnection conn = null;
        try {
            conn = new JMSConnection("SMTP");
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.DEBUG, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{e.getMessage()});
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.INFO, I18NCode.MSG_BINDING_CONTEXT_CLASSPATH_ERROR);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.FATAL, I18NCode.MSG_UNABLE_EST_JMS_CONNECTION);
            throw new JMSException(e.getLocalizedMessage());
        }
        return conn;
    }
}

