/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp.rest;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.dls.DLSCategory;
import com.cognos.dls.smtp.rest.CogConfigRestClient;
import com.cognos.dls.smtp.rest.DefaultSenderConfig;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import java.util.Hashtable;

public class CogConfigRestCache {
    private static CogConfigRestCache _instance = new CogConfigRestCache();
    private CogConfigRestClient cogConfigRestClient = new CogConfigRestClient();
    private static String m_cacheGlobalDefaultSender;
    private static Hashtable<String, String> m_defaultSenderTenantData;
    static boolean alwaysGet;

    public static CogConfigRestCache getinstance() {
        return _instance;
    }

    private CogConfigRestCache() {
    }

    public static void reset(boolean restFlag) {
        alwaysGet = restFlag;
    }

    public String getDefaultSenderOfTenant(String tenantId, BiBusHeader header, String email) {
        String tenantDefaultSender = null;
        String result = email;
        alwaysGet = CRNProperties.getInstance().getBoolAdvancedPropertyValue("dls.smtp.sender.refresh.always", false);
        if (null != tenantId && !tenantId.equals("")) {
            boolean wasTenantEmailReadBefore = m_defaultSenderTenantData.containsKey(tenantId);
            if (!wasTenantEmailReadBefore || alwaysGet) {
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" CogConfigRestCache : getDefaultSenderOfTenantfromCache making call to config ");
                if (header != null) {
                    tenantDefaultSender = DefaultSenderConfig.getDefaultSenderOfTenant(tenantId, header, email);
                }
                result = tenantDefaultSender;
                if (null != tenantDefaultSender) {
                    m_defaultSenderTenantData.put(tenantId, tenantDefaultSender);
                } else {
                    m_defaultSenderTenantData.put(tenantId, "SENDER_NOT_DEFINED");
                    result = null;
                }
                alwaysGet = false;
            } else {
                tenantDefaultSender = m_defaultSenderTenantData.get(tenantId);
                result = tenantDefaultSender == "SENDER_NOT_DEFINED" ? null : tenantDefaultSender;
                SDSLogger.getLogger((SDSCategory)DLSCategory.RUNTIME).debug(" CogConfigRestCache : getDefaultSenderOfTenantfromCache using cache default sender ");
            }
        }
        return result;
    }

    public String getDefaultSenderOfTenant(BiBusHeader header, String email) {
        String tenantId = DefaultSenderConfig.getTenantIdFromHeader(header, CogConfigRestClient.readTenantInfoFlag);
        return this.getDefaultSenderOfTenant(tenantId, header, email);
    }

    protected void setDefaultSenderOfTenant(String tenantId, String email) {
        m_defaultSenderTenantData.put(tenantId, email);
    }

    protected void setGlobalDefaultSenderID(String email) {
        m_cacheGlobalDefaultSender = email;
    }

    public static String getGlobalDefaultSenderID(BiBusHeader header, String email) {
        String result = m_cacheGlobalDefaultSender;
        if (null == m_cacheGlobalDefaultSender) {
            m_cacheGlobalDefaultSender = DefaultSenderConfig.getGlobalDefaultSenderID(header, email);
            if (m_cacheGlobalDefaultSender == null) {
                m_cacheGlobalDefaultSender = "GLOBAL_SENDER_NOT_DEFINED";
            }
            result = m_cacheGlobalDefaultSender;
        }
        if (m_cacheGlobalDefaultSender == "GLOBAL_SENDER_NOT_DEFINED") {
            result = null;
        }
        return result;
    }

    static {
        m_defaultSenderTenantData = new Hashtable();
        alwaysGet = false;
    }
}

