/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.dls.smtp.rest;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.dls.DLSCategory;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.ServerConfigPropertyUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.httpclient.Cookie;

public class CogConfigRestClient {
    protected static final String GLOBAL_SENDER_NOT_DEFINED = "GLOBAL_SENDER_NOT_DEFINED";
    protected static final String SENDER_NOT_DEFINED = "SENDER_NOT_DEFINED";
    protected static int readTenantInfoFlag = 1;
    private static final String COOKIE_XSRF_TOKEN = "XSRF-TOKEN";
    private static final String COOKIE_PATH_BI_V1 = "/bi/v1";
    private static final String CAM_PASSPORT = "cam_passport";
    private static final String USERSESSIONID = "usersessionid";
    private static final String COOKIE_PATH_BI = "/bi";
    private static final String USER_CAPABILITIES = "userCapabilities";
    private static final String XSRF_TOKEN = "XSRF-TOKEN";
    private static final String CONFIG_TENANT_NC_DEF_SENDER_PATH = "configuration/tenants/%s/notification";
    private static final String CONFIG_GLOBAL_NC_DEF_SENDER_PATH = "configuration/keys/global/NC.defaultSender";
    private static final String CONFIG_URL_BASE = "/bi/v1/configuration/keys";

    public static String callConfigRestServiceForTenant(String internalDispURI, BiBusHeader bibusHeader, String tenantId) throws Exception {
        return CogConfigRestClient.callConfigRestServiceForSender(bibusHeader, tenantId);
    }

    public static String callConfigRestServiceForGlobalDefSender(String internalDispURI, BiBusHeader bibusHeader) throws Exception {
        return CogConfigRestClient.callConfigRestServiceForSender(bibusHeader, null);
    }

    public static String callConfigRestServiceForSender(BiBusHeader bibusHeader, String tenantId) throws Exception {
        URL url = CogConfigRestClient.getNotificationIdRestURL(tenantId);
        return CogConfigRestClient.makeRestCall(bibusHeader, url);
    }

    public static String callConfigRestServiceForKey(BiBusHeader bibusHeader, String propName) throws Exception {
        URL url = CogConfigRestClient.getpropKeyRestURL(propName);
        String response = null;
        response = CogConfigRestClient.makeRestCall(bibusHeader, url);
        SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLS.CogConfigRestClient for property:" + propName + " result: " + response);
        return response;
    }

    private static String cleanIntDispatcherURI() {
        String dispURI = null;
        try {
            dispURI = ServerConfigPropertyUtils.getInternalDispatcher();
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("DLS.CogConfigRestClient cleanIntDispatcherURI(): URI: " + dispURI + " error: " + e.getMessage());
        }
        try {
            URI theURI = new URI(dispURI);
            dispURI = theURI.getScheme() + "://" + theURI.getHost() + ":" + theURI.getPort() + "/bi/v1/";
        }
        catch (URISyntaxException e) {
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).error("DLS.CogConfigRestClient cleanIntDispatcherURI():" + e.getMessage());
        }
        return dispURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeRestCall(BiBusHeader bibusHeader, URL url) throws IOException, ProtocolException, MalformedURLException {
        StringBuffer response = new StringBuffer();
        HttpURLConnection conn = null;
        try {
            String output;
            conn = CogConfigRestClient.addRequestPropertiesToURLHeader(bibusHeader, url);
            String cookiesData = CogConfigRestClient.generateCookieData(bibusHeader, url);
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLS.CogConfigRestClient Cookie:" + cookiesData);
            conn.addRequestProperty("Cookie", cookiesData);
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((output = br.readLine()) != null) {
                response.append(output);
            }
            conn.disconnect();
            SDSLogger.getLogger((SDSCategory)DLSCategory.TRACE).debug("DLS.CogConfigRestClient Output from Server .. " + response);
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return response.toString();
    }

    private static URL getNotificationIdRestURL(String tenantId) throws MalformedURLException {
        String internalDispURI = CogConfigRestClient.cleanIntDispatcherURI();
        String notificationIdURL = internalDispURI + CONFIG_GLOBAL_NC_DEF_SENDER_PATH;
        if (tenantId != null) {
            notificationIdURL = internalDispURI + String.format(CONFIG_TENANT_NC_DEF_SENDER_PATH, tenantId);
        }
        URL url = new URL(notificationIdURL);
        return url;
    }

    private static URL getpropKeyRestURL(String propName) throws MalformedURLException {
        String notificationIdURL = CogConfigRestClient.cleanIntDispatcherURI();
        if (propName != null) {
            notificationIdURL = notificationIdURL + "configuration/keys/" + propName;
        }
        URL url = new URL(notificationIdURL);
        return url;
    }

    private static HttpURLConnection addRequestPropertiesToURLHeader(BiBusHeader bibusHeader, URL url) throws IOException, ProtocolException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.addRequestProperty("Accept", "application/json");
        conn.addRequestProperty("Content-Type", "application/json");
        String xsrfTokenValue = CogConfigRestClient.getCookieValFromBiBusHeaderSession(bibusHeader, "XSRF-TOKEN");
        conn.addRequestProperty("X-XSRF-TOKEN", xsrfTokenValue);
        return conn;
    }

    private static String generateCookieData(BiBusHeader bibusHeader, URL url) {
        String hostname = url.getHost();
        String xsrfTokenValue = CogConfigRestClient.getCookieValFromBiBusHeaderSession(bibusHeader, "XSRF-TOKEN");
        String usersessionidVal = CogConfigRestClient.getCookieValFromBiBusHeaderSession(bibusHeader, USERSESSIONID);
        String cam_passportVal = CogConfigRestClient.getCookieValFromBiBusHeaderSession(bibusHeader, CAM_PASSPORT);
        String userCapabilitiesVal = CogConfigRestClient.getCookieValFromBiBusHeaderSession(bibusHeader, USER_CAPABILITIES);
        String camCookieStr = CogConfigRestClient.createCookie(CAM_PASSPORT, cam_passportVal, hostname, COOKIE_PATH_BI_V1).toExternalForm();
        String xsrfCookieStr = CogConfigRestClient.createCookie("XSRF-TOKEN", xsrfTokenValue, hostname, COOKIE_PATH_BI).toExternalForm();
        String userSessionCookieStr = CogConfigRestClient.createCookie(USERSESSIONID, usersessionidVal, hostname, COOKIE_PATH_BI).toExternalForm();
        String userCapabilitiesCookieStr = CogConfigRestClient.createCookie(USER_CAPABILITIES, userCapabilitiesVal, hostname, COOKIE_PATH_BI).toExternalForm();
        String cookiesData = camCookieStr + "; " + xsrfCookieStr + "; " + userSessionCookieStr + "; " + userCapabilitiesCookieStr;
        return cookiesData;
    }

    private static Cookie createCookie(String cookieName, String cookieVal, String hostname, String path) {
        Cookie camCookie = new Cookie();
        camCookie.setName(cookieName);
        camCookie.setValue(cookieVal);
        camCookie.setDomain(hostname);
        camCookie.setPath(path);
        return camCookie;
    }

    private static String getCookieValFromBiBusHeaderSession(BiBusHeader header, String keyName) {
        CookieVar[] cookieVars;
        String result = null;
        for (CookieVar element : cookieVars = header.getHdrSession().getCookieVars()) {
            if (!element.getName().equals(keyName)) continue;
            result = element.getValue();
            break;
        }
        return result;
    }
}

